/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.apps.servers.http;

import gplx.Bry_;
import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.Bry_find_;
import gplx.Err_;
import gplx.GfoMsg;
import gplx.Gfo_invk;
import gplx.Gfo_invk_;
import gplx.GfsCtx;
import gplx.Hash_adp_bry;
import gplx.Io_url_;
import gplx.Object_;
import gplx.String_;
import gplx.core.envs.Op_sys;
import gplx.core.ios.streams.Io_stream_rdr;
import gplx.core.ios.streams.Io_stream_rdr_;
import gplx.core.net.Http_client_rdr;
import gplx.core.net.Http_client_rdr_;
import gplx.core.net.Http_client_wtr;
import gplx.core.net.Http_client_wtr_;
import gplx.core.net.Http_request_itm;
import gplx.core.net.Http_request_parser;
import gplx.core.net.Http_server_wtr;
import gplx.core.net.Socket_adp;
import gplx.core.primitives.Int_obj_val;
import gplx.langs.htmls.encoders.Gfo_url_encoder;
import gplx.xowa.Xoae_app;
import gplx.xowa.apps.Xoa_app_mode;
import gplx.xowa.apps.servers.http.Http_data__client;
import gplx.xowa.apps.servers.http.Http_file_utl;
import gplx.xowa.apps.servers.http.Http_server_mgr;
import gplx.xowa.apps.servers.http.Xosrv_http_wkr_;

class Http_server_wkr
implements Gfo_invk {
    private final int uid;
    private final Http_server_mgr server_mgr;
    private final Http_server_wtr server_wtr;
    private final Http_client_wtr client_wtr = Http_client_wtr_.new_stream();
    private final Http_client_rdr client_rdr = Http_client_rdr_.new_stream();
    private final Http_request_parser request_parser;
    private final Gfo_url_encoder url_encoder;
    private final Xoae_app app;
    private final String root_dir_http;
    private final byte[] root_dir_fsys;
    private final Bry_bfr tmp_bfr = Bry_bfr_.New_w_size(64);
    private Socket_adp socket;
    private Http_data__client data__client;
    private static final byte[] Key__msg = Bry_.new_a7("msg");
    private static final byte[] Key__app_mode = Bry_.new_a7("app_mode");
    private static final int Tid_post_url_json = 1;
    private static final int Tid_post_url_gfs = 2;
    private static final Hash_adp_bry post_url_hash = Hash_adp_bry.ci_a7().Add_str_int("/exec/json", 1).Add_str_int("/exec/gfs", 2);
    public static final String Invk_run = "run";
    private static final byte[] Url__home = Bry_.new_a7("/");
    private static final byte[] Url__fsys = Bry_.new_a7("/fsys/");
    private static final byte[] Url__exec = Bry_.new_a7("/exec/");
    private static final byte[] Url__exec_2 = Bry_.new_a7("/xowa-cmd:");
    private static final int Url__fsys_len = Url__fsys.length;

    public Http_server_wkr(Http_server_mgr http_server_mgr, int n) {
        this.server_mgr = http_server_mgr;
        this.uid = n;
        this.app = http_server_mgr.App();
        this.server_wtr = http_server_mgr.Server_wtr();
        this.url_encoder = http_server_mgr.Encoder();
        this.root_dir_http = this.app.Fsys_mgr().Root_dir().To_http_file_str();
        this.root_dir_fsys = Bry_.new_u8(this.app.Fsys_mgr().Root_dir().Raw());
        this.request_parser = http_server_mgr.Request_parser();
    }

    public void Init_by_thread(Socket_adp socket_adp) {
        this.socket = socket_adp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Run() {
        Http_request_itm http_request_itm = null;
        try {
            this.client_rdr.Stream_(this.socket.Get_input_stream());
            this.client_wtr.Stream_(this.socket.Get_output_stream());
            http_request_itm = this.request_parser.Parse(this.client_rdr);
            this.data__client = new Http_data__client(http_request_itm.Host(), this.socket.Ip_address());
            byte[] byArray = http_request_itm.Url();
            if (Bry_.Eq(byArray, Url__home)) {
                byArray = this.server_mgr.Home();
            }
            switch (http_request_itm.Type()) {
                case 1: {
                    this.Process_get(http_request_itm, byArray);
                    break;
                }
                case 2: {
                    this.Process_post(http_request_itm);
                }
            }
            this.client_wtr.Rls();
        }
        catch (Exception exception) {
            String string = http_request_itm == null ? "<<NULL>>" : http_request_itm.To_str(this.tmp_bfr, false);
            this.server_wtr.Write_str_w_nl(String_.Format("failed to process request;\nrequest={0}\nerr_msg={1}", string, Err_.Message_gplx_full(exception)));
        }
        finally {
            if (this.uid != -1) {
                this.server_mgr.Wkr_pool().Del(this.uid);
                this.server_mgr.Uid_pool().Del(this.uid);
            }
        }
    }

    private void Process_get(Http_request_itm http_request_itm, byte[] byArray) {
        this.server_wtr.Write_str_w_nl(String_.new_u8(http_request_itm.Host()) + "|GET|" + String_.new_u8(http_request_itm.Url()));
        if (Bry_.Has_at_bgn(byArray, Url__fsys)) {
            this.Serve_file(byArray);
        } else if (Bry_.Has_at_bgn(byArray, Url__exec)) {
            this.Exec_exec(byArray, Url__exec);
        } else if (Bry_.Has_at_bgn(byArray, Url__exec_2)) {
            this.Exec_exec(byArray, Url__exec_2);
        } else {
            this.Write_wiki(byArray);
        }
    }

    private void Serve_file(byte[] byArray) {
        this.tmp_bfr.Clear().Add(this.root_dir_fsys);
        int n = Bry_find_.Find_fwd(byArray, (byte)63);
        int n2 = Bry_.Has_at_bgn(byArray, Url__fsys) ? Url__fsys_len : 0;
        int n3 = n == -1 ? byArray.length : n;
        this.url_encoder.Decode(this.tmp_bfr, false, byArray, n2, n3);
        byte[] byArray2 = this.tmp_bfr.To_bry_and_clear();
        if (Op_sys.Cur().Tid_is_wnt()) {
            byArray2 = Bry_.Replace(byArray2, (byte)92, (byte)47);
        }
        this.client_wtr.Write_bry(Xosrv_http_wkr_.Rsp__http_ok);
        String string = String_.new_u8(Http_file_utl.To_mime_type_by_path_as_bry(byArray2));
        this.client_wtr.Write_str("Content-Type: " + string + "\n\n");
        Io_stream_rdr io_stream_rdr = Io_stream_rdr_.New_by_url(Io_url_.new_fil_(String_.new_u8(byArray2))).Open();
        this.client_wtr.Write_stream(io_stream_rdr);
        io_stream_rdr.Rls();
        this.client_rdr.Rls();
        this.socket.Rls();
    }

    private void Exec_exec(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = Bry_.Mid(byArray, byArray2.length);
        this.app.Http_server().Run_xowa_cmd(this.app, String_.new_u8(byArray3));
    }

    private void Write_wiki(byte[] byArray) {
        String string = "";
        String string2 = "";
        String[] stringArray = String_.Split(String_.new_u8(byArray), "/");
        if (stringArray.length >= 1) {
            string = stringArray[1];
        }
        if (stringArray.length >= 4) {
            string2 = stringArray[3];
            for (int i = 4; i <= stringArray.length - 1; ++i) {
                string2 = string2 + "/" + stringArray[i];
            }
            string2 = this.url_encoder.Decode_str(string2);
        }
        String string3 = this.app.Http_server().Parse_page_to_html(this.data__client, Bry_.new_u8(string), Bry_.new_u8(string2));
        string3 = Http_server_wkr.Convert_page(string3, this.root_dir_http, string);
        Xosrv_http_wkr_.Write_response_as_html(this.client_wtr, false, string3);
    }

    private void Process_post(Http_request_itm http_request_itm) {
        byte[] byArray = http_request_itm.Post_data_hash().Get_by(Key__msg).Val();
        byte[] byArray2 = http_request_itm.Post_data_hash().Get_by(Key__app_mode).Val();
        Xoa_app_mode xoa_app_mode = Xoa_app_mode.parse(String_.new_u8(byArray2));
        this.server_wtr.Write_str_w_nl(String_.new_u8(http_request_itm.Host()) + "|POST|" + String_.new_u8(byArray));
        Object object = post_url_hash.Get_by_bry(http_request_itm.Url());
        if (object == null) {
            throw Err_.new_wo_type("unknown url", "url", http_request_itm.Url(), "request", http_request_itm.To_str(this.tmp_bfr, false));
        }
        String string = null;
        switch (((Int_obj_val)object).Val()) {
            case 1: {
                string = this.app.Html__bridge_mgr().Cmd_mgr().Exec(byArray);
                break;
            }
            case 2: {
                string = Object_.Xto_str_strict_or_null_mark(this.app.Gfs_mgr().Run_str(String_.new_u8(byArray)));
            }
        }
        if (xoa_app_mode.Tid_is_http()) {
            string = Http_server_wkr.Convert_page(string, this.root_dir_http, "<<MISSING_WIKI>>");
        }
        Xosrv_http_wkr_.Write_response_as_html(this.client_wtr, xoa_app_mode.Tid() == Xoa_app_mode.Itm_file.Tid(), string);
    }

    private static String Convert_page(String string, String string2, String string3) {
        string = String_.Replace(string, string2, "/fsys/");
        string = String_.Replace(string, "xowa-cmd:", "/exec/");
        string = String_.Replace(string, "<a href=\"/wiki/", "<a href=\"/" + string3 + "/wiki/");
        string = String_.Replace(string, "<a href='/wiki/", "<a href='/" + string3 + "/wiki/");
        string = String_.Replace(string, "action=\"/wiki/", "action=\"/" + string3 + "/wiki/");
        string = String_.Replace(string, "/site", "");
        return string;
    }

    @Override
    public Object Invk(GfsCtx gfsCtx, int n, String string, GfoMsg gfoMsg) {
        if (!gfsCtx.Match(string, Invk_run)) {
            return Gfo_invk_.Rv_unhandled;
        }
        this.Run();
        return this;
    }
}

