/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.addons.wikis.searchs.bldrs;

import gplx.Bry_fmt;
import gplx.Err_;
import gplx.Gfo_usr_dlg_;
import gplx.Int_;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.String_;
import gplx.dbs.Db_attach_itm;
import gplx.dbs.Db_attach_mgr;
import gplx.dbs.Db_conn;
import gplx.dbs.Db_conn_bldr;
import gplx.dbs.Db_rdr;
import gplx.dbs.Db_stmt;
import gplx.dbs.Dbmeta_fld_itm;
import gplx.dbs.Dbmeta_idx_itm;
import gplx.dbs.Dbmeta_tbl_itm;
import gplx.dbs.engines.sqlite.Sqlite_conn_info;
import gplx.xowa.Xoa_app_;
import gplx.xowa.Xow_wiki;
import gplx.xowa.Xowe_wiki;
import gplx.xowa.addons.wikis.searchs.Srch_search_addon;
import gplx.xowa.addons.wikis.searchs.dbs.Srch_db_mgr;
import gplx.xowa.addons.wikis.searchs.dbs.Srch_link_tbl;
import gplx.xowa.addons.wikis.searchs.dbs.Srch_temp_tbl;
import gplx.xowa.addons.wikis.searchs.parsers.Srch_text_parser;
import gplx.xowa.addons.wikis.searchs.parsers.Srch_text_parser_wkr;
import gplx.xowa.addons.wikis.searchs.parsers.Srch_word_itm;
import gplx.xowa.wikis.data.Xow_db_mgr;
import gplx.xowa.wikis.data.tbls.Xowd_page_tbl;

class Srch_temp_tbl_wkr
implements Srch_text_parser_wkr {
    private Xowe_wiki wiki;
    private Xow_db_mgr core_data_mgr;
    private Srch_search_addon search_addon;
    private Srch_text_parser title_parser;
    private Srch_temp_tbl search_temp_tbl;
    private int word_id;
    private int page_id;

    Srch_temp_tbl_wkr() {
    }

    public Srch_temp_tbl_wkr Init(boolean bl, Xowe_wiki xowe_wiki) {
        this.wiki = xowe_wiki;
        this.core_data_mgr = xowe_wiki.Db_mgr_as_sql().Core_data_mgr();
        this.search_addon = Srch_search_addon.Get(xowe_wiki);
        this.title_parser = this.search_addon.Ttl_parser();
        this.word_id = 0;
        Srch_db_mgr srch_db_mgr = this.search_addon.Db_mgr();
        if (bl && srch_db_mgr.Tbl__word() != null) {
            srch_db_mgr.Delete_all(this.core_data_mgr);
        }
        srch_db_mgr.Create_all();
        this.search_temp_tbl = new Srch_temp_tbl(srch_db_mgr.Tbl__word().conn);
        this.search_temp_tbl.Insert_bgn();
        return this;
    }

    public void Term() {
        this.search_temp_tbl.Insert_end();
        Srch_db_mgr srch_db_mgr = this.search_addon.Db_mgr().Init(this.wiki.Stats().Num_pages());
        Db_conn db_conn = this.search_temp_tbl.conn;
        this.Update_word_id(db_conn, this.wiki);
        Srch_temp_tbl_wkr.Search_word__insert(db_conn);
        Db_conn db_conn2 = this.wiki.Data__core_mgr().Tbl__page().Conn();
        if (srch_db_mgr.Tbl__link__len() == 1) {
            Xoa_app_.Usr_dlg().Plog_many("", "", "creating search_link", new Object[0]);
            Srch_link_tbl srch_link_tbl = srch_db_mgr.Tbl__link__ary()[0];
            new Db_attach_mgr(db_conn, new Db_attach_itm("link_db", srch_link_tbl.conn)).Exec_sql(String_.Concat_lines_nl_skip_last("INSERT INTO <link_db>search_link (word_id, page_id)", "SELECT  w.word_id", ",       t.page_id", "FROM    search_temp t", "        JOIN search_word w ON t.word_text = w.word_text"), new Object[0]);
            srch_link_tbl.Create_idx__page_id();
        } else {
            Srch_temp_tbl_wkr.Search_link__insert(srch_db_mgr, db_conn, db_conn2);
        }
        db_conn.Meta_tbl_delete(this.search_temp_tbl.tbl_name);
    }

    private static void Search_link__insert(Srch_db_mgr srch_db_mgr, Db_conn db_conn, Db_conn db_conn2) {
        Db_attach_mgr db_attach_mgr = new Db_attach_mgr();
        db_conn2.Meta_idx_create(Dbmeta_idx_itm.new_normal_by_tbl("page", "page_ns__page_id", "page_namespace", "page_id"));
        Srch_db_mgr.Optimize_unsafe_(db_conn, true);
        db_conn.Meta_tbl_remake(Dbmeta_tbl_itm.New("search_link_temp", Dbmeta_fld_itm.new_int("word_id"), Dbmeta_fld_itm.new_int("page_id"), Dbmeta_fld_itm.new_int("page_namespace")));
        db_attach_mgr.Conn_main_(db_conn).Conn_links_(new Db_attach_itm("page_db", db_conn2));
        db_attach_mgr.Exec_sql_w_msg("filling search_link_temp (please wait)", String_.Concat_lines_nl_skip_last("INSERT INTO search_link_temp (word_id, page_id, page_namespace)", "SELECT  w.word_id", ",       t.page_id", ",       p.page_namespace", "FROM    search_temp t", "        JOIN search_word w ON t.word_text = w.word_text", "        JOIN <page_db>page p ON t.page_id = p.page_id"), new Object[0]);
        db_conn.Meta_idx_create(Dbmeta_idx_itm.new_normal_by_name("search_link_temp", "main", "page_namespace", "word_id", "page_id"));
        Srch_db_mgr.Optimize_unsafe_(db_conn, false);
        db_conn2.Meta_idx_delete("page", "page_ns__page_id");
        int n = srch_db_mgr.Tbl__link__len();
        for (int i = 0; i < n; ++i) {
            Xoa_app_.Usr_dlg().Plog_many("", "", "creating search_link_temp: ~{0}", i);
            Srch_link_tbl srch_link_tbl = srch_db_mgr.Tbl__link__ary()[i];
            Srch_db_mgr.Optimize_unsafe_(srch_link_tbl.conn, true);
            db_attach_mgr.Conn_main_(srch_link_tbl.conn).Conn_links_(new Db_attach_itm("word_db", db_conn));
            db_attach_mgr.Exec_sql_w_msg(Bry_fmt.Make_str("filling search_link: ~{idx} of ~{len}", i, n), String_.Concat_lines_nl_skip_last("INSERT INTO search_link (word_id, page_id)", "SELECT  t.word_id", ",       t.page_id", "FROM    <word_db>search_link_temp t", "WHERE   t.page_namespace" + (i == 0 ? " = 0" : " != 0")), new Object[0]);
            srch_link_tbl.Create_idx__page_id();
            Srch_db_mgr.Optimize_unsafe_(srch_link_tbl.conn, false);
        }
        db_conn.Meta_tbl_delete("search_link_temp");
    }

    public void Exec_by_wkr(int n, byte[] byArray) {
        this.page_id = n;
        this.title_parser.Parse(this, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Exec_by_cmd(Xowe_wiki xowe_wiki, int n, int n2) {
        this.Init(true, xowe_wiki);
        Xowd_page_tbl xowd_page_tbl = this.core_data_mgr.Tbl__page();
        String string = xowd_page_tbl.Fld_page_id();
        String string2 = xowd_page_tbl.Fld_page_title();
        Db_rdr db_rdr = xowd_page_tbl.Select_all__id__ttl();
        int n3 = 0;
        try {
            while (db_rdr.Move_next()) {
                this.page_id = db_rdr.Read_int(string);
                byte[] byArray = db_rdr.Read_bry_by_str(string2);
                try {
                    this.title_parser.Parse(this, byArray);
                }
                catch (Exception exception) {
                    Xoa_app_.Usr_dlg().Warn_many("", "", "error while parsing title; id=~{0} title=~{1} err=~{2}", this.page_id, byArray, Err_.Message_gplx_log(exception));
                }
                if (++n3 % n == 0) {
                    this.search_temp_tbl.conn.Txn_sav();
                }
                if (n3 % n2 != 0) continue;
                Gfo_usr_dlg_.Instance.Prog_many("", "", "parse progress: count=~{0} last=~{1}", n3, String_.new_u8(byArray));
            }
        }
        finally {
            db_rdr.Rls();
        }
        this.Term();
    }

    @Override
    public void Parse_done(Srch_word_itm srch_word_itm) {
        this.search_temp_tbl.Insert_cmd_by_batch(++this.word_id, this.page_id, srch_word_itm.Word);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Update_word_id(Db_conn db_conn, Xow_wiki xow_wiki) {
        Io_url io_url = Sqlite_conn_info.To_url(db_conn);
        Io_url io_url2 = xow_wiki.Fsys_mgr().Root_dir().GenSubFil_nest("prv", io_url.NameAndExt());
        if (!Io_mgr.Instance.Exists(io_url2)) {
            return;
        }
        db_conn.Exec_sql("UPDATE search_temp SET word_id = -1");
        Db_conn db_conn2 = Db_conn_bldr.Instance.Get_or_noop(io_url2);
        new Db_attach_mgr(db_conn, new Db_attach_itm("prv_db", db_conn2)).Exec_sql_w_msg("updating old word ids", String_.Concat_lines_nl_skip_last("UPDATE  search_temp", "SET     word_id = Coalesce((SELECT prv.word_id FROM <prv_db>search_word prv WHERE prv.word_text = search_temp.word_text), -1)"), new Object[0]);
        int n = db_conn.Exec_select_as_int("SELECT Max(word_id) AS word_id FROM search_temp", -1);
        if (n == -1) {
            throw Err_.new_("dbs", "max_id not found", new Object[0]);
        }
        int n2 = 10000;
        int[] nArray = new int[n2];
        int n3 = -1;
        Db_stmt db_stmt = db_conn.Stmt_update("search_temp", String_.Ary("word_uid"), "word_id");
        block3: while (true) {
            int n4;
            int n5 = 0;
            Db_rdr db_rdr = db_conn.Exec_rdr("SELECT word_uid FROM search_temp WHERE word_id = -1 AND word_uid > " + Int_.To_str(n3));
            try {
                while (db_rdr.Move_next()) {
                    n4 = db_rdr.Read_int("word_uid");
                    nArray[n5++] = n4;
                    if (n5 != n2) continue;
                    n3 = n4;
                    break;
                }
            }
            finally {
                db_rdr.Rls();
            }
            if (n5 == 0) break;
            n4 = 0;
            while (true) {
                if (n4 >= n2) continue block3;
                int n6 = nArray[n4];
                db_stmt.Clear().Val_int("word_id", ++n).Crt_int("word_uid", n6).Exec_update();
                ++n4;
            }
            break;
        }
    }

    private static void Search_word__insert(Db_conn db_conn) {
        db_conn.Meta_tbl_create(Dbmeta_tbl_itm.New("search_word_temp", Dbmeta_fld_itm.new_int("word_id"), Dbmeta_fld_itm.new_str("word_text", 255), Dbmeta_fld_itm.new_int("link_count")));
        db_conn.Exec_sql_concat_w_msg("filling search_word_temp (please wait)", "INSERT INTO search_word_temp (word_id, word_text, link_count)", "SELECT  Min(word_id)", ",       word_text", ",       Count(word_id)", "FROM    search_temp", "GROUP BY ", "        word_text", ";");
        db_conn.Meta_idx_create(Dbmeta_idx_itm.new_normal_by_name("search_word_temp", "main", "word_id"));
        db_conn.Exec_sql_concat_w_msg("filling search_word (please wait)", "INSERT INTO search_word (word_id, word_text, link_count)", "SELECT  word_id", ",       word_text", ",       link_count", "FROM    search_word_temp", "ORDER BY ", "        word_id", ";");
        db_conn.Meta_tbl_delete("search_word_temp");
    }
}

