/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.addons.wikis.pages.syncs.core.parsers;

import gplx.Bry_;
import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.Byte_;
import gplx.Byte_ascii;
import gplx.Gfo_usr_dlg_;
import gplx.String_;
import gplx.core.brys.Bry_rdr;
import gplx.core.btries.Btrie_slim_mgr;
import gplx.core.encoders.Hex_utl_;
import gplx.langs.htmls.encoders.Gfo_url_encoder_;
import gplx.xowa.files.Xof_ext;
import gplx.xowa.files.Xof_ext_;
import gplx.xowa.files.Xof_file_wkr_;
import gplx.xowa.files.Xof_fsdb_itm;
import gplx.xowa.files.Xof_url_bldr;
import gplx.xowa.htmls.core.wkrs.Xoh_hdoc_ctx;
import gplx.xowa.wikis.domains.Xow_abrv_xo_;
import gplx.xowa.wikis.domains.Xow_domain_itm;
import gplx.xowa.wikis.domains.Xow_domain_itm_;

public class Xosync_img_src_parser {
    private final Bry_rdr rdr = new Bry_rdr().Dflt_dlm_((byte)47);
    private final Xof_url_bldr url_bldr = Xof_url_bldr.new_v2();
    private final Bry_bfr tmp_bfr = Bry_bfr_.New();
    private final byte[] wiki_abrv_commons;
    private Xoh_hdoc_ctx hctx;
    private byte path_tid;
    private byte[] img_src_bgn_local;
    private byte[] img_src_bgn_remote;
    private byte[] page_url;
    private byte[] repo_local;
    private byte[] raw;
    private boolean repo_is_commons;
    private byte[] file_ttl_bry;
    private boolean file_is_orig;
    private Xof_ext file_ext;
    private int file_w;
    private double file_time;
    private int file_page;
    private String err_msg;
    private static final byte[] Bry__repo_remote = Bry_.new_a7("wikipedia/commons/");
    private static final byte[] Bry__thumb = Bry_.new_a7("thumb/");
    private static final byte[] Bry__px = Bry_.new_a7("px");
    private static final byte[] Bry__seek = Bry_.new_a7("-seek%3D");
    private static final byte[] Bry__page = Bry_.new_a7("page");
    public static final byte Path__unknown = 0;
    public static final byte Path__file = 1;
    public static final byte Path__math = 2;
    private final Btrie_slim_mgr path_trie = Btrie_slim_mgr.cs().Add_str_byte("//upload.wikimedia.org/", (byte)1).Add_str_byte("https://wikimedia.org/api/rest_v1/media/math/render/svg/", (byte)2);
    public static final byte[] Bry__xowa_file = Bry_.new_a7("xowa:/file/");
    public static final byte[] Bry__xowa_math = Bry_.new_a7("xowa:/math/");
    public static Btrie_slim_mgr Src_xo_trie = Btrie_slim_mgr.cs().Add_bry_byte(Bry__xowa_file, (byte)1).Add_bry_byte(Bry__xowa_math, (byte)2);

    public boolean Repo_is_commons() {
        return this.repo_is_commons;
    }

    public byte[] File_ttl_bry() {
        return this.file_ttl_bry;
    }

    public boolean File_is_orig() {
        return this.file_is_orig;
    }

    public Xof_ext File_ext() {
        return this.file_ext;
    }

    public int File_w() {
        return this.file_w;
    }

    public double File_time() {
        return this.file_time;
    }

    public int File_page() {
        return this.file_page;
    }

    public String Err_msg() {
        return this.err_msg;
    }

    public Xosync_img_src_parser() {
        this.rdr.Err_wkr().Fail_throws_err_(false);
        this.img_src_bgn_remote = this.tmp_bfr.Add(Bry__xowa_file).Add(Xow_domain_itm_.Bry__commons).Add_byte_slash().To_bry_and_clear();
        this.wiki_abrv_commons = Xow_abrv_xo_.To_bry(Xow_domain_itm_.Bry__commons);
    }

    public void Init_by_page(Xoh_hdoc_ctx xoh_hdoc_ctx) {
        this.hctx = xoh_hdoc_ctx;
        this.page_url = xoh_hdoc_ctx.Page__url();
        this.path_tid = 0;
        this.repo_local = Xosync_img_src_parser.To_wmf_repo_or_null(this.tmp_bfr, xoh_hdoc_ctx.Wiki__domain_itm());
        if (this.repo_local == null) {
            Gfo_usr_dlg_.Instance.Warn_many("", "", "unsupported wmf repo; domain=~{0}", new Object[]{xoh_hdoc_ctx.Wiki__domain_itm().Domain_bry()});
        }
        this.img_src_bgn_local = this.tmp_bfr.Add(Bry__xowa_file).Add(xoh_hdoc_ctx.Wiki__domain_bry()).Add_byte_slash().To_bry_and_clear();
    }

    public boolean Parse(byte[] byArray) {
        this.Clear();
        this.raw = byArray;
        int n = byArray.length;
        if (n == 0) {
            return this.Fail("empty img_src");
        }
        this.rdr.Init_by_src(byArray);
        this.path_tid = this.rdr.Chk_or(this.path_trie, (byte)0);
        switch (this.path_tid) {
            case 1: {
                return this.Parse_file(n);
            }
            case 2: {
                return this.Parse_math(n);
            }
        }
        return this.Fail("img src does not start with known sequence");
    }

    private boolean Parse_file(int n) {
        if (this.rdr.Is(Bry__repo_remote)) {
            this.repo_is_commons = true;
        } else if (!this.rdr.Is(this.repo_local)) {
            return this.Fail("unknown repo");
        }
        if (!this.rdr.Is(Bry__thumb)) {
            this.file_is_orig = true;
        }
        if (!this.Check_md5()) {
            return this.Fail("invalid md5");
        }
        int n2 = this.rdr.Pos();
        int n3 = this.rdr.Find_fwd_lr_or((byte)47, n);
        this.file_ttl_bry = Bry_.Mid(this.raw, n2, n3);
        this.file_ttl_bry = Gfo_url_encoder_.Http_url.Decode(this.file_ttl_bry);
        this.file_ext = Xof_ext_.new_by_ttl_(this.file_ttl_bry);
        if (this.file_ext.Id_is_ogg()) {
            this.file_ext = Xof_ext_.new_by_id_(13);
        }
        if (!this.file_is_orig) {
            int n4;
            int n5;
            if (this.rdr.Is(Bry__page)) {
                n5 = this.rdr.Pos();
                n4 = this.rdr.Find_fwd_lr((byte)45);
                this.file_page = Bry_.To_int_or_fail(this.raw, n5, n4);
            }
            n5 = this.rdr.Pos();
            n4 = this.rdr.Find_fwd_lr(Bry__px);
            if (n4 == -1) {
                return this.Fail("missing px");
            }
            this.file_w = Bry_.To_int_or(this.raw, n5, n4, -1);
            if (this.file_w == -1) {
                return this.Fail("invalid file_w");
            }
            int n6 = this.rdr.Find_fwd_rr(Bry__seek);
            if (n6 != -1) {
                int n7 = this.rdr.Pos();
                int n8 = this.rdr.Find_fwd_lr((byte)45);
                this.file_time = Bry_.To_double(this.raw, n7, n8);
            }
        }
        this.Add_img(this.hctx.Wiki__domain_itm().Abrv_xo());
        return true;
    }

    private boolean Parse_math(int n) {
        this.file_ttl_bry = Bry_.Add(Bry_.Mid(this.raw, this.rdr.Pos(), n), Byte_ascii.Dot_bry, Xof_ext_.Bry_svg);
        this.repo_is_commons = true;
        this.file_is_orig = true;
        this.file_ext = Xof_ext_.new_by_id_(7);
        this.Add_img(this.wiki_abrv_commons);
        return true;
    }

    private void Add_img(byte[] byArray) {
        Xof_fsdb_itm xof_fsdb_itm = new Xof_fsdb_itm();
        this.hctx.Page().Hdump_mgr().Imgs().Add(xof_fsdb_itm);
        xof_fsdb_itm.Init_by_wm_parse(byArray, this.repo_is_commons, this.file_is_orig, this.file_ttl_bry, this.file_ext, this.file_w, this.file_time, this.file_page);
    }

    public byte[] To_bry() {
        switch (this.path_tid) {
            case 1: {
                this.To_bfr_file(this.tmp_bfr);
                break;
            }
            case 2: {
                this.To_bfr_math(this.tmp_bfr);
            }
        }
        return this.tmp_bfr.To_bry_and_clear();
    }

    private void To_bfr_file(Bry_bfr bry_bfr) {
        byte by = this.repo_is_commons ? (byte)0 : 1;
        byte[] byArray = this.repo_is_commons ? this.img_src_bgn_remote : this.img_src_bgn_local;
        this.url_bldr.Init_by_repo(by, byArray, false, (byte)47, false, false, 4);
        this.url_bldr.Init_by_itm(this.file_is_orig ? (byte)0 : 1, Gfo_url_encoder_.Http_url.Encode(this.file_ttl_bry), Xof_file_wkr_.Md5(this.file_ttl_bry), Xof_ext_.new_by_ttl_(this.file_ttl_bry), this.file_w, this.file_time, this.file_page);
        bry_bfr.Add(this.url_bldr.Xto_bry());
    }

    private void To_bfr_math(Bry_bfr bry_bfr) {
        bry_bfr.Add(Bry__xowa_math).Add(this.file_ttl_bry);
    }

    private void Clear() {
        this.file_ttl_bry = null;
        this.repo_is_commons = false;
        this.file_is_orig = false;
        this.file_w = -1;
        this.file_time = -1.0;
        this.file_page = -1;
        this.err_msg = null;
        this.raw = null;
    }

    private boolean Fail(String string) {
        this.err_msg = "wm.parse:" + string;
        String string2 = String_.Format("", this.err_msg + "; page={0} raw={1}", this.page_url, this.raw);
        Gfo_usr_dlg_.Instance.Warn_many("", "", string2, new Object[0]);
        return false;
    }

    private boolean Check_md5() {
        int n = this.rdr.Pos();
        if (!Byte_.Match_all((byte)47, this.raw[n + 1], this.raw[n + 4])) {
            return false;
        }
        byte by = this.raw[n + 0];
        byte by2 = this.raw[n + 2];
        if (by != by2) {
            return false;
        }
        if (!Hex_utl_.Is_hex_many(by, by2, this.raw[n + 3])) {
            return false;
        }
        this.rdr.Move_to(n + 5);
        return true;
    }

    private static byte[] To_wmf_repo_or_null(Bry_bfr bry_bfr, Xow_domain_itm xow_domain_itm) {
        switch (xow_domain_itm.Domain_type_id()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                bry_bfr.Add(xow_domain_itm.Domain_type().Key_bry()).Add_byte_slash();
                break;
            }
            default: {
                return null;
            }
        }
        bry_bfr.Add(xow_domain_itm.Lang_orig_key()).Add_byte_slash();
        return bry_bfr.To_bry_and_clear();
    }

    public static Xof_ext Ext_by_ttl(byte[] byArray, byte by) {
        Xof_ext xof_ext = Xof_ext_.new_by_ttl_(byArray);
        if (xof_ext.Id_is_ogg()) {
            xof_ext = Xof_ext_.new_by_id_(13);
        }
        if (by == 3) {
            xof_ext = Xof_ext_.new_by_id_(7);
        }
        return xof_ext;
    }
}

