/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.addons.bldrs.centrals.cmds;

import gplx.Err_;
import gplx.GfoMsg;
import gplx.Gfo_invk_;
import gplx.Gfo_log_;
import gplx.Gfo_usr_dlg_;
import gplx.GfsCtx;
import gplx.Int_;
import gplx.Math_;
import gplx.String_;
import gplx.Virtual;
import gplx.core.envs.System_;
import gplx.core.gfobjs.Gfobj_nde;
import gplx.core.progs.rates.Gfo_rate_list;
import gplx.core.progs.rates.Gfo_rate_mgr;
import gplx.xowa.addons.bldrs.centrals.Xobc_task_mgr;
import gplx.xowa.addons.bldrs.centrals.cmds.Xobc_cmd_ctx;
import gplx.xowa.addons.bldrs.centrals.cmds.Xobc_cmd_itm;
import gplx.xowa.apps.apis.Xoapi_root;

public abstract class Xobc_cmd__base
implements Xobc_cmd_itm {
    private final Xobc_task_mgr task_mgr;
    private final Gfo_rate_list rate_list;
    private final long notify_delay = 1000L;
    private final double delta_threshold = 0.25;
    private long time_prv;
    private double rate_cur;
    private boolean log_verbose;
    private long data_cur;
    private long data_end;
    private byte status = 1;
    private final int task_id;
    private final int step_id;
    private final int cmd_id;
    private final String cmd_uid;
    private String cmd_exec_err;
    public static final String Invk__exec = "exec";
    public static final int Seqn__0 = 0;

    public Xobc_cmd__base(Xobc_task_mgr xobc_task_mgr, int n, int n2, int n3) {
        this.task_mgr = xobc_task_mgr;
        this.task_id = n;
        this.step_id = n2;
        this.cmd_id = n3;
        this.cmd_uid = String_.Concat_with_str(":", Int_.To_str(n), Int_.To_str(n2), Int_.To_str(n3));
        this.rate_list = xobc_task_mgr == null ? null : xobc_task_mgr.Rate_mgr().Get_or_new(this.Cmd_type());
    }

    @Override
    public long Prog_data_cur() {
        return this.data_cur;
    }

    public void Prog_data_cur_(long l) {
        this.data_cur = l;
    }

    @Override
    public long Prog_data_end() {
        return this.data_end;
    }

    public void Prog_data_end_(long l) {
        this.data_end = l;
    }

    @Override
    public byte Prog_status() {
        return this.status;
    }

    @Override
    public void Prog_status_(byte by) {
        this.status = by;
    }

    @Override
    public void Prog_notify_by_msg(String string) {
        this.task_mgr.Work_mgr().On_stat(this.task_id, string);
    }

    @Override
    public boolean Canceled() {
        return this.status == 16;
    }

    @Override
    public void Cancel() {
        this.status = (byte)16;
    }

    @Override
    public int Task_id() {
        return this.task_id;
    }

    @Override
    public int Step_id() {
        return this.step_id;
    }

    @Override
    public int Cmd_id() {
        return this.cmd_id;
    }

    @Override
    public abstract String Cmd_type();

    @Override
    public abstract String Cmd_name();

    @Override
    @Virtual
    public boolean Cmd_suspendable() {
        return false;
    }

    @Override
    public String Cmd_uid() {
        return this.cmd_uid;
    }

    @Override
    @Virtual
    public String Cmd_fallback() {
        return this.Cmd_type();
    }

    @Override
    @Virtual
    public void Cmd_clear() {
        this.status = 1;
        this.cmd_exec_err = null;
        this.data_cur = 0L;
        this.Cmd_cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void Cmd_exec(Xobc_cmd_ctx xobc_cmd_ctx) {
        Xoapi_root xoapi_root = this.task_mgr.App().Api_root();
        if (xoapi_root != null) {
            this.log_verbose = xoapi_root.Addon().Bldr().Central().Log_verbose();
        }
        try {
            Gfo_log_.Instance.Info("xobc_cmd task bgn", "task_id", this.task_id, "step_id", this.step_id, "cmd_id", this.cmd_id);
            this.time_prv = System_.Ticks();
            this.status = (byte)2;
            this.Cmd_exec_hook(xobc_cmd_ctx);
            Gfo_log_.Instance.Info("xobc_cmd task end", "task_id", this.task_id, "step_id", this.step_id, "cmd_id", this.cmd_id);
            switch (this.status) {
                case 16: {
                    this.task_mgr.Work_mgr().On_suspended(this);
                    return;
                }
                case 8: {
                    this.task_mgr.Work_mgr().On_fail(this, this.Cmd_fail_resumes(), this.cmd_exec_err);
                    return;
                }
                case 2: {
                    this.Prog_notify_and_chk_if_suspended(this.data_end, this.data_end);
                    this.task_mgr.Work_mgr().On_done(this, true);
                    return;
                }
            }
            return;
        }
        catch (Exception exception) {
            this.status = (byte)8;
            Gfo_log_.Instance.Warn("xobc_cmd task fail", "task_id", this.task_id, "step_id", this.step_id, "cmd_id", this.cmd_id, "err", Err_.Message_gplx_log(exception));
            this.task_mgr.Work_mgr().On_fail(this, this.Cmd_fail_resumes(), Err_.Message_lang(exception));
            return;
        }
        finally {
            Gfo_log_.Instance.Flush();
        }
    }

    protected abstract void Cmd_exec_hook(Xobc_cmd_ctx var1);

    @Virtual
    protected boolean Cmd_fail_resumes() {
        return false;
    }

    protected void Cmd_exec_err_(String string) {
        Gfo_log_.Instance.Warn("xobc_cmd task err", "task_id", this.task_id, "step_id", this.step_id, "cmd_id", this.cmd_id, "err", string);
        this.status = (byte)8;
        this.cmd_exec_err = string;
    }

    @Override
    @Virtual
    public void Cmd_cleanup() {
    }

    @Override
    public Gfobj_nde Save_to(Gfobj_nde gfobj_nde) {
        gfobj_nde.Add_int("task_id", this.task_id);
        gfobj_nde.Add_int("step_id", this.step_id);
        gfobj_nde.Add_int("cmd_id", this.cmd_id);
        gfobj_nde.Add_str("cmd_type", this.Cmd_type());
        gfobj_nde.Add_str("cmd_name", this.Cmd_name());
        gfobj_nde.Add_bool("cmd_suspendable", this.Cmd_suspendable());
        gfobj_nde.Add_byte("prog_status", this.Prog_status());
        gfobj_nde.Add_long("prog_data_cur", this.Prog_data_cur());
        gfobj_nde.Add_long("prog_data_end", this.Prog_data_end());
        gfobj_nde.Add_long("prog_time_end", 0L);
        return gfobj_nde;
    }

    @Override
    public void Load_checkpoint() {
        long l = this.Load_checkpoint_hook();
        this.Prog_data_cur_(l);
        if (l > 0L) {
            this.Prog_status_((byte)16);
        }
    }

    @Virtual
    protected long Load_checkpoint_hook() {
        return 0L;
    }

    @Override
    public boolean Prog_notify_and_chk_if_suspended(long l, long l2) {
        if (this.status == 16) {
            return true;
        }
        long l3 = System_.Ticks();
        if (l3 < this.time_prv + 1000L) {
            return false;
        }
        double d = this.rate_list.Add(l - this.data_cur, l3 - this.time_prv) * 1000.0;
        double d2 = Math_.Abs_double((d - this.rate_cur) / this.rate_cur);
        if (this.rate_cur == 0.0 || d2 > 0.25) {
            double d3;
            this.rate_cur = d2 > 0.5 ? d : (d3 = (d - this.rate_cur) * 0.05 + this.rate_cur);
        }
        this.time_prv = l3;
        this.data_cur = l;
        this.data_end = l2;
        this.task_mgr.Send_json("xo.bldr.work.prog__update__recv", Gfobj_nde.New().Add_int("task_id", this.task_id).Add_long("prog_data_cur", this.data_cur).Add_long("prog_data_end", this.data_end).Add_int("prog_rate", (int)this.rate_cur));
        if (this.log_verbose) {
            Gfo_usr_dlg_.Instance.Note_many("", "", "xobc:notify: task_id=~{0} cmd_id=~{1} prog_data_cur=~{2} prog_data_end=~{3} rate_cur=~{4}", this.task_id, this.cmd_id, this.data_cur, this.data_end, this.rate_cur);
        }
        return false;
    }

    @Override
    public Object Invk(GfsCtx gfsCtx, int n, String string, GfoMsg gfoMsg) {
        if (!gfsCtx.Match(string, Invk__exec)) {
            return Gfo_invk_.Rv_unhandled;
        }
        this.Cmd_exec((Xobc_cmd_ctx)gfoMsg.ReadObj("v"));
        return this;
    }

    public static Gfo_rate_mgr New_rate_mgr() {
        Gfo_rate_mgr gfo_rate_mgr = new Gfo_rate_mgr(128);
        gfo_rate_mgr.Add_new("xowa.core.hash_dir");
        gfo_rate_mgr.Add_new("xowa.core.hash_fil");
        gfo_rate_mgr.Add_new("xowa.core.download");
        gfo_rate_mgr.Add_new("xowa.core.ios.zips.zip_unzip");
        return gfo_rate_mgr;
    }
}

