/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.addons.apps.updates.apps;

import gplx.Bry_find_;
import gplx.Err_;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.String_;
import gplx.core.threads.Thread_adp_;
import gplx.xowa.addons.apps.updates.apps.Xoa_manifest_item;
import gplx.xowa.addons.apps.updates.apps.Xoa_manifest_list;
import gplx.xowa.addons.apps.updates.apps.Xoa_manifest_view;

class Xoa_manifest_wkr {
    private final Xoa_manifest_view view;
    private final Xoa_manifest_list list = new Xoa_manifest_list();
    private Io_url manifest_url;
    private String run_xowa_cmd;

    public Xoa_manifest_wkr(Xoa_manifest_view xoa_manifest_view) {
        this.view = xoa_manifest_view;
    }

    public void Init(Io_url io_url) {
        this.manifest_url = io_url;
        this.view.Append("loading manifest from: " + io_url.Raw());
        byte[] byArray = Io_mgr.Instance.LoadFilBry(io_url);
        int n = Bry_find_.Find_fwd(byArray, (byte)10);
        if (n == -1) {
            throw Err_.new_wo_type("could not find nl in manifest", "manifest_url", io_url.Raw());
        }
        this.run_xowa_cmd = String_.new_u8(byArray, 0, n);
        this.list.Load(byArray, n + 1, byArray.length);
        this.Wait();
    }

    private void Wait() {
        int n = 0;
        while (n++ < 100) {
            Thread_adp_.Sleep(1000);
            if (this.Copy_files()) break;
            String string = "#error";
            if (this.list.Len() > 0) {
                Xoa_manifest_item xoa_manifest_item = this.list.Get_at(0);
                string = xoa_manifest_item.Src().Raw();
            }
            this.view.Append("waiting for XOWA to release file: " + string);
        }
        this.On_exit();
    }

    public void On_exit() {
        Io_mgr.Instance.DeleteFil(this.manifest_url);
        this.view.Mark_done(this.run_xowa_cmd);
    }

    private boolean Copy_files() {
        int n = this.list.Len();
        int n2 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            Xoa_manifest_item xoa_manifest_item = this.list.Get_at(n2);
            try {
                Io_mgr.Instance.DeleteFil_args(xoa_manifest_item.Trg()).MissingFails_off().Exec();
                Io_mgr.Instance.CopyFil(xoa_manifest_item.Src(), xoa_manifest_item.Trg(), true);
                this.view.Append(String_.Format("copied file: src={0} trg={1}", xoa_manifest_item.Src().Raw(), xoa_manifest_item.Trg().Raw()));
                continue;
            }
            catch (Exception exception) {
                this.view.Append(String_.Format("failed to copy file: src={0} trg={1} err={2}", xoa_manifest_item.Src().Raw(), xoa_manifest_item.Trg().Raw(), Err_.Message_lang(exception)));
                return false;
            }
        }
        for (int i = 0; i < n2; ++i) {
            this.list.Del_at(0);
        }
        return true;
    }
}

