/*
 * Decompiled with CFR 0.152.
 */
package gplx.langs.jsons;

import gplx.Array_;
import gplx.Bool_;
import gplx.Bry_;
import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.Byte_;
import gplx.Double_;
import gplx.Err_;
import gplx.Float_;
import gplx.Int_;
import gplx.Keyval;
import gplx.Long_;
import gplx.Object_;
import gplx.Type_;
import gplx.Type_ids_;
import gplx.core.primitives.Int_ary;
import gplx.langs.jsons.Json_ary;
import gplx.langs.jsons.Json_itm;
import gplx.langs.jsons.Json_kv;
import gplx.langs.jsons.Json_nde;

public class Json_wtr {
    private final Bry_bfr bfr = Bry_bfr_.New_w_size(255);
    private final Int_ary idx_stack = new Int_ary(4);
    private int idx = 0;
    private int indent;
    private byte opt_quote_byte = (byte)34;
    private boolean opt_ws = true;
    private boolean opt_backslash_2x = false;
    private static final byte[] Sym_nde_bgn = Bry_.new_a7("{");
    private static final byte[] Sym_nde_end = Bry_.new_a7("}");
    private static final byte[] Sym_ary_bgn = Bry_.new_a7("[");
    private static final byte[] Sym_ary_end = Bry_.new_a7("]");
    private static final byte[] Sym_itm_spr = Bry_.new_a7(",");
    private static final int Grp_type__json_nde = 1;
    private static final int Grp_type__kv_ary = 2;
    private static final int Grp_type__json_ary = 3;
    private static final int Grp_type__obj_ary = 4;

    public Bry_bfr Bfr() {
        return this.bfr;
    }

    public void Indent_(int n) {
        this.indent = n;
    }

    public byte Opt_quote_byte() {
        return this.opt_quote_byte;
    }

    public Json_wtr Opt_quote_byte_(byte by) {
        this.opt_quote_byte = by;
        return this;
    }

    public boolean Opt_ws() {
        return this.opt_ws;
    }

    public Json_wtr Opt_ws_(boolean bl) {
        this.opt_ws = bl;
        return this;
    }

    public boolean Opt_backslash_2x() {
        return this.opt_backslash_2x;
    }

    public Json_wtr Opt_backslash_2x_(boolean bl) {
        this.opt_backslash_2x = bl;
        return this;
    }

    public byte[] To_bry_and_clear() {
        return this.bfr.To_bry_and_clear();
    }

    public String To_str_and_clear() {
        return this.bfr.To_str_and_clear();
    }

    public Json_wtr() {
        this.Clear();
    }

    public Json_wtr Clear() {
        this.indent = -1;
        this.idx_stack.Clear();
        this.idx = 0;
        return this;
    }

    public Json_wtr Doc_nde_bgn() {
        return this.Write_grp_bgn(Sym_nde_bgn);
    }

    public Json_wtr Doc_nde_end() {
        this.Write_grp_end(true, Sym_nde_end);
        return this.Write_nl();
    }

    public Json_wtr Doc_ary_bgn() {
        return this.Write_grp_bgn(Sym_ary_bgn);
    }

    public Json_wtr Doc_ary_end() {
        this.Write_grp_end(false, Sym_ary_end);
        return this.Write_nl();
    }

    public Json_wtr Nde_bgn_ary() {
        return this.Nde_bgn(Bry_.Empty);
    }

    public Json_wtr Nde_bgn(String string) {
        return this.Nde_bgn(Bry_.new_u8(string));
    }

    public Json_wtr Nde_bgn(byte[] byArray) {
        this.Write_indent_itm();
        if (byArray == Bry_.Empty) {
            if (this.opt_ws) {
                this.bfr.Del_by_1();
            }
            ++this.idx;
        } else {
            this.Write_key(byArray);
        }
        this.Write_nl();
        return this.Write_grp_bgn(Sym_nde_bgn);
    }

    public Json_wtr Nde_end() {
        this.Write_grp_end(true, Sym_nde_end);
        return this.Write_nl();
    }

    public Json_wtr Ary_bgn_ary() {
        return this.Ary_bgn("");
    }

    public Json_wtr Ary_bgn(String string) {
        this.Write_indent_itm();
        if (string == "") {
            if (this.opt_ws) {
                this.bfr.Del_by_1();
            }
            ++this.idx;
        } else {
            this.Write_key(Bry_.new_u8(string));
        }
        return this.Ary_bgn_keyless();
    }

    private Json_wtr Ary_bgn_keyless() {
        this.Write_nl();
        return this.Write_grp_bgn(Sym_ary_bgn);
    }

    public Json_wtr Ary_itm_str(String string) {
        return this.Ary_itm_by_type_tid(10, string);
    }

    public Json_wtr Ary_itm_bry(byte[] byArray) {
        return this.Ary_itm_by_type_tid(11, byArray);
    }

    public Json_wtr Ary_itm_obj(Object object) {
        return this.Ary_itm_by_type_tid(Type_ids_.To_id_by_obj(object), object);
    }

    public Json_wtr Ary_itm_by_type_tid(int n, Object object) {
        this.Write_indent_itm();
        this.Write_val_obj(true, n, object);
        this.Write_nl();
        ++this.idx;
        return this;
    }

    public Json_wtr Ary_end() {
        this.Write_grp_end(false, Sym_ary_end);
        return this.Write_nl();
    }

    public Json_wtr Kv_bool_as_mw(String string, boolean bl) {
        if (bl) {
            this.Kv_bry(string, Bry_.Empty);
        }
        return this;
    }

    public Json_wtr Kv_bool(String string, boolean bl) {
        return this.Kv_bool(Bry_.new_u8(string), bl);
    }

    public Json_wtr Kv_bool(byte[] byArray, boolean bl) {
        return this.Kv_raw(byArray, bl ? Bool_.True_bry : Bool_.False_bry);
    }

    public Json_wtr Kv_int(String string, int n) {
        return this.Kv_raw(Bry_.new_u8(string), Int_.To_bry(n));
    }

    public Json_wtr Kv_long(String string, long l) {
        return this.Kv_raw(Bry_.new_u8(string), Bry_.new_a7(Long_.To_str(l)));
    }

    public Json_wtr Kv_float(String string, float f) {
        return this.Kv_raw(Bry_.new_u8(string), Bry_.new_a7(Float_.To_str(f)));
    }

    public Json_wtr Kv_double(String string, double d) {
        return this.Kv_raw(Bry_.new_u8(string), Bry_.new_a7(Double_.To_str(d)));
    }

    private Json_wtr Kv_raw(byte[] byArray, byte[] byArray2) {
        this.Write_indent_itm();
        this.Write_key(byArray);
        this.bfr.Add(byArray2);
        this.Write_nl();
        return this;
    }

    public Json_wtr Kv_str(String string, String string2) {
        return this.Kv_bry(Bry_.new_u8(string), string2 == null ? null : Bry_.new_u8(string2));
    }

    public Json_wtr Kv_str(byte[] byArray, String string) {
        return this.Kv_bry(byArray, Bry_.new_u8(string));
    }

    public Json_wtr Kv_bry(String string, byte[] byArray) {
        return this.Kv_bry(Bry_.new_u8(string), byArray);
    }

    public Json_wtr Kv_bry(byte[] byArray, byte[] byArray2) {
        this.Write_indent_itm();
        this.Write_key(byArray);
        this.Write_str(byArray2);
        this.Write_nl();
        return this;
    }

    public Object Get_x(Json_itm json_itm) {
        switch (json_itm.Tid()) {
            case 8: 
            case 9: {
                return json_itm;
            }
            default: {
                throw Err_.new_unsupported();
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
        }
        return json_itm.Data();
    }

    public void Kv_itm_x(byte[] byArray, Json_itm json_itm) {
        Object object = this.Get_x(json_itm);
        int n = Type_ids_.To_id_by_obj(object);
        this.Kv_obj(byArray, object, n);
    }

    public Json_wtr Kv_obj(byte[] byArray, Object object, int n) {
        this.Write_indent_itm();
        this.Write_key(byArray);
        this.Write_val_obj(false, n, object);
        this.Write_nl();
        return this;
    }

    private Json_wtr Write_grp_bgn(byte[] byArray) {
        return this.Write_grp_bgn(byArray, true);
    }

    private Json_wtr Write_grp_bgn(byte[] byArray, boolean bl) {
        this.idx_stack.Add(this.idx);
        this.idx = 0;
        ++this.indent;
        if (bl) {
            this.Write_indent();
        }
        this.bfr.Add(byArray);
        return this;
    }

    private Json_wtr Write_grp_end(boolean bl, byte[] byArray) {
        if (bl && this.idx == 0 || !bl && this.idx == 0) {
            this.Write_nl();
        }
        this.Write_indent();
        --this.indent;
        this.bfr.Add(byArray);
        this.idx = this.idx_stack.Pop_or(0);
        return this;
    }

    private Json_wtr Write_key(byte[] byArray) {
        this.Write_str(byArray);
        this.bfr.Add_byte_colon();
        ++this.idx;
        return this;
    }

    private void Write_val_obj(boolean bl, int n, Object object) {
        switch (n) {
            case 1: {
                this.bfr.Add(Object_.Bry__null);
                break;
            }
            case 2: {
                this.bfr.Add_bool(Bool_.Cast(object));
                break;
            }
            case 3: {
                this.bfr.Add_byte(Byte_.Cast(object));
                break;
            }
            case 5: {
                this.bfr.Add_int_variable(Int_.Cast(object));
                break;
            }
            case 6: {
                this.bfr.Add_long_variable(Long_.cast(object));
                break;
            }
            case 7: {
                this.bfr.Add_float(Float_.cast(object));
                break;
            }
            case 8: {
                this.bfr.Add_double(Double_.cast(object));
                break;
            }
            case 10: {
                this.Write_str(Bry_.new_u8((String)object));
                break;
            }
            case 11: {
                this.Write_str((byte[])object);
                break;
            }
            case 9: 
            case 12: 
            case 13: {
                this.Write_str(Bry_.new_u8(Object_.Xto_str_strict_or_empty(object)));
                break;
            }
            case 0: {
                int n2 = Json_wtr.Grp_type__get(object);
                if (n2 < 3) {
                    this.Write_val_obj__nde(bl, n2, object);
                    break;
                }
                this.Write_val_itm__ary(bl, n2, object);
                break;
            }
            default: {
                throw Err_.new_unhandled(n);
            }
        }
    }

    private void Handle_nde_as_ary_itm_0() {
        if (this.idx == 0) {
            this.bfr.Del_by_1();
            if (this.opt_ws) {
                this.bfr.Add_byte_nl();
                ++this.indent;
                this.Write_indent();
                --this.indent;
            }
        }
    }

    private void Write_val_obj__nde(boolean bl, int n, Object object) {
        if (n == 1) {
            if (this.idx == 0 && !bl) {
                this.bfr.Del_by_1();
                if (this.opt_ws) {
                    this.bfr.Add_byte_nl();
                    ++this.indent;
                    this.Write_indent();
                    --this.indent;
                }
            }
            this.bfr.Add_byte_nl();
            this.Write_grp_bgn(Sym_nde_bgn, true);
            Json_nde json_nde = (Json_nde)object;
            int n2 = json_nde.Len();
            for (int i = 0; i < n2; ++i) {
                Json_kv json_kv = json_nde.Get_at_as_kv(i);
                this.Kv_itm_x(json_kv.Key_as_bry(), json_kv.Val());
            }
        } else {
            this.Handle_nde_as_ary_itm_0();
            this.Write_grp_bgn(Sym_nde_bgn, false);
            for (Keyval keyval : (Keyval[])object) {
                Object object2 = keyval.Val();
                this.Kv_obj(Bry_.new_u8(keyval.Key()), object2, Type_ids_.To_id_by_obj(object2));
            }
        }
        this.Write_grp_end(true, Sym_nde_end);
    }

    private void Write_val_itm__ary(boolean bl, int n, Object object) {
        this.Ary_bgn_keyless();
        if (n == 3) {
            Json_ary json_ary = (Json_ary)object;
            int n2 = json_ary.Len();
            for (int i = 0; i < n2; ++i) {
                Json_itm json_itm = json_ary.Get_at(i);
                this.Ary_itm_obj(this.Get_x(json_itm));
            }
        } else {
            Object object2 = Array_.cast(object);
            int n3 = Array_.Len(object2);
            for (int i = 0; i < n3; ++i) {
                Object object3 = Array_.Get_at(object2, i);
                this.Ary_itm_obj(object3);
            }
        }
        this.Write_grp_end(false, Sym_ary_end);
    }

    private void Write_str(byte[] byArray) {
        if (byArray == null) {
            this.bfr.Add(Object_.Bry__null);
            return;
        }
        int n = byArray.length;
        int n2 = this.opt_backslash_2x ? 3 : 1;
        this.bfr.Add_byte(this.opt_quote_byte);
        block8: for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            switch (by) {
                case 92: {
                    this.bfr.Add_byte_repeat((byte)92, n2).Add_byte(by);
                    continue block8;
                }
                case 34: {
                    this.bfr.Add_byte_repeat((byte)92, n2).Add_byte(by);
                    continue block8;
                }
                case 39: {
                    if (this.opt_backslash_2x) {
                        this.bfr.Add_byte_repeat((byte)92, 1).Add_byte(by);
                        continue block8;
                    }
                    this.bfr.Add_byte(by);
                    continue block8;
                }
                case 10: {
                    this.bfr.Add_byte_repeat((byte)92, 2).Add_byte((byte)110);
                    continue block8;
                }
                case 13: {
                    this.bfr.Add_byte_repeat((byte)92, 2).Add_byte((byte)114);
                    continue block8;
                }
                case 9: {
                    this.bfr.Add_byte_repeat((byte)92, 2).Add_byte((byte)116);
                    continue block8;
                }
                default: {
                    this.bfr.Add_byte(by);
                }
            }
        }
        this.bfr.Add_byte(this.opt_quote_byte);
    }

    private void Write_indent_itm() {
        if (this.idx == 0) {
            if (this.opt_ws) {
                this.bfr.Add_byte_space();
            }
        } else {
            this.Write_indent();
            this.bfr.Add(Sym_itm_spr);
            if (this.opt_ws) {
                this.bfr.Add_byte_space();
            }
        }
    }

    private void Write_indent() {
        if (this.opt_ws && this.indent > 0) {
            this.bfr.Add_byte_repeat((byte)32, this.indent * 2);
        }
    }

    private Json_wtr Write_nl() {
        if (this.opt_ws) {
            this.bfr.Add_byte_nl();
        }
        return this;
    }

    private static int Grp_type__get(Object object) {
        Class<?> clazz = object.getClass();
        if (Type_.Eq(clazz, Keyval[].class)) {
            return 2;
        }
        if (Type_.Is_array(clazz)) {
            return 4;
        }
        if (Type_.Eq(clazz, Json_nde.class)) {
            return 1;
        }
        if (Type_.Eq(clazz, Json_ary.class)) {
            return 3;
        }
        throw Err_.new_unhandled(clazz);
    }
}

