/*
 * Decompiled with CFR 0.152.
 */
package gplx.langs.jsons;

import gplx.Bry_;
import gplx.Char_;
import gplx.Err;
import gplx.Err_;
import gplx.Int_;
import gplx.String_;
import gplx.core.primitives.Gfo_number_parser;
import gplx.langs.jsons.Json_ary;
import gplx.langs.jsons.Json_doc;
import gplx.langs.jsons.Json_factory;
import gplx.langs.jsons.Json_grp;
import gplx.langs.jsons.Json_itm;
import gplx.langs.jsons.Json_itm_base;
import gplx.langs.jsons.Json_kv;
import gplx.langs.jsons.Json_nde;

public class Json_parser {
    private byte[] src;
    private int src_len;
    private int pos;
    private final Gfo_number_parser num_parser = new Gfo_number_parser();
    private final Json_factory factory = new Json_factory();
    private static final byte[] Bry_bool_rue = Bry_.new_a7("rue");
    private static final byte[] Bry_bool_alse = Bry_.new_a7("alse");
    private static final byte[] Bry_null_ull = Bry_.new_a7("ull");

    public Json_factory Factory() {
        return this.factory;
    }

    public Json_doc Parse_by_apos_ary(String ... stringArray) {
        return this.Parse_by_apos(String_.Concat_lines_nl(stringArray));
    }

    public Json_doc Parse_by_apos(String string) {
        return this.Parse(Bry_.Replace(Bry_.new_u8(string), (byte)39, (byte)34));
    }

    public Json_doc Parse(String string) {
        return this.Parse(Bry_.new_u8(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Json_doc Parse(byte[] byArray) {
        Json_factory json_factory = this.factory;
        synchronized (json_factory) {
            this.src = byArray;
            if (byArray == null) {
                return null;
            }
            this.src_len = byArray.length;
            if (this.src_len == 0) {
                return null;
            }
            this.pos = 0;
            this.Skip_ws();
            boolean bl = true;
            switch (byArray[this.pos]) {
                case 123: {
                    bl = true;
                    break;
                }
                case 91: {
                    bl = false;
                    break;
                }
                default: {
                    return null;
                }
            }
            this.Skip_ws();
            Json_doc json_doc = new Json_doc();
            Json_itm_base json_itm_base = null;
            json_itm_base = bl ? this.Make_nde(json_doc) : this.Make_ary(json_doc);
            json_doc.Ctor(byArray, (Json_grp)((Object)json_itm_base));
            return json_doc;
        }
    }

    private Json_nde Make_nde(Json_doc json_doc) {
        ++this.pos;
        Json_nde json_nde = new Json_nde(json_doc, this.pos);
        block4: while (this.pos < this.src_len) {
            this.Skip_ws();
            if (this.src[this.pos] == 125) {
                ++this.pos;
                return json_nde;
            }
            json_nde.Add(this.Make_kv(json_doc));
            this.Skip_ws();
            switch (this.src[this.pos++]) {
                case 44: {
                    continue block4;
                }
                case 125: {
                    return json_nde;
                }
            }
            throw Err_.new_unhandled(this.src[this.pos - 1]);
        }
        throw Err_.new_wo_type("eos inside nde", new Object[0]);
    }

    private Json_itm Make_kv(Json_doc json_doc) {
        Json_itm json_itm = this.Make_string(json_doc);
        this.Skip_ws();
        this.Chk((byte)58);
        this.Skip_ws();
        Json_itm json_itm2 = this.Make_val(json_doc);
        return new Json_kv(json_itm, json_itm2);
    }

    private Json_itm Make_val(Json_doc json_doc) {
        if (this.pos < this.src_len) {
            byte by = this.src[this.pos];
            switch (by) {
                case 110: {
                    return this.Make_literal(Bry_null_ull, 3, this.factory.Null());
                }
                case 102: {
                    return this.Make_literal(Bry_bool_alse, 4, this.factory.Bool_n());
                }
                case 116: {
                    return this.Make_literal(Bry_bool_rue, 3, this.factory.Bool_y());
                }
                case 34: {
                    return this.Make_string(json_doc);
                }
                case 45: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.Make_num(json_doc);
                }
                case 91: {
                    return this.Make_ary(json_doc);
                }
                case 123: {
                    return this.Make_nde(json_doc);
                }
            }
            throw Err_.new_unhandled(Char_.To_str(by));
        }
        throw Err_.new_wo_type("eos reached in val", new Object[0]);
    }

    private Json_itm Make_literal(byte[] byArray, int n, Json_itm json_itm) {
        ++this.pos;
        int n2 = this.pos + n;
        if (Bry_.Eq(this.src, this.pos, n2, byArray)) {
            this.pos = n2;
            return json_itm;
        }
        throw Err_.new_("json.parser", "invalid literal", "excerpt", Bry_.Mid_by_len_safe(this.src, this.pos - 1, 16));
    }

    private Json_itm Make_string(Json_doc json_doc) {
        int n = this.pos++;
        boolean bl = true;
        block7: while (this.pos < this.src_len) {
            switch (this.src[this.pos]) {
                case 92: {
                    ++this.pos;
                    switch (this.src[this.pos]) {
                        case 117: {
                            this.pos += 4;
                            break;
                        }
                        default: {
                            ++this.pos;
                        }
                    }
                    bl = false;
                    continue block7;
                }
                case 34: {
                    return this.factory.Str(json_doc, n, ++this.pos, bl);
                }
            }
            ++this.pos;
        }
        throw Err_.new_wo_type("eos reached inside quote", new Object[0]);
    }

    private Json_itm Make_num(Json_doc json_doc) {
        int n = this.pos;
        boolean bl = true;
        block4: while (bl) {
            if (this.pos == this.src_len) {
                throw Err_.new_wo_type("eos reached inside num", new Object[0]);
            }
            switch (this.src[this.pos]) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    ++this.pos;
                    continue block4;
                }
                case 43: 
                case 45: 
                case 46: 
                case 69: 
                case 101: {
                    ++this.pos;
                    continue block4;
                }
            }
            bl = false;
        }
        this.num_parser.Parse(this.src, n, this.pos);
        if (this.num_parser.Has_frac()) {
            return this.factory.Decimal(json_doc, n, this.pos);
        }
        if (this.num_parser.Is_int()) {
            return this.factory.Int(json_doc, n, this.pos);
        }
        return this.factory.Long(json_doc, n, this.pos);
    }

    private Json_ary Make_ary(Json_doc json_doc) {
        Json_ary json_ary = this.factory.Ary(this.pos++, this.pos);
        while (this.pos < this.src_len) {
            this.Skip_ws();
            if (this.src[this.pos] == 93) {
                ++this.pos;
                return json_ary;
            }
            json_ary.Add(this.Make_val(json_doc));
            this.Skip_ws();
            switch (this.src[this.pos]) {
                case 44: {
                    ++this.pos;
                    break;
                }
                case 93: {
                    ++this.pos;
                    return json_ary;
                }
            }
        }
        throw Err_.new_wo_type("eos inside ary", new Object[0]);
    }

    private void Skip_ws() {
        block3: while (this.pos < this.src_len) {
            switch (this.src[this.pos]) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    ++this.pos;
                    continue block3;
                }
            }
            return;
        }
    }

    private void Chk(byte by) {
        if (this.src[this.pos] == by) {
            ++this.pos;
        } else {
            throw this.err_(this.src, this.pos, "expected '{0}' but got '{1}'", Char_.To_str(by), Char_.To_str(this.src[this.pos]));
        }
    }

    private Err err_(byte[] byArray, int n, String string, Object ... objectArray) {
        return this.err_(byArray, n, byArray.length, string, objectArray);
    }

    private Err err_(byte[] byArray, int n, int n2, String string, Object ... objectArray) {
        String string2 = String_.Format(string, objectArray) + " " + Int_.To_str(n) + " " + String_.new_u8__by_len(byArray, n, 20);
        return Err_.new_wo_type(string2, new Object[0]);
    }
}

