/*
 * Decompiled with CFR 0.152.
 */
package gplx.langs.dsvs;

import gplx.Err_;
import gplx.Internal;
import gplx.List_adp;
import gplx.List_adp_;
import gplx.core.gfo_ndes.GfoFldList;
import gplx.core.gfo_ndes.GfoFldList_;
import gplx.core.gfo_ndes.GfoNde;
import gplx.core.gfo_ndes.GfoNde_;
import gplx.core.strings.String_bldr;
import gplx.core.strings.String_bldr_;
import gplx.core.type_xtns.ClassXtn;
import gplx.core.type_xtns.ClassXtnPool;
import gplx.core.type_xtns.StringClassXtn;
import gplx.langs.dsvs.DsvStoreLayout;

class DsvTblBldr {
    GfoNde root;
    GfoNde tbl;
    DsvStoreLayout layout = DsvStoreLayout.dsv_brief_();
    List_adp fldNames = List_adp_.New();
    List_adp fldTypes = List_adp_.New();
    int stage = 0;
    @Internal
    protected static final String NullTblName = "";
    static final int Stage_Init = 0;
    static final int Stage_Hdr = 1;
    static final int Stage_Row = 2;

    public void Init() {
        this.root = GfoNde_.root_(new GfoNde[0]);
        this.tbl = GfoNde_.tbl_(NullTblName, GfoFldList_.new_(), new GfoNde[0]);
        this.fldNames.Clear();
        this.fldTypes.Clear();
        this.stage = 0;
    }

    public GfoNde BldRoot() {
        if (this.stage != 0) {
            this.CreateTbl();
        }
        return this.root;
    }

    public void MakeTblBgn(List_adp list_adp) {
        if (this.stage != 0) {
            this.CreateTbl();
        }
        this.tbl.Name_((String)list_adp.Get_at(0));
        this.layout.HeaderList().Add_TableName();
        this.stage = 1;
        list_adp.Clear();
    }

    public void MakeFldNames(List_adp list_adp) {
        if (this.stage == 2) {
            this.CreateTbl();
        }
        this.fldNames.Clear();
        for (Object t : list_adp) {
            this.fldNames.Add(t);
        }
        this.layout.HeaderList().Add_LeafNames();
        this.stage = 1;
        list_adp.Clear();
    }

    public void MakeFldTypes(List_adp list_adp) {
        if (this.stage == 2) {
            this.CreateTbl();
        }
        this.fldTypes.Clear();
        for (Object t : list_adp) {
            ClassXtn classXtn = ClassXtnPool.Instance.Get_by_or_fail((String)t);
            this.fldTypes.Add(classXtn);
        }
        this.layout.HeaderList().Add_LeafTypes();
        this.stage = 1;
        list_adp.Clear();
    }

    public void MakeComment(List_adp list_adp) {
        if (this.stage == 2) {
            list_adp.Clear();
        } else {
            String_bldr string_bldr = String_bldr_.new_();
            for (int i = 0; i < list_adp.Count(); ++i) {
                string_bldr.Add((String)list_adp.Get_at(i));
            }
            this.layout.HeaderList().Add_Comment(string_bldr.To_str());
            list_adp.Clear();
        }
    }

    public void MakeBlankLine() {
        if (this.stage != 0) {
            this.CreateTbl();
        }
        this.layout.HeaderList().Add_BlankLine();
        this.stage = 0;
    }

    public void MakeVals(List_adp list_adp) {
        if (this.stage != 2) {
            this.CreateFlds(list_adp.Count());
        }
        GfoNde gfoNde = GfoNde_.vals_(this.tbl.SubFlds(), this.MakeValsAry(list_adp));
        this.tbl.Subs().Add(gfoNde);
        this.stage = 2;
        list_adp.Clear();
    }

    Object[] MakeValsAry(List_adp list_adp) {
        GfoFldList gfoFldList = this.tbl.SubFlds();
        int n = gfoFldList.Count();
        if (list_adp.Count() > n) {
            throw Err_.new_wo_type("values.Count cannot be greater than fields.Count", "values.Count", list_adp.Count(), "fields.Count", n);
        }
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            ClassXtn classXtn = gfoFldList.Get_at(i).Type();
            String string = i < list_adp.Count() ? (String)list_adp.Get_at(i) : null;
            objectArray[i] = classXtn.ParseOrNull(string);
        }
        return objectArray;
    }

    void CreateTbl() {
        if (this.tbl.SubFlds().Count() == 0) {
            this.CreateFlds(0);
        }
        this.tbl.EnvVars().Add("StoreLayoutWtr", this.layout);
        this.root.Subs().Add(this.tbl);
        this.layout = DsvStoreLayout.dsv_brief_();
        this.tbl = GfoNde_.tbl_(NullTblName, GfoFldList_.new_(), new GfoNde[0]);
        this.stage = 1;
    }

    void CreateFlds(int n) {
        int n2 = this.fldNames.Count();
        int n3 = this.fldTypes.Count();
        if (n2 == 0 && n3 == 0) {
            for (int i = 0; i < n; ++i) {
                this.tbl.SubFlds().Add("fld" + i, StringClassXtn.Instance);
            }
        } else {
            int n4 = n2 > n3 ? n2 : n3;
            for (int i = 0; i < n4; ++i) {
                String string = i < n2 ? (String)this.fldNames.Get_at(i) : "fld" + i;
                StringClassXtn stringClassXtn = i < n3 ? (ClassXtn)this.fldTypes.Get_at(i) : StringClassXtn.Instance;
                this.tbl.SubFlds().Add(string, stringClassXtn);
            }
        }
    }

    public static DsvTblBldr new_() {
        return new DsvTblBldr();
    }

    DsvTblBldr() {
        this.Init();
    }
}

