/*
 * Decompiled with CFR 0.152.
 */
package gplx.gfui.layouts;

import gplx.Err_;
import gplx.Internal;
import gplx.List_adp;
import gplx.List_adp_;
import gplx.String_;
import gplx.gfui.DirInt;
import gplx.gfui.controls.elems.GfuiElemBase;
import gplx.gfui.layouts.GftBand;
import gplx.gfui.layouts.GftItem;
import gplx.gfui.layouts.GftSizeCalc_abs;

public class GftGrid {
    private String key;
    List_adp bands = List_adp_.New();
    List_adp subLyts = List_adp_.New();
    DirInt bandDir = DirInt.Fwd;

    public String Key() {
        return this.key;
    }

    public GftGrid Key_(String string) {
        this.key = string;
        return this;
    }

    public List_adp Bands() {
        return this.bands;
    }

    public List_adp SubLyts() {
        return this.subLyts;
    }

    public void Clear() {
        this.bands.Clear();
        this.subLyts.Clear();
        this.bandDir = DirInt.Fwd;
    }

    public DirInt Bands_dir() {
        return this.bandDir;
    }

    public GftGrid Bands_dir_(DirInt dirInt) {
        this.bandDir = dirInt;
        return this;
    }

    public GftGrid SubLyts_get(String string) {
        for (int i = 0; i < this.subLyts.Count(); ++i) {
            GftGrid gftGrid = (GftGrid)this.subLyts.Get_at(i);
            if (!String_.Eq(string, gftGrid.Key())) continue;
            return gftGrid;
        }
        return null;
    }

    public GftBand Bands_get(String string) {
        for (int i = 0; i < this.bands.Count(); ++i) {
            GftBand gftBand = (GftBand)this.bands.Get_at(i);
            if (!String_.Eq(string, gftBand.Key())) continue;
            return gftBand;
        }
        return null;
    }

    public GftGrid Bands_add(GftBand gftBand) {
        this.bands.Add(gftBand.Clone(this, this.bands.Count()));
        return this;
    }

    public GftGrid Bands_add(int n, GftBand gftBand) {
        for (int i = 0; i < n; ++i) {
            GftBand gftBand2 = gftBand.Clone(this, this.bands.Count() + i);
            this.bands.Add(gftBand2);
        }
        return this;
    }

    @Internal
    protected void Bands_delAt(int n) {
        this.bands.Del_at(n);
    }

    public boolean Bands_has(String string) {
        return this.Bands_indexOf(string) != -1;
    }

    public void Bands_del(String string) {
        int n = this.Bands_indexOf(string);
        if (n != -1) {
            this.bands.Del_at(n);
        }
    }

    int Bands_indexOf(String string) {
        int n = -1;
        for (int i = 0; i < this.bands.Count(); ++i) {
            GftBand gftBand = (GftBand)this.bands.Get_at(i);
            if (!String_.Eq(string, gftBand.Key())) continue;
            n = i;
            break;
        }
        return n;
    }

    public GftGrid Bands_set(int n, GftBand gftBand) {
        return this.Bands_set(n, n, gftBand);
    }

    public GftGrid Bands_set(int n, int n2, GftBand gftBand) {
        int n3 = n2 - n + 1;
        for (int i = 0; i < n3; ++i) {
            GftBand gftBand2 = gftBand.Clone(this, n + i);
            this.bands.Add(gftBand2);
        }
        return this;
    }

    public void Exec(GftItem gftItem, GftItem ... gftItemArray) {
        this.ExecLyts(gftItem, gftItemArray);
        this.ExecBands(gftItem, gftItemArray);
    }

    void ExecLyts(GftItem gftItem, GftItem[] gftItemArray) {
        int n = 0;
        for (int i = 0; i < this.subLyts.Count(); ++i) {
            GftGrid gftGrid = (GftGrid)this.subLyts.Get_at(i);
            GftItem[] gftItemArray2 = new GftItem[gftGrid.Bands_cellCount()];
            for (int j = 0; j < gftItemArray2.length; ++j) {
                gftItemArray2[j] = gftItemArray[n++];
            }
            gftGrid.Exec(gftItem, gftItemArray2);
        }
    }

    void ExecBands(GftItem gftItem, GftItem[] gftItemArray) {
        int n;
        if (this.bands.Count() == 0) {
            return;
        }
        int n2 = gftItem.Gft_h();
        GftBand gftBand = null;
        int n3 = this.bandDir.GetValByDir(this.bands.Idx_last(), 0);
        int n4 = this.bandDir.GetValByDir(-1, this.bands.Count());
        for (n = n3; n != n4; n += this.bandDir.Val()) {
            gftBand = (GftBand)this.bands.Get_at(n);
            if (gftBand.Len1().Key() != 2) continue;
            GftSizeCalc_abs gftSizeCalc_abs = (GftSizeCalc_abs)gftBand.Len1();
            n2 -= gftSizeCalc_abs.Val();
        }
        n = 0;
        gftBand = (GftBand)this.bands.Get_at(n);
        gftBand.Items().Clear();
        int n5 = this.bandDir.GetValByDir(gftItem.Gft_h(), 0);
        for (int i = 0; i < gftItemArray.length; ++i) {
            GftItem gftItem2 = gftItemArray[i];
            if (gftBand.Items().Count() >= gftBand.Cells().Count()) {
                int n6 = gftBand.Len1().Calc(this, gftBand, gftItem, gftItem2, n2);
                gftBand.Calc(gftItem, n5, n6);
                n5 += n6 * this.bandDir.Val();
                if (n + 1 >= this.bands.Count()) {
                    throw Err_.new_wo_type("error retrieving band", "owner", gftItem.Key_of_GfuiElem(), "item", gftItem2.Key_of_GfuiElem(), "bandIdx", n + 1, "count", this.bands.Count());
                }
                gftBand = (GftBand)this.bands.Get_at(++n);
                gftBand.Items().Clear();
            }
            gftBand.Items_add(gftItem2);
        }
        gftBand.Calc(gftItem, n5, gftBand.Len1().Calc(this, gftBand, gftItem, null, n2));
    }

    int Bands_cellCount() {
        int n = 0;
        for (int i = 0; i < this.bands.Count(); ++i) {
            GftBand gftBand = (GftBand)this.bands.Get_at(i);
            n += gftBand.Cells().Count();
        }
        return n;
    }

    public static GftGrid new_() {
        return new GftGrid();
    }

    GftGrid() {
    }

    public static void LytExecRecur(GfuiElemBase gfuiElemBase) {
        if (gfuiElemBase.Lyt() != null) {
            gfuiElemBase.Lyt_exec();
        }
        for (int i = 0; i < gfuiElemBase.SubElems().Count(); ++i) {
            GfuiElemBase gfuiElemBase2 = (GfuiElemBase)gfuiElemBase.SubElems().Get_at(i);
            GftGrid.LytExecRecur(gfuiElemBase2);
        }
    }
}

