/*
 * Decompiled with CFR 0.152.
 */
package gplx.gfui.controls.windows;

import gplx.GfoMsg;
import gplx.GfsCtx;
import gplx.Keyval_hash;
import gplx.Math_;
import gplx.core.envs.Env_;
import gplx.gfui.RectAdp;
import gplx.gfui.SizeAdp;
import gplx.gfui.SizeAdp_;
import gplx.gfui.controls.gxws.GxwElem;
import gplx.gfui.controls.gxws.GxwElemFactory_;
import gplx.gfui.controls.gxws.GxwWin;
import gplx.gfui.controls.standards.GfuiTextBox_;
import gplx.gfui.controls.standards.GfuiTextMemo;
import gplx.gfui.controls.windows.GfuiWin;
import gplx.gfui.controls.windows.PopupState;
import gplx.gfui.draws.ColorAdp_;
import gplx.gfui.draws.FontAdp;
import gplx.gfui.draws.FontStyleAdp_;
import gplx.gfui.envs.ScreenAdp_;
import gplx.gfui.envs.TimerAdp;

public class GfuiWin_toaster
extends GfuiWin {
    static final int PopupAnchorTop = -1;
    public static final String Tmr_cmd = "Tmr";
    GfuiTextMemo messageLabel;
    TimerAdp timer;
    SizeAdp fullyGrown = SizeAdp_.Zero;
    int growingIncrement;
    int shrinkingIncrement;
    int growingTimerInterval;
    int shrinkingTimerInterval;
    int fullyGrownTimerInterval;
    PopupState popupState = PopupState.FullyShrunk;

    public void ShowPopup(GfuiWin gfuiWin, String string, int n) {
        this.TaskbarParkingWindowFix(gfuiWin);
        this.ShowPopup(string, n);
    }

    void ShowPopup(String string, int n) {
        if (Env_.Mode_testing()) {
            return;
        }
        this.messageLabel.Text_(string);
        this.messageLabel.SelBgn_set(0);
        this.InitVariables(500, n * 1000, 500);
        this.BeginPoppingUp();
    }

    void InitVariables(int n, int n2, int n3) {
        this.popupState = PopupState.FullyShrunk;
        this.fullyGrownTimerInterval = n2;
        int n4 = 0;
        if (n > 10) {
            n4 = Math_.Min(n / 10, this.fullyGrown.Height());
            this.growingTimerInterval = n / n4;
            this.growingIncrement = this.fullyGrown.Height() / n4;
        } else {
            this.growingTimerInterval = 10;
            this.growingIncrement = this.fullyGrown.Height();
        }
        if (n3 > 10) {
            n4 = Math_.Min(n3 / 10, this.fullyGrown.Height());
            this.shrinkingTimerInterval = n3 / n4;
            this.shrinkingIncrement = this.fullyGrown.Height() / n4;
        } else {
            this.shrinkingTimerInterval = 10;
            this.shrinkingIncrement = this.fullyGrown.Height();
        }
    }

    void BeginPoppingUp() {
        RectAdp rectAdp = ScreenAdp_.Primary.Rect();
        int n = rectAdp.X() + rectAdp.Width();
        int n2 = this.popupState.Val();
        if (n2 == PopupState.FullyShrunk.Val()) {
            this.Size_(SizeAdp_.new_(this.Width(), 0));
            this.Pos_(n / 2 - this.Width() / 2, -1);
            if (!this.Visible()) {
                this.Visible_on_();
            }
            this.timer.Interval_(this.growingTimerInterval);
            this.popupState = PopupState.Growing;
        } else if (n2 == PopupState.Growing.Val()) {
            this.Redraw();
        } else if (n2 == PopupState.FullyGrown.Val()) {
            this.timer.Interval_(this.fullyGrownTimerInterval);
            this.Redraw();
        } else if (n2 == PopupState.Shrinking.Val()) {
            this.Size_(SizeAdp_.new_(this.Width(), 0));
            this.Pos_(n / 2 - this.Width() / 2, -1);
            this.timer.Interval_(this.fullyGrownTimerInterval);
            this.popupState = PopupState.FullyGrown;
        }
        this.timer.Enabled_on();
    }

    void WhenTick() {
        int n = this.fullyGrown.Height();
        int n2 = this.popupState.Val();
        if (n2 == PopupState.Growing.Val()) {
            if (this.Height() < n) {
                this.ChangeBounds(true, this.growingIncrement);
            } else {
                this.Height_(n);
                this.timer.Interval_(this.fullyGrownTimerInterval);
                this.popupState = PopupState.FullyGrown;
            }
        } else if (n2 == PopupState.FullyGrown.Val()) {
            this.timer.Interval_(this.shrinkingTimerInterval);
            this.popupState = PopupState.Shrinking;
        } else if (n2 == PopupState.Shrinking.Val()) {
            if (this.Height() > 2) {
                this.ChangeBounds(false, this.shrinkingIncrement);
            } else {
                this.Visible_off_();
                this.popupState = PopupState.FullyShrunk;
                this.timer.Enabled_off();
            }
        }
    }

    void ChangeBounds(boolean bl, int n) {
        n = bl ? n : -n;
        this.Pos_(this.X(), -1);
        this.Size_(SizeAdp_.new_(this.Width(), this.Height() + n));
    }

    @Override
    public GxwElem UnderElem_make(Keyval_hash keyval_hash) {
        return GxwElemFactory_.Instance.win_toaster_(keyval_hash);
    }

    @Override
    public void ctor_GfuiBox_base(Keyval_hash keyval_hash) {
        super.ctor_GfuiBox_base(keyval_hash);
        this.fullyGrown = SizeAdp_.new_(600, 96);
        this.Pos_(-100, -100);
        this.Size_(this.fullyGrown);
        super.Show();
        super.Hide();
        this.messageLabel = GfuiTextBox_.multi_("messageLabel", this);
        this.messageLabel.Size_(this.fullyGrown.Width(), this.fullyGrown.Height()).ForeColor_(ColorAdp_.Green);
        this.messageLabel.TextMgr().Font_(FontAdp.new_("Arial", 8.0f, FontStyleAdp_.Bold));
        this.messageLabel.Border_on_(true);
        this.messageLabel.Focus_able_(false);
        this.timer = TimerAdp.new_(this, Tmr_cmd, 3000, false);
        GxwWin gxwWin = (GxwWin)this.UnderElem();
        if (gxwWin != null) {
            gxwWin.Pin_set(true);
            gxwWin.TaskbarVisible_set(false);
        }
    }

    @Override
    public Object Invk(GfsCtx gfsCtx, int n, String string, GfoMsg gfoMsg) {
        if (gfsCtx.Match(string, Tmr_cmd)) {
            this.WhenTick();
        } else {
            super.Invk(gfsCtx, n, string, gfoMsg);
        }
        return this;
    }

    public static GfuiWin_toaster new_(GfuiWin gfuiWin) {
        GfuiWin_toaster gfuiWin_toaster = new GfuiWin_toaster();
        gfuiWin_toaster.ctor_GfuiBox_base(new Keyval_hash().Add("focusAble", false).Add("ownerForm", gfuiWin).Add("winType", "toaster"));
        return gfuiWin_toaster;
    }
}

