/*
 * Decompiled with CFR 0.152.
 */
package gplx.gfml;

import gplx.Array_;
import gplx.Err_;

class IntObjHash_base {
    int count;
    Object[] rootAry = new Object[0];
    int maxKey = -1;
    int rootIdx;
    int subIdx;
    Object bay = null;
    static final int subAryLength = 16;

    IntObjHash_base() {
    }

    public int Count() {
        return this.count;
    }

    public boolean Has(int n) {
        return this.Get_by(n) != null;
    }

    public Object Get_by(int n) {
        if (n < 0) {
            throw Err_.new_wo_type("key must be >= 0", "key", n);
        }
        if (n > this.maxKey) {
            return null;
        }
        Object[] objectArray = this.FetchSubAry(n);
        return objectArray == null ? null : objectArray[this.subIdx];
    }

    public void Add(int n, Object object) {
        this.PutObjAtKey(n, object, true);
    }

    public void Set(int n, Object object) {
        this.PutObjAtKey(n, object, false);
    }

    public void Del(int n) {
        if (n > this.maxKey) {
            return;
        }
        Object[] objectArray = this.FetchSubAry(n);
        if (objectArray == null) {
            return;
        }
        objectArray[this.subIdx] = null;
        --this.count;
    }

    public void Clear() {
        this.rootAry = new Object[0];
        this.count = 0;
        this.maxKey = -1;
    }

    void PutObjAtKey(int n, Object object, boolean bl) {
        Object[] objectArray;
        if (n < 0) {
            throw Err_.new_wo_type("key must be >= 0", "key", n);
        }
        if (object == null) {
            throw Err_.new_wo_type("Object cannot be null; call .Del on key instead", "key", n);
        }
        if (n > this.maxKey) {
            this.ExpandRootAry(n);
        }
        if ((objectArray = this.FetchSubAry(n)) == null) {
            this.rootAry[this.rootIdx] = objectArray = new Object[16];
        }
        Object object2 = objectArray[this.subIdx];
        if (bl && object2 != null) {
            throw Err_.new_wo_type(".Add cannot be called on non-null vals; call .Set instead", "key", n, "val", object2);
        }
        if (!bl && object2 == null) {
            throw Err_.new_wo_type(".Set cannot be called on null vals; call .Add instead", "key", n);
        }
        objectArray[this.subIdx] = object;
        if (bl) {
            ++this.count;
        }
    }

    void ExpandRootAry(int n) {
        int n2 = n / 16 + 1;
        Object[] objectArray = new Object[n2];
        Array_.Copy(this.rootAry, objectArray);
        this.rootAry = objectArray;
        this.maxKey = this.rootAry.length * 16 - 1;
    }

    Object[] FetchSubAry(int n) {
        this.rootIdx = n / 16;
        this.subIdx = n % 16;
        return (Object[])this.rootAry[this.rootIdx];
    }

    public Object Bay() {
        return this.bay;
    }

    public void Bay_set(Object object) {
        this.bay = object;
    }
}

