/*
 * Decompiled with CFR 0.152.
 */
package gplx.gflucene.indexers;

import gplx.Err_;
import gplx.gflucene.analyzers.Gflucene_analyzer_mgr_;
import gplx.gflucene.core.Gflucene_doc_data;
import gplx.gflucene.core.Gflucene_index_data;
import gplx.gflucene.indexers.Gflucene_idx_opt;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.lukhnos.portmobile.file.Path;
import org.lukhnos.portmobile.file.Paths;

public class Gflucene_indexer_mgr {
    private Analyzer analyzer;
    private IndexWriterConfig config;
    private Directory index;
    private IndexWriter wtr;
    private FieldType body_fld_type;

    public void Init(Gflucene_index_data gflucene_index_data, String string) {
        this.analyzer = Gflucene_analyzer_mgr_.New_analyzer(gflucene_index_data.analyzer_data.key);
        this.config = new IndexWriterConfig(this.analyzer);
        TieredMergePolicy tieredMergePolicy = new TieredMergePolicy();
        gflucene_index_data.getClass();
        tieredMergePolicy.setMaxMergedSegmentMB(1500.0);
        this.config.setMergePolicy((MergePolicy)tieredMergePolicy);
        Path path = Paths.get((String)gflucene_index_data.index_dir);
        try {
            this.index = FSDirectory.open((Path)path);
        }
        catch (IOException iOException) {
            throw Err_.new_exc(iOException, "lucene_index", "failed to open lucene index", "path", path);
        }
        try {
            this.wtr = new IndexWriter(this.index, this.config);
        }
        catch (IOException iOException) {
            throw Err_.new_exc(iOException, "lucene_index", "failed to create writer", new Object[0]);
        }
        this.body_fld_type = new FieldType();
        IndexOptions indexOptions = Gflucene_indexer_mgr.To_index_options(string);
        this.body_fld_type.setIndexOptions(indexOptions);
        this.body_fld_type.setTokenized(true);
        this.body_fld_type.setStored(false);
    }

    public void Exec(Gflucene_doc_data gflucene_doc_data) {
        Document document = new Document();
        document.add((IndexableField)new StoredField("page_id", gflucene_doc_data.page_id));
        document.add((IndexableField)new NumericDocValuesField("page_score", (long)gflucene_doc_data.score));
        TextField textField = new TextField("title", gflucene_doc_data.title, Field.Store.YES);
        document.add((IndexableField)textField);
        Field field = new Field("body", gflucene_doc_data.body, this.body_fld_type);
        document.add((IndexableField)field);
        try {
            this.wtr.addDocument((Iterable)document);
        }
        catch (IOException iOException) {
            throw Err_.new_exc(iOException, "lucene_index", "failed to add document", "title", gflucene_doc_data.title);
        }
    }

    public void Term() {
        try {
            this.wtr.close();
        }
        catch (IOException iOException) {
            throw Err_.new_exc(iOException, "lucene_index", "failed to close writer", new Object[0]);
        }
        try {
            this.index.close();
        }
        catch (IOException iOException) {
            throw Err_.new_exc(iOException, "lucene_index", "failed to close writer", new Object[0]);
        }
    }

    private static IndexOptions To_index_options(String string) {
        Gflucene_idx_opt gflucene_idx_opt = Gflucene_idx_opt.Parse(string);
        switch (gflucene_idx_opt.Uid()) {
            case 0: {
                return IndexOptions.DOCS;
            }
            case 1: {
                return IndexOptions.DOCS_AND_FREQS;
            }
            case 2: {
                return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
            }
            case 3: {
                return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
            }
        }
        throw Err_.new_unhandled_default(gflucene_idx_opt.Uid());
    }
}

