/*
 * Decompiled with CFR 0.152.
 */
package gplx.fsdb.meta;

import gplx.Err_;
import gplx.Hash_adp;
import gplx.Hash_adp_;
import gplx.dbs.Db_conn;
import gplx.dbs.cfgs.Db_cfg_hash;
import gplx.dbs.cfgs.Db_cfg_tbl;
import gplx.fsdb.Fsdb_db_mgr;

public class Fsm_cfg_mgr {
    private final Db_cfg_tbl tbl;
    private final Hash_adp grp_hash = Hash_adp_.New();
    private int next_id = 1;
    private boolean schema_thm_page = true;
    private boolean patch__next_id = true;
    private boolean patch__page_gt_1 = false;
    public static final String Grp_core = "core";
    public static final String Key_next_id = "next_id";
    public static final String Key_schema_thm_page = "schema.thm.page";
    public static final String Key_patch__next_id = "patch.next_id";
    public static final String Key_patch__page_gt_1 = "patch.page_gt_1";

    public Fsm_cfg_mgr(Fsdb_db_mgr fsdb_db_mgr, Db_conn db_conn) {
        this.tbl = new Db_cfg_tbl(db_conn, fsdb_db_mgr.File__cfg_tbl_name());
    }

    public void Ctor_by_load() {
        Db_cfg_hash db_cfg_hash = this.Grps_get_or_load(Grp_core);
        this.next_id = db_cfg_hash.Get_by(Key_next_id).To_int_or(-1);
        if (this.next_id == -1) {
            throw Err_.new_wo_type("next_id not found in cfg", "url", this.tbl.Conn().Conn_info().Db_api());
        }
        this.schema_thm_page = db_cfg_hash.Get_by(Key_schema_thm_page).To_yn_or_n();
        this.patch__next_id = db_cfg_hash.Get_by(Key_patch__next_id).To_yn_or_n();
        this.patch__page_gt_1 = db_cfg_hash.Get_by(Key_patch__page_gt_1).To_yn_or_n();
    }

    public Db_cfg_tbl Tbl() {
        return this.tbl;
    }

    public int Next_id() {
        return this.next_id++;
    }

    public void Next_id_commit() {
        this.tbl.Update_int(Grp_core, Key_next_id, this.next_id);
    }

    public boolean Schema_thm_page() {
        return this.schema_thm_page;
    }

    public boolean Patch_next_id() {
        return this.patch__next_id;
    }

    public void Patch_next_id_exec(int n) {
        if (n >= this.next_id) {
            this.next_id = n + 1;
        }
        this.tbl.Insert_yn(Grp_core, Key_patch__next_id, true);
    }

    public boolean Patch__page_gt_1() {
        return this.patch__page_gt_1;
    }

    public void Patch__save(String string) {
        this.tbl.Insert_yn(Grp_core, string, true);
    }

    public Db_cfg_hash Grps_get_or_load(String string) {
        Db_cfg_hash db_cfg_hash = (Db_cfg_hash)this.grp_hash.Get_by(string);
        if (db_cfg_hash == null) {
            db_cfg_hash = this.tbl.Select_as_hash(string);
            this.grp_hash.Add(string, db_cfg_hash);
        }
        return db_cfg_hash;
    }
}

