/*
 * Decompiled with CFR 0.152.
 */
package gplx.dbs.engines.tdbs;

import gplx.Err_;
import gplx.Internal;
import gplx.Type_;
import gplx.core.gfo_ndes.GfoFldList;
import gplx.core.gfo_ndes.GfoFldList_;
import gplx.core.gfo_ndes.GfoNde;
import gplx.core.gfo_ndes.GfoNdeList;
import gplx.core.gfo_ndes.GfoNdeList_;
import gplx.core.stores.DataRdr;
import gplx.core.stores.DataWtr;
import gplx.core.stores.GfoNdeRdr;
import gplx.core.stores.GfoNdeRdr_;
import gplx.dbs.engines.tdbs.TdbFile;
import gplx.dbs.engines.tdbs.TdbStores;
import gplx.langs.dsvs.DsvStoreLayout;

public class TdbTable {
    int id;
    private String name;
    GfoFldList flds = GfoFldList_.new_();
    GfoNdeList rows = GfoNdeList_.new_();
    TdbFile file;
    private boolean isLoaded = true;
    private boolean isDirty = false;
    DsvStoreLayout layout;

    public int Id() {
        return this.id;
    }

    public String Name() {
        return this.name;
    }

    public GfoFldList Flds() {
        return this.flds;
    }

    public GfoNdeList Rows() {
        return this.rows;
    }

    @Internal
    protected TdbFile File() {
        return this.file;
    }

    @Internal
    protected boolean IsLoaded() {
        return this.isLoaded;
    }

    @Internal
    protected boolean IsDirty() {
        return this.isDirty;
    }

    public void IsDirty_set(boolean bl) {
        this.isDirty = bl;
    }

    public static TdbTable new_(int n, String string, TdbFile tdbFile) {
        TdbTable tdbTable = new TdbTable();
        tdbTable.ctor(n, string, tdbFile);
        tdbTable.isDirty = true;
        return tdbTable;
    }

    TdbTable() {
    }

    public static TdbTable load_(int n, String string, TdbFile tdbFile) {
        TdbTable tdbTable = new TdbTable();
        tdbTable.ctor(n, string, tdbFile);
        tdbTable.isLoaded = false;
        return tdbTable;
    }

    void ctor(int n, String string, TdbFile tdbFile) {
        this.id = n;
        this.name = string;
        this.file = tdbFile;
        this.layout = DsvStoreLayout.dsv_full_();
    }

    @Internal
    protected void DataObj_Wtr(DataWtr dataWtr) {
        dataWtr.InitWtr("StoreLayoutWtr", this.layout);
        dataWtr.WriteTableBgn(this.name, this.flds);
        for (int i = 0; i < this.rows.Count(); ++i) {
            GfoNde gfoNde = this.rows.FetchAt_asGfoNde(i);
            dataWtr.WriteLeafBgn("row");
            for (int j = 0; j < gfoNde.Flds().Count(); ++j) {
                dataWtr.WriteData(gfoNde.Flds().Get_at(j).Key(), gfoNde.ReadAt(j));
            }
            dataWtr.WriteLeafEnd();
        }
        dataWtr.WriteNodeEnd();
        this.isDirty = false;
    }

    @Internal
    protected void DataObj_Rdr(DataRdr dataRdr) {
        this.layout = TdbStores.FetchLayout(dataRdr);
        GfoNdeRdr gfoNdeRdr = GfoNdeRdr_.as_(dataRdr);
        if (gfoNdeRdr != null) {
            if (gfoNdeRdr.UnderNde() == null) {
                throw Err_.new_wo_type("ndeRdr.UnderNde is null", "name", dataRdr.NameOfNode());
            }
        } else {
            throw Err_.new_invalid_op("TableLoad not implemented").Args_add("rdrType", Type_.Name_by_obj(dataRdr), "rdrName", dataRdr.NameOfNode());
        }
        this.rows = gfoNdeRdr.UnderNde().Subs();
        this.flds = gfoNdeRdr.UnderNde().SubFlds();
        this.isLoaded = true;
    }

    public static TdbTable as_(Object object) {
        return object instanceof TdbTable ? (TdbTable)object : null;
    }

    public static TdbTable cast(Object object) {
        try {
            return (TdbTable)object;
        }
        catch (Exception exception) {
            throw Err_.new_type_mismatch_w_exc(exception, TdbTable.class, object);
        }
    }
}

