/*
 * Decompiled with CFR 0.152.
 */
package gplx.dbs.engines.tdbs;

import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.Err_;
import gplx.Keyval;
import gplx.String_;
import gplx.core.gfo_ndes.GfoFldList;
import gplx.core.gfo_ndes.GfoNde;
import gplx.core.gfo_ndes.GfoNde_;
import gplx.core.stores.DataRdr;
import gplx.dbs.Db_qry;
import gplx.dbs.engines.Db_engine;
import gplx.dbs.engines.tdbs.Db_qryWkr;
import gplx.dbs.engines.tdbs.TdbEngine;
import gplx.dbs.engines.tdbs.TdbSelectWkr;
import gplx.dbs.engines.tdbs.TdbTable;
import gplx.dbs.qrys.Db_arg;
import gplx.dbs.qrys.Db_qry_insert;
import gplx.dbs.sqls.itms.Sql_select_fld;
import gplx.dbs.sqls.itms.Sql_select_fld_list;

class TdbInsertWkr
implements Db_qryWkr {
    TdbInsertWkr() {
    }

    @Override
    public Object Exec(Db_engine db_engine, Db_qry db_qry) {
        TdbEngine tdbEngine = TdbEngine.cast(db_engine);
        Db_qry_insert db_qry_insert = (Db_qry_insert)db_qry;
        TdbTable tdbTable = tdbEngine.FetchTbl(db_qry_insert.Base_table());
        tdbTable.IsDirty_set(true);
        return db_qry_insert.Select() == null ? this.InsertRowsByVals(tdbEngine, tdbTable, db_qry_insert) : this.InsertRowsBySelect(tdbEngine, tdbTable, db_qry_insert);
    }

    int InsertRowsBySelect(TdbEngine tdbEngine, TdbTable tdbTable, Db_qry_insert db_qry_insert) {
        int n = 0;
        DataRdr dataRdr = (DataRdr)TdbSelectWkr.Instance.Exec(tdbEngine, db_qry_insert.Select());
        Sql_select_fld_list sql_select_fld_list = db_qry_insert.Cols();
        int n2 = sql_select_fld_list.Len();
        GfoFldList gfoFldList = null;
        try {
            gfoFldList = TdbSelectWkr.To_GfoFldLst(tdbTable, sql_select_fld_list);
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "failed to generate flds for new row", new Object[0]);
        }
        if (n2 > gfoFldList.Count()) {
            throw Err_.new_wo_type("insert flds cannot exceed selectFlds", "insertFlds", this.To_str(sql_select_fld_list), "selectFlds", gfoFldList.To_str());
        }
        while (dataRdr.MoveNextPeer()) {
            ++n;
            GfoNde gfoNde = GfoNde_.vals_(gfoFldList, new Object[n2]);
            for (int i = 0; i < n2; ++i) {
                gfoNde.WriteAt(i, dataRdr.ReadAt(i));
            }
            tdbTable.Rows().Add(gfoNde);
        }
        return n;
    }

    int InsertRowsByVals(TdbEngine tdbEngine, TdbTable tdbTable, Db_qry_insert db_qry_insert) {
        GfoNde gfoNde = GfoNde_.vals_(tdbTable.Flds(), new Object[tdbTable.Flds().Count()]);
        for (int i = 0; i < db_qry_insert.Args().Count(); ++i) {
            Keyval keyval = db_qry_insert.Args().Get_at(i);
            Db_arg db_arg = (Db_arg)keyval.Val();
            gfoNde.Write(keyval.Key(), db_arg.Val);
        }
        tdbTable.Rows().Add(gfoNde);
        return 1;
    }

    private String To_str(Sql_select_fld_list sql_select_fld_list) {
        Bry_bfr bry_bfr = Bry_bfr_.New();
        for (int i = 0; i < sql_select_fld_list.Len(); ++i) {
            Sql_select_fld sql_select_fld = sql_select_fld_list.Get_at(i);
            bry_bfr.Add_str_u8(String_.Format("{0},{1}|", sql_select_fld.Fld, sql_select_fld.Alias));
        }
        return bry_bfr.To_str();
    }

    public static TdbInsertWkr new_() {
        TdbInsertWkr tdbInsertWkr = new TdbInsertWkr();
        return tdbInsertWkr;
    }
}

