/*
 * Decompiled with CFR 0.152.
 */
package gplx.dbs.engines.tdbs;

import gplx.Err_;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.String_;
import gplx.core.stores.DataRdr;
import gplx.dbs.engines.tdbs.TdbDatabase;
import gplx.dbs.engines.tdbs.TdbStores;
import gplx.dbs.engines.tdbs.TdbTable;

class TdbDbLoadMgr {
    public TdbDatabase LoadTbls(Io_url io_url) {
        TdbDatabase tdbDatabase = TdbDatabase.new_(io_url);
        if (!Io_mgr.Instance.ExistsFil(io_url)) {
            tdbDatabase.IsNew_set(true);
            return tdbDatabase;
        }
        DataRdr dataRdr = this.MakeDataRdr(io_url);
        this.LoadTblsByRdr(tdbDatabase, dataRdr);
        return tdbDatabase;
    }

    public void LoadTbl(TdbDatabase tdbDatabase, TdbTable tdbTable) {
        DataRdr dataRdr = this.MakeDataRdr(tdbTable.File().Path());
        this.LoadTblsByRdr(tdbDatabase, dataRdr);
    }

    void LoadTblsByRdr(TdbDatabase tdbDatabase, DataRdr dataRdr) {
        DataRdr dataRdr2 = dataRdr.Subs();
        while (dataRdr2.MoveNextPeer()) {
            String string = dataRdr2.NameOfNode();
            if (String_.Eq(string, "_files")) {
                tdbDatabase.Files().DataObj_Rdr(dataRdr2);
                continue;
            }
            if (String_.Eq(string, "_tables")) {
                tdbDatabase.Tables().DataObj_Rdr(dataRdr2, tdbDatabase.Files());
                continue;
            }
            tdbDatabase.Tables().Get_by_or_fail(dataRdr2.NameOfNode()).DataObj_Rdr(dataRdr2);
        }
        if (tdbDatabase.Files().Count() == 0) {
            throw Err_.new_wo_type("fatal error: db has no files", "connectInfo", tdbDatabase.DbUrl());
        }
    }

    DataRdr MakeDataRdr(Io_url io_url) {
        String string = Io_mgr.Instance.LoadFilStr(io_url);
        return TdbStores.rdr_(string);
    }

    public static TdbDbLoadMgr new_() {
        return new TdbDbLoadMgr();
    }

    TdbDbLoadMgr() {
    }
}

