/*
 * Decompiled with CFR 0.152.
 */
package gplx.dbs.engines.sqlite;

import gplx.Gfo_usr_dlg_;
import gplx.List_adp;
import gplx.List_adp_;
import gplx.String_;
import gplx.dbs.engines.Db_engine;
import gplx.dbs.qrys.Db_qry_sql;

public class Sqlite_txn_mgr {
    private final List_adp txn_list = List_adp_.New();
    private final Db_engine engine;
    private boolean pragma_needed = true;
    private boolean txn_started = false;

    public Sqlite_txn_mgr(Db_engine db_engine) {
        this.engine = db_engine;
    }

    public void Txn_bgn(String string) {
        if (String_.Len_eq_0(string)) {
            string = "unnamed";
        }
        if (this.pragma_needed) {
            this.pragma_needed = false;
            this.engine.Exec_as_obj(Db_qry_sql.xtn_("PRAGMA synchronous = OFF;"));
        }
        if (this.txn_started) {
            this.engine.Exec_as_obj(Db_qry_sql.xtn_(String_.Format("SAVEPOINT {0};", string)));
        } else {
            this.txn_started = true;
            this.engine.Exec_as_obj(Db_qry_sql.xtn_("BEGIN TRANSACTION;"));
        }
        this.txn_list.Add(string);
    }

    public String Txn_end() {
        if (this.txn_list.Count() == 0) {
            Gfo_usr_dlg_.Instance.Warn_many("", "", "no txns in stack;", new Object[0]);
            return "";
        }
        String string = (String)List_adp_.Pop_last(this.txn_list);
        if (this.txn_list.Count() == 0) {
            this.engine.Exec_as_obj(Db_qry_sql.xtn_("COMMIT TRANSACTION;"));
            this.txn_started = false;
        } else {
            this.engine.Exec_as_obj(Db_qry_sql.xtn_(String_.Format("RELEASE SAVEPOINT {0};", string)));
        }
        return string;
    }

    public void Txn_cxl() {
        if (this.txn_list.Count() == 0) {
            Gfo_usr_dlg_.Instance.Warn_many("", "", "no txns in stack;", new Object[0]);
            return;
        }
        String string = (String)List_adp_.Pop_last(this.txn_list);
        if (this.txn_list.Count() == 0) {
            this.engine.Exec_as_obj(Db_qry_sql.xtn_("ROLLBACK TRANSACTION;"));
            this.txn_started = false;
        } else {
            this.engine.Exec_as_obj(Db_qry_sql.xtn_(String_.Format("ROLBACK TRANSACTION TO SAVEPOINT {0};", string)));
        }
    }

    public void Txn_sav() {
        if (this.txn_list.Count() == 0) {
            Gfo_usr_dlg_.Instance.Warn_many("", "", "no txns in stack;", new Object[0]);
            return;
        }
        String string = (String)this.txn_list.Get_at(this.txn_list.Count() - 1);
        this.Txn_end();
        this.Txn_bgn(string);
    }
}

