/*
 * Decompiled with CFR 0.152.
 */
package gplx.dbs.engines.sqlite;

import gplx.DateAdp;
import gplx.DateAdp_;
import gplx.Err_;
import gplx.Int_;
import gplx.dbs.Db_rdr__basic;

class Db_rdr__sqlite
extends Db_rdr__basic {
    Db_rdr__sqlite() {
    }

    @Override
    public byte Read_byte(String string) {
        try {
            return (byte)Int_.Cast(this.rdr.getObject(string));
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "read failed", "k", string, "type", "byte");
        }
    }

    @Override
    public boolean Read_bool_by_byte(String string) {
        try {
            int n = this.rdr.getInt(string);
            return n == 1;
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "read failed", "i", string, "type", "bool");
        }
    }

    @Override
    public long Read_long(String string) {
        try {
            long l = this.rdr.getLong(string);
            Long l2 = l;
            return l2;
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "read failed", "i", string, "type", "long");
        }
    }

    @Override
    public float Read_float(String string) {
        try {
            Double d = this.rdr.getDouble(string);
            return d == null ? Float.NaN : d.floatValue();
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "read failed:", "i", string, "type", "float");
        }
    }

    @Override
    public DateAdp Read_date_by_str(String string) {
        try {
            String string2 = this.rdr.getString(string);
            return string2 == null ? null : DateAdp_.parse_fmt(string2, "yyyyMMdd_HHmmss");
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "read failed", "i", string, "type", DateAdp_.Cls_ref_type);
        }
    }
}

