/*
 * Decompiled with CFR 0.152.
 */
package gplx.dbs.engines.mems;

import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.DateAdp;
import gplx.Decimal_adp;
import gplx.Err_;
import gplx.Ordered_hash;
import gplx.Ordered_hash_;
import gplx.String_;
import gplx.core.ios.streams.Io_stream_rdr;
import gplx.core.ios.streams.Io_stream_rdr_;
import gplx.core.stores.DataRdr;
import gplx.dbs.Db_qry;
import gplx.dbs.Db_rdr;
import gplx.dbs.Db_stmt;
import gplx.dbs.Dbmeta_fld_itm;
import gplx.dbs.engines.Db_engine;
import gplx.dbs.engines.mems.Mem_engine;
import gplx.dbs.engines.mems.Mem_stmt_args;
import gplx.dbs.engines.mems.Mem_tbl;

public class Mem_stmt
implements Db_stmt {
    private static final String Key_na = "";
    private final Ordered_hash val_list = Ordered_hash_.New();
    private Mem_engine engine;
    private final Mem_stmt_args stmt_args = new Mem_stmt_args();
    private Db_qry qry;

    public Mem_stmt(Mem_engine mem_engine, Db_qry db_qry) {
        this.Ctor_stmt(mem_engine, db_qry);
    }

    @Override
    public void Ctor_stmt(Db_engine db_engine, Db_qry db_qry) {
        this.engine = (Mem_engine)db_engine;
        this.qry = db_qry;
    }

    public Mem_stmt_args Stmt_args() {
        return this.stmt_args;
    }

    public int Args_len() {
        return this.val_list.Count();
    }

    public Object Args_get_at(int n) {
        return this.val_list.Get_at(n);
    }

    public Object Args_get_by(String string) {
        return this.val_list.Get_by(string);
    }

    public Db_qry Qry() {
        return this.qry;
    }

    @Override
    public Db_stmt Reset_stmt() {
        return this;
    }

    @Override
    public Db_stmt Clear() {
        this.val_list.Clear();
        this.stmt_args.Clear();
        return this;
    }

    @Override
    public void Rls() {
        this.Clear();
    }

    @Override
    public Db_stmt Crt_bool_as_byte(String string, boolean bl) {
        return this.Add_byte_by_bool(true, string, bl);
    }

    @Override
    public Db_stmt Val_bool_as_byte(String string, boolean bl) {
        return this.Add_byte_by_bool(false, string, bl);
    }

    @Override
    public Db_stmt Val_bool_as_byte(boolean bl) {
        return this.Add_byte_by_bool(false, Key_na, bl);
    }

    private Db_stmt Add_byte_by_bool(boolean bl, String string, boolean bl2) {
        return this.Add_byte(bl, string, bl2 ? (byte)1 : 0);
    }

    @Override
    public Db_stmt Crt_byte(String string, byte by) {
        return this.Add_byte(true, string, by);
    }

    @Override
    public Db_stmt Val_byte(String string, byte by) {
        return this.Add_byte(false, string, by);
    }

    @Override
    public Db_stmt Val_byte(byte by) {
        return this.Add_byte(false, Key_na, by);
    }

    private Db_stmt Add_byte(boolean bl, String string, byte by) {
        try {
            this.Add(string, bl, by);
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "failed to add value", "type", "byte", "val", by);
        }
        return this;
    }

    @Override
    public Db_stmt Crt_int(String string, int n) {
        return this.Add_int(true, string, n);
    }

    @Override
    public Db_stmt Val_int_by_bool(String string, boolean bl) {
        return this.Add_int(false, string, bl ? 1 : 0);
    }

    @Override
    public Db_stmt Val_int(String string, int n) {
        return this.Add_int(false, string, n);
    }

    @Override
    public Db_stmt Val_int(int n) {
        return this.Add_int(false, Key_na, n);
    }

    private Db_stmt Add_int(boolean bl, String string, int n) {
        try {
            this.Add(string, bl, n);
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "failed to add value", "type", "int", "val", n);
        }
        return this;
    }

    @Override
    public Db_stmt Crt_long(String string, long l) {
        return this.Add_long(true, string, l);
    }

    @Override
    public Db_stmt Val_long(String string, long l) {
        return this.Add_long(false, string, l);
    }

    @Override
    public Db_stmt Val_long(long l) {
        return this.Add_long(false, Key_na, l);
    }

    private Db_stmt Add_long(boolean bl, String string, long l) {
        try {
            this.Add(string, bl, l);
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "failed to add value", "type", "long", "val", l);
        }
        return this;
    }

    @Override
    public Db_stmt Crt_float(String string, float f) {
        return this.Add_float(true, string, f);
    }

    @Override
    public Db_stmt Val_float(String string, float f) {
        return this.Add_float(false, string, f);
    }

    @Override
    public Db_stmt Val_float(float f) {
        return this.Add_float(false, Key_na, f);
    }

    private Db_stmt Add_float(boolean bl, String string, float f) {
        try {
            this.Add(string, bl, Float.valueOf(f));
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "failed to add value", "type", "float", "val", Float.valueOf(f));
        }
        return this;
    }

    @Override
    public Db_stmt Crt_double(String string, double d) {
        return this.Add_double(true, string, d);
    }

    @Override
    public Db_stmt Val_double(String string, double d) {
        return this.Add_double(false, string, d);
    }

    @Override
    public Db_stmt Val_double(double d) {
        return this.Add_double(false, Key_na, d);
    }

    private Db_stmt Add_double(boolean bl, String string, double d) {
        try {
            this.Add(string, bl, d);
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "failed to add value", "type", "double", "val", d);
        }
        return this;
    }

    @Override
    public Db_stmt Crt_decimal(String string, Decimal_adp decimal_adp) {
        return this.Add_decimal(true, string, decimal_adp);
    }

    @Override
    public Db_stmt Val_decimal(String string, Decimal_adp decimal_adp) {
        return this.Add_decimal(false, string, decimal_adp);
    }

    @Override
    public Db_stmt Val_decimal(Decimal_adp decimal_adp) {
        return this.Add_decimal(false, Key_na, decimal_adp);
    }

    private Db_stmt Add_decimal(boolean bl, String string, Decimal_adp decimal_adp) {
        try {
            this.Add(string, bl, decimal_adp);
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "failed to add value", "type", "decimal", "val", decimal_adp);
        }
        return this;
    }

    @Override
    public Db_stmt Crt_bry(String string, byte[] byArray) {
        return this.Add_bry(true, string, byArray);
    }

    @Override
    public Db_stmt Val_bry(String string, byte[] byArray) {
        return this.Add_bry(false, string, byArray);
    }

    @Override
    public Db_stmt Val_bry(byte[] byArray) {
        return this.Add_bry(false, Key_na, byArray);
    }

    private Db_stmt Add_bry(boolean bl, String string, byte[] byArray) {
        try {
            this.Add(string, bl, byArray);
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "failed to add value", "type", "byte[]", "val", byArray.length);
        }
        return this;
    }

    @Override
    public Db_stmt Crt_bry_as_str(String string, byte[] byArray) {
        return this.Add_bry_as_str(true, string, byArray);
    }

    @Override
    public Db_stmt Val_bry_as_str(String string, byte[] byArray) {
        return this.Add_bry_as_str(false, string, byArray);
    }

    @Override
    public Db_stmt Val_bry_as_str(byte[] byArray) {
        return this.Add_bry_as_str(false, Key_na, byArray);
    }

    private Db_stmt Add_bry_as_str(boolean bl, String string, byte[] byArray) {
        return this.Add_str(bl, string, String_.new_u8(byArray));
    }

    @Override
    public Db_stmt Crt_str(String string, String string2) {
        return this.Add_str(true, string, string2);
    }

    @Override
    public Db_stmt Val_str(String string, String string2) {
        return this.Add_str(false, string, string2);
    }

    @Override
    public Db_stmt Val_str(String string) {
        return this.Add_str(false, Key_na, string);
    }

    private Db_stmt Add_str(boolean bl, String string, String string2) {
        try {
            this.Add(string, bl, string2);
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "failed to add value", "type", "String", "val", string2);
        }
        return this;
    }

    @Override
    public Db_stmt Crt_date(String string, DateAdp dateAdp) {
        return this.Add_date(true, string, dateAdp);
    }

    @Override
    public Db_stmt Val_date(String string, DateAdp dateAdp) {
        return this.Add_date(false, string, dateAdp);
    }

    private Db_stmt Add_date(boolean bl, String string, DateAdp dateAdp) {
        try {
            this.Add(string, bl, dateAdp);
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "failed to add value", "type", "date", "val", dateAdp);
        }
        return this;
    }

    @Override
    public Db_stmt Crt_text(String string, String string2) {
        return this.Add_text(true, string, string2);
    }

    @Override
    public Db_stmt Val_text(String string, String string2) {
        return this.Add_text(false, string, string2);
    }

    private Db_stmt Add_text(boolean bl, String string, String string2) {
        try {
            this.Add(string, bl, string2);
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "failed to add value", "type", "text", "val", string2);
        }
        return this;
    }

    @Override
    public Db_stmt Val_rdr_(Io_stream_rdr io_stream_rdr, long l) {
        try {
            Bry_bfr bry_bfr = Bry_bfr_.New();
            Io_stream_rdr_.Load_all_to_bfr(bry_bfr, io_stream_rdr);
            this.Add(Key_na, false, bry_bfr.To_str_and_clear());
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "failed to add value", "type", "rdr", "val", io_stream_rdr);
        }
        return this;
    }

    @Override
    public boolean Exec_insert() {
        Mem_tbl mem_tbl = this.engine.Tbls__get(this.qry.Base_table());
        if (mem_tbl == null) {
            throw Err_.new_wo_type("must call Create_tbl", "tbl", this.qry.Base_table());
        }
        return mem_tbl.Insert(this) == 1;
    }

    @Override
    public int Exec_update() {
        Mem_tbl mem_tbl = this.engine.Tbls__get(this.qry.Base_table());
        return mem_tbl.Update(this);
    }

    @Override
    public int Exec_delete() {
        Mem_tbl mem_tbl = this.engine.Tbls__get(this.qry.Base_table());
        return mem_tbl.Delete(this);
    }

    @Override
    public DataRdr Exec_select() {
        throw Err_.new_unimplemented();
    }

    @Override
    public Db_rdr Exec_select__rls_auto() {
        return this.Exec_select__rls_manual();
    }

    @Override
    public Db_rdr Exec_select__rls_manual() {
        return this.engine.Qry_runner().Select(this);
    }

    @Override
    public Object Exec_select_val() {
        throw Err_.new_unimplemented();
    }

    private void Add(String string, boolean bl, Object object) {
        if (string == Dbmeta_fld_itm.Key_null) {
            return;
        }
        this.val_list.Add_if_dupe_use_1st(string, object);
        if (bl) {
            this.stmt_args.Add(string, object);
        }
    }
}

