/*
 * Decompiled with CFR 0.152.
 */
package gplx.dbs.engines;

import gplx.Err_;
import gplx.Gfo_usr_dlg;
import gplx.Gfo_usr_dlg_;
import gplx.Internal;
import gplx.Io_url;
import gplx.Keyval;
import gplx.Virtual;
import gplx.core.stores.DataRdr;
import gplx.core.stores.Db_data_rdr_;
import gplx.dbs.Db_conn;
import gplx.dbs.Db_conn_info;
import gplx.dbs.Db_qry;
import gplx.dbs.Db_rdr;
import gplx.dbs.Db_rdr__basic;
import gplx.dbs.Db_stmt;
import gplx.dbs.Dbmeta_fld_itm;
import gplx.dbs.Dbmeta_idx_itm;
import gplx.dbs.Dbmeta_tbl_itm;
import gplx.dbs.conn_props.Db_conn_props_mgr;
import gplx.dbs.engines.Db_engine;
import gplx.dbs.metas.Dbmeta_tbl_mgr;
import gplx.dbs.qrys.Db_qry_sql;
import gplx.dbs.qrys.Db_stmt_cmd;
import gplx.dbs.qrys.bats.Db_batch_mgr;
import gplx.dbs.sqls.Sql_qry_wtr;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public abstract class Db_engine_sql_base
implements Db_engine {
    protected Db_conn_info conn_info;
    private final Db_conn_props_mgr props = new Db_conn_props_mgr();
    private final Db_batch_mgr batch_mgr = new Db_batch_mgr();
    protected Connection connection;

    @Internal
    protected void Ctor(Db_conn_info db_conn_info) {
        this.conn_info = db_conn_info;
    }

    @Override
    public abstract String Tid();

    @Override
    public Db_conn_info Conn_info() {
        return this.conn_info;
    }

    @Override
    public Db_conn_props_mgr Props() {
        return this.props;
    }

    @Override
    public Db_batch_mgr Batch_mgr() {
        return this.batch_mgr;
    }

    @Override
    public abstract Sql_qry_wtr Sql_wtr();

    @Override
    public abstract Db_engine New_clone(Db_conn_info var1);

    @Override
    public Db_rdr Exec_as_rdr__rls_manual(Object object, String string) {
        return this.New_rdr(null, object, string);
    }

    @Override
    public Db_rdr Exec_as_rdr__rls_auto(Db_stmt db_stmt, Object object, String string) {
        return this.New_rdr(db_stmt, object, string);
    }

    @Virtual
    public Db_rdr New_rdr_clone() {
        return new Db_rdr__basic();
    }

    @Override
    @Virtual
    public Db_stmt Stmt_by_qry(Db_qry db_qry) {
        return new Db_stmt_cmd(this, db_qry);
    }

    @Override
    @Virtual
    public void Txn_bgn(String string) {
        this.Exec_as_obj(Db_qry_sql.xtn_("BEGIN TRANSACTION;"));
    }

    @Override
    @Virtual
    public String Txn_end() {
        this.Exec_as_obj(Db_qry_sql.xtn_("COMMIT TRANSACTION;"));
        this.batch_mgr.Txn_end().Run(this);
        return "";
    }

    @Override
    @Virtual
    public void Txn_cxl() {
        this.Exec_as_obj(Db_qry_sql.xtn_("ROLLBACK TRANSACTION;"));
    }

    @Override
    @Virtual
    public void Txn_sav() {
        String string = this.Txn_end();
        this.Txn_bgn(string);
    }

    @Override
    public Object Exec_as_obj(Db_qry db_qry) {
        if (db_qry.Tid() == 6) {
            return null;
        }
        String string = this.Sql_wtr().To_sql_str(db_qry, false);
        return db_qry.Exec_is_rdr() ? this.Exec_as_rdr(string) : Integer.valueOf(this.Exec_as_int(string));
    }

    protected int Exec_as_int(String string) {
        try {
            Statement statement = this.New_stmt_exec(string);
            return statement.executeUpdate(string);
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "db.engine:exec failed", "url", this.conn_info.Db_api(), "sql", string);
        }
    }

    private DataRdr Exec_as_rdr(String string) {
        try {
            Statement statement = this.New_stmt_exec(string);
            statement.execute(string);
            ResultSet resultSet = statement.getResultSet();
            return this.New_rdr(resultSet, string);
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "db.engine:rdr failed", "url", this.conn_info.Db_api(), "sql", string);
        }
    }

    @Override
    public void Meta_tbl_create(Dbmeta_tbl_itm dbmeta_tbl_itm) {
        this.Exec_as_int(dbmeta_tbl_itm.To_sql_create(this.Sql_wtr()));
        this.Meta_mgr().Load_all();
    }

    @Override
    public void Meta_tbl_delete(String string) {
        this.Exec_as_int(this.Sql_wtr().Schema_wtr().Bld_drop_tbl(string));
        this.Meta_mgr().Load_all();
    }

    @Override
    public void Meta_idx_create(Gfo_usr_dlg gfo_usr_dlg, Dbmeta_idx_itm ... dbmeta_idx_itmArray) {
        for (Dbmeta_idx_itm dbmeta_idx_itm : dbmeta_idx_itmArray) {
            gfo_usr_dlg.Plog_many("", "", "creating db index (please wait); db=~{0} idx=~{1}", this.conn_info.Database(), dbmeta_idx_itm.Name());
            this.Exec_as_int(dbmeta_idx_itm.To_sql_create(this.Sql_wtr()));
        }
        this.Meta_mgr().Load_all();
    }

    @Override
    @Virtual
    public void Meta_idx_delete(String string) {
        if (this.Meta_idx_exists(string)) {
            this.Exec_as_int("DROP INDEX " + string);
        }
    }

    @Override
    public void Meta_fld_append(String string, Dbmeta_fld_itm dbmeta_fld_itm) {
        Gfo_usr_dlg_.Instance.Plog_many("", "", "adding column to table: db=~{0} tbl=~{1} fld=~{2}", this.conn_info.Database(), string, dbmeta_fld_itm.Name());
        try {
            this.Exec_as_int(this.Sql_wtr().Schema_wtr().Bld_alter_tbl_add(string, dbmeta_fld_itm));
            Gfo_usr_dlg_.Instance.Plog_many("", "", "column added to table: db=~{0} tbl=~{1} fld=~{2}", this.conn_info.Database(), string, dbmeta_fld_itm.Name());
        }
        catch (Exception exception) {
            Gfo_usr_dlg_.Instance.Warn_many("", "", "column not added to table: db=~{0} tbl=~{1} fld=~{2} err=~{3}", this.conn_info.Database(), string, dbmeta_fld_itm.Name(), Err_.Message_gplx_full(exception));
        }
        this.Meta_mgr().Load_all();
    }

    @Override
    @Virtual
    public boolean Meta_tbl_exists(String string) {
        return false;
    }

    @Override
    @Virtual
    public boolean Meta_fld_exists(String string, String string2) {
        return false;
    }

    @Override
    @Virtual
    public boolean Meta_idx_exists(String string) {
        return false;
    }

    @Override
    public abstract Dbmeta_tbl_mgr Meta_mgr();

    @Override
    @Virtual
    public void Env_db_attach(String string, Io_url io_url) {
    }

    @Override
    @Virtual
    public void Env_db_attach(String string, Db_conn db_conn) {
    }

    @Override
    @Virtual
    public void Env_db_detach(String string) {
    }

    @Override
    @Virtual
    public DataRdr New_rdr(ResultSet resultSet, String string) {
        return Db_data_rdr_.new_(resultSet, string);
    }

    private Db_rdr New_rdr(Db_stmt db_stmt, Object object, String string) {
        Db_rdr__basic db_rdr__basic = (Db_rdr__basic)this.New_rdr_clone();
        db_rdr__basic.Ctor(db_stmt, (ResultSet)object, string);
        return db_rdr__basic;
    }

    @Internal
    protected abstract Connection Conn_make();

    private void Batch_mgr__conn_bgn() {
        this.batch_mgr.Conn_bgn().Run(this);
    }

    private void Batch_mgr__conn_end() {
        this.batch_mgr.Conn_end().Run(this);
    }

    private void Conn_assert() {
        this.connection = this.Conn_make();
        this.Batch_mgr__conn_bgn();
    }

    @Override
    public void Conn_open() {
        this.connection = this.Conn_make();
    }

    @Override
    public void Conn_term() {
        if (this.connection == null) {
            return;
        }
        this.Batch_mgr__conn_end();
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "Conn_term failed", "url", this.conn_info.Raw());
        }
        this.connection = null;
    }

    @Override
    public Object Stmt_by_sql(String string) {
        if (this.connection == null) {
            this.Conn_assert();
        }
        try {
            return this.connection.prepareStatement(string);
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "New_stmt_prep failed", "sql", string);
        }
    }

    private Statement New_stmt_exec(String string) {
        if (this.connection == null) {
            this.Conn_assert();
        }
        try {
            return this.connection.createStatement();
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "New_stmt_exec failed", "sql", string);
        }
    }

    protected Connection Conn_make_by_url(String string, String string2, String string3) {
        try {
            return DriverManager.getConnection(string, string2, string3);
        }
        catch (SQLException sQLException) {
            throw Err_.new_exc(sQLException, "db", "connection open failed", "info", this.Conn_info().Raw());
        }
    }

    protected Connection Conn__new_by_url_and_props(String string, Keyval ... keyvalArray) {
        try {
            Properties properties = new Properties();
            for (Keyval keyval : keyvalArray) {
                properties.setProperty(keyval.Key(), keyval.Val_to_str_or_empty());
            }
            return DriverManager.getConnection(string, properties);
        }
        catch (SQLException sQLException) {
            throw Err_.new_exc(sQLException, "db", "connection open failed", "info", this.Conn_info().Raw());
        }
    }
}

