/*
 * Decompiled with CFR 0.152.
 */
package gplx.dbs.cfgs;

import gplx.Bry_;
import gplx.Byte_;
import gplx.DateAdp;
import gplx.DateAdp_;
import gplx.Err;
import gplx.Err_;
import gplx.Guid_adp;
import gplx.Guid_adp_;
import gplx.Hash_adp_bry;
import gplx.Int_;
import gplx.Long_;
import gplx.String_;
import gplx.Yn;
import gplx.dbs.Db_conn;
import gplx.dbs.Db_rdr;
import gplx.dbs.Db_stmt;
import gplx.dbs.Db_stmt_;
import gplx.dbs.Db_tbl;
import gplx.dbs.Db_tbl_owner;
import gplx.dbs.Dbmeta_fld_itm;
import gplx.dbs.Dbmeta_fld_list;
import gplx.dbs.Dbmeta_idx_itm;
import gplx.dbs.Dbmeta_tbl_itm;
import gplx.dbs.cfgs.Db_cfg_hash;

public class Db_cfg_tbl
implements Db_tbl {
    private final String tbl_name;
    private final Dbmeta_fld_list flds = new Dbmeta_fld_list();
    private final String fld_grp;
    private final String fld_key;
    private final String fld_val;
    private Db_stmt stmt_insert;
    private Db_stmt stmt_update;
    private Db_stmt stmt_select;
    private final Db_conn conn;

    public Db_conn Conn() {
        return this.conn;
    }

    public Db_cfg_tbl(Db_conn db_conn, String string) {
        this.conn = db_conn;
        this.tbl_name = string;
        this.fld_grp = this.flds.Add_str("cfg_grp", 255);
        this.fld_key = this.flds.Add_str("cfg_key", 255);
        this.fld_val = this.flds.Add_str("cfg_val", 1024);
        db_conn.Rls_reg(this);
    }

    @Override
    public void Rls() {
        this.stmt_insert = Db_stmt_.Rls(this.stmt_insert);
        this.stmt_update = Db_stmt_.Rls(this.stmt_update);
        this.stmt_select = Db_stmt_.Rls(this.stmt_select);
    }

    @Override
    public String Tbl_name() {
        return this.tbl_name;
    }

    @Override
    public void Create_tbl() {
        this.conn.Meta_tbl_create(Dbmeta_tbl_itm.New(this.tbl_name, this.flds, Dbmeta_idx_itm.new_unique_by_tbl(this.tbl_name, "main", this.fld_grp, this.fld_key, this.fld_val)));
    }

    public void Delete_val(String string, String string2) {
        this.conn.Stmt_delete(this.tbl_name, this.fld_grp, this.fld_key).Crt_str(this.fld_grp, string).Crt_str(this.fld_key, string2).Exec_delete();
    }

    public void Delete_grp(String string) {
        this.conn.Stmt_delete(this.tbl_name, this.fld_grp).Crt_str(this.fld_grp, string).Exec_delete();
    }

    public void Delete_all() {
        this.conn.Stmt_delete(this.tbl_name, Dbmeta_fld_itm.Str_ary_empty).Exec_delete();
    }

    public void Insert_yn(String string, String string2, boolean bl) {
        this.Insert_str(string, string2, bl ? "y" : "n");
    }

    public void Insert_byte(String string, String string2, byte by) {
        this.Insert_str(string, string2, Byte_.To_str(by));
    }

    public void Insert_int(String string, String string2, int n) {
        this.Insert_str(string, string2, Int_.To_str(n));
    }

    public void Insert_long(String string, String string2, long l) {
        this.Insert_str(string, string2, Long_.To_str(l));
    }

    public void Insert_date(String string, String string2, DateAdp dateAdp) {
        this.Insert_str(string, string2, dateAdp.XtoStr_fmt_yyyyMMdd_HHmmss());
    }

    public void Insert_guid(String string, String string2, Guid_adp guid_adp) {
        this.Insert_str(string, string2, guid_adp.To_str());
    }

    public void Insert_bry(String string, String string2, byte[] byArray) {
        this.Insert_str(string, string2, String_.new_u8(byArray));
    }

    public void Insert_str(String string, String string2, String string3) {
        if (this.stmt_insert == null) {
            this.stmt_insert = this.conn.Stmt_insert(this.tbl_name, this.flds);
        }
        try {
            this.stmt_insert.Clear().Val_str(this.fld_grp, string).Val_str(this.fld_key, string2).Val_str(this.fld_val, string3).Exec_insert();
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "db_cfg.insert failed", "grp", string, "key", string2, "val", string3, "db", this.conn.Conn_info().Db_api());
        }
    }

    public void Insert_str(String string, String string2) {
        if (this.stmt_insert == null) {
            this.stmt_insert = this.conn.Stmt_insert(this.tbl_name, this.flds);
        }
        try {
            this.stmt_insert.Clear().Val_str(this.fld_grp, "").Val_str(this.fld_key, string).Val_str(this.fld_val, string2).Exec_insert();
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "db_cfg.insert failed", "key", string, "val", string2, "db", this.conn.Conn_info().Db_api());
        }
    }

    public void Update_yn(String string, String string2, boolean bl) {
        this.Update_str(string, string2, bl ? "y" : "n");
    }

    public void Update_byte(String string, String string2, byte by) {
        this.Update_str(string, string2, Byte_.To_str(by));
    }

    public void Update_int(String string, String string2, int n) {
        this.Update_str(string, string2, Int_.To_str(n));
    }

    public void Update_long(String string, String string2, long l) {
        this.Update_str(string, string2, Long_.To_str(l));
    }

    public void Update_date(String string, String string2, DateAdp dateAdp) {
        this.Update_str(string, string2, dateAdp.XtoStr_fmt_yyyyMMdd_HHmmss());
    }

    public void Update_guid(String string, String string2, Guid_adp guid_adp) {
        this.Update_str(string, string2, guid_adp.To_str());
    }

    public void Update_bry(String string, String string2, byte[] byArray) {
        this.Update_str(string, string2, String_.new_u8(byArray));
    }

    public void Update_str(String string, String string2, String string3) {
        if (this.stmt_update == null) {
            this.stmt_update = this.conn.Stmt_update_exclude(this.tbl_name, this.flds, this.fld_grp, this.fld_key);
        }
        this.stmt_update.Clear().Val_str(this.fld_val, string3).Crt_str(this.fld_grp, string).Crt_str(this.fld_key, string2).Exec_update();
    }

    public void Update_str(String string, String string2) {
        if (this.stmt_update == null) {
            this.stmt_update = this.conn.Stmt_update_exclude(this.tbl_name, this.flds, this.fld_grp, this.fld_key);
        }
        this.stmt_update.Clear().Val_str(this.fld_val, string2).Crt_str(this.fld_grp, "").Crt_str(this.fld_key, string).Exec_update();
    }

    public void Upsert_yn(String string, String string2, boolean bl) {
        this.Upsert_str(string, string2, bl ? "y" : "n");
    }

    public void Upsert_int(String string, String string2, int n) {
        this.Upsert_str(string, string2, Int_.To_str(n));
    }

    public void Upsert_date(String string, String string2, DateAdp dateAdp) {
        this.Upsert_str(string, string2, dateAdp.XtoStr_fmt_yyyyMMdd_HHmmss());
    }

    public void Upsert_guid(String string, String string2, Guid_adp guid_adp) {
        this.Upsert_str(string, string2, guid_adp.To_str());
    }

    public void Upsert_bry(String string, String string2, byte[] byArray) {
        this.Upsert_str(string, string2, String_.new_u8(byArray));
    }

    public void Upsert_str(String string, String string2, String string3) {
        String string4 = this.Select_str_or(string, string2, null);
        if (string4 == null) {
            this.Insert_str(string, string2, string3);
        } else {
            this.Update_str(string, string2, string3);
        }
    }

    public void Upsert_int(String string, int n) {
        this.Upsert_str(string, Int_.To_str(n));
    }

    public void Upsert_str(String string, String string2) {
        String string3 = this.Select_str_or(string, null);
        if (string3 == null) {
            this.Insert_str(string, string2);
        } else {
            this.Update_str(string, string2);
        }
    }

    public boolean Select_yn(String string, String string2) {
        String string3 = this.Select_str(string, string2);
        return this.Parse_yn(string, string2, string3);
    }

    public byte Select_byte(String string, String string2) {
        String string3 = this.Select_str(string, string2);
        return this.Parse_byte(string, string2, string3);
    }

    public int Select_int(String string, String string2) {
        String string3 = this.Select_str(string, string2);
        return this.Parse_int(string, string2, string3);
    }

    public long Select_long(String string, String string2) {
        String string3 = this.Select_str(string, string2);
        return this.Parse_long(string, string2, string3);
    }

    public byte[] Select_bry(String string, String string2) {
        String string3 = this.Select_str(string, string2);
        return this.Parse_bry(string, string2, string3);
    }

    public DateAdp Select_date(String string, String string2) {
        String string3 = this.Select_str(string, string2);
        return this.Parse_date(string, string2, string3);
    }

    public Guid_adp Select_guid(String string, String string2) {
        String string3 = this.Select_str(string, string2);
        return this.Parse_guid(string, string2, string3);
    }

    public boolean Select_yn_or(String string, String string2, boolean bl) {
        String string3 = this.Select_str_or(string, string2, null);
        return string3 == null ? bl : this.Parse_yn(string, string2, string3);
    }

    public byte Select_byte_or(String string, String string2, byte by) {
        String string3 = this.Select_str_or(string, string2, null);
        return string3 == null ? by : this.Parse_byte(string, string2, string3);
    }

    public int Select_int_or(String string, String string2, int n) {
        String string3 = this.Select_str_or(string, string2, null);
        return string3 == null ? n : this.Parse_int(string, string2, string3);
    }

    public long Select_long_or(String string, String string2, long l) {
        String string3 = this.Select_str_or(string, string2, null);
        return string3 == null ? l : this.Parse_long(string, string2, string3);
    }

    public byte[] Select_bry_or(String string, String string2, byte[] byArray) {
        String string3 = this.Select_str_or(string, string2, null);
        return string3 == null ? byArray : this.Parse_bry(string, string2, string3);
    }

    public DateAdp Select_date_or(String string, String string2, DateAdp dateAdp) {
        String string3 = this.Select_str_or(string, string2, null);
        return string3 == null ? dateAdp : this.Parse_date(string, string2, string3);
    }

    public Guid_adp Select_guid_or(String string, String string2, Guid_adp guid_adp) {
        String string3 = this.Select_str_or(string, string2, null);
        return string3 == null ? guid_adp : this.Parse_guid(string, string2, string3);
    }

    public String Select_str(String string, String string2) {
        String string3 = this.Select_str_or(string, string2, null);
        if (string3 == null) {
            throw Err_.new_wo_type("cfg.missing", "grp", string, "key", string2);
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String Select_str_or(String string, String string2, String string3) {
        if (this.stmt_select == null) {
            this.stmt_select = this.conn.Stmt_select(this.tbl_name, String_.Ary(this.fld_val), this.fld_grp, this.fld_key);
        }
        Db_rdr db_rdr = this.stmt_select.Clear().Crt_str(this.fld_grp, string).Crt_str(this.fld_key, string2).Exec_select__rls_manual();
        try {
            String string4 = db_rdr.Move_next() ? db_rdr.Read_str(this.fld_val) : string3;
            return string4;
        }
        finally {
            db_rdr.Rls();
        }
    }

    public int Select_int_or(String string, int n) {
        String string2 = this.Select_str_or(string, null);
        return string2 == null ? n : this.Parse_int("", string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String Select_str_or(String string, String string2) {
        if (this.stmt_select == null) {
            this.stmt_select = this.conn.Stmt_select(this.tbl_name, String_.Ary(this.fld_val), this.fld_grp, this.fld_key);
        }
        Db_rdr db_rdr = this.stmt_select.Clear().Crt_str(this.fld_grp, "").Crt_str(this.fld_key, string).Exec_select__rls_manual();
        try {
            String string3 = db_rdr.Move_next() ? db_rdr.Read_str(this.fld_val) : string2;
            return string3;
        }
        finally {
            db_rdr.Rls();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Db_cfg_hash Select_as_hash(String string) {
        Db_cfg_hash db_cfg_hash = new Db_cfg_hash(string);
        Db_rdr db_rdr = this.conn.Stmt_select(this.tbl_name, this.flds, this.fld_grp).Crt_str(this.fld_grp, string).Exec_select__rls_auto();
        try {
            while (db_rdr.Move_next()) {
                db_cfg_hash.Add(db_rdr.Read_str(this.fld_key), db_rdr.Read_str(this.fld_val));
            }
        }
        finally {
            db_rdr.Rls();
        }
        return db_cfg_hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Select_as_hash_bry(Hash_adp_bry hash_adp_bry, String string) {
        hash_adp_bry.Clear();
        Db_rdr db_rdr = this.conn.Stmt_select(this.tbl_name, this.flds, this.fld_grp).Crt_str(this.fld_grp, string).Exec_select__rls_auto();
        try {
            while (db_rdr.Move_next()) {
                hash_adp_bry.Add(db_rdr.Read_bry_by_str(this.fld_key), db_rdr.Read_bry_by_str(this.fld_val));
            }
        }
        finally {
            db_rdr.Rls();
        }
    }

    public boolean Assert_yn(String string, String string2, boolean bl) {
        String string3 = this.Select_str_or(string, string2, null);
        if (string3 == null) {
            this.Insert_yn(string, string2, bl);
            return bl;
        }
        return this.Parse_yn(string, string2, string3);
    }

    public byte Assert_byte(String string, String string2, byte by) {
        String string3 = this.Select_str_or(string, string2, null);
        if (string3 == null) {
            this.Insert_byte(string, string2, by);
            return by;
        }
        return this.Parse_byte(string, string2, string3);
    }

    public int Assert_int(String string, String string2, int n) {
        String string3 = this.Select_str_or(string, string2, null);
        if (string3 == null) {
            this.Insert_int(string, string2, n);
            return n;
        }
        return this.Parse_int(string, string2, string3);
    }

    public long Assert_long(String string, String string2, long l) {
        String string3 = this.Select_str_or(string, string2, null);
        if (string3 == null) {
            this.Insert_long(string, string2, l);
            return l;
        }
        return this.Parse_long(string, string2, string3);
    }

    public byte[] Assert_bry(String string, String string2, byte[] byArray) {
        String string3 = this.Select_str_or(string, string2, null);
        if (string3 == null) {
            this.Insert_bry(string, string2, byArray);
            return byArray;
        }
        return this.Parse_bry(string, string2, string3);
    }

    public DateAdp Assert_date(String string, String string2, DateAdp dateAdp) {
        String string3 = this.Select_str_or(string, string2, null);
        if (string3 == null) {
            this.Insert_date(string, string2, dateAdp);
            return dateAdp;
        }
        return this.Parse_date(string, string2, string3);
    }

    public Guid_adp Assert_guid(String string, String string2, Guid_adp guid_adp) {
        String string3 = this.Select_str_or(string, string2, null);
        if (string3 == null) {
            this.Insert_guid(string, string2, guid_adp);
            return guid_adp;
        }
        return this.Parse_guid(string, string2, string3);
    }

    public String Assert_str(String string, String string2, String string3) {
        String string4 = this.Select_str_or(string, string2, null);
        if (string4 == null) {
            this.Insert_str(string, string2, string3);
            return string3;
        }
        return string4;
    }

    private boolean Parse_yn(String string, String string2, String string3) {
        try {
            return Yn.parse(string3);
        }
        catch (Exception exception) {
            throw this.err_parse(exception, string, string2, string3, "bool");
        }
    }

    private byte Parse_byte(String string, String string2, String string3) {
        try {
            return Byte_.Parse(string3);
        }
        catch (Exception exception) {
            throw this.err_parse(exception, string, string2, string3, "byte");
        }
    }

    private int Parse_int(String string, String string2, String string3) {
        try {
            return Int_.Parse(string3);
        }
        catch (Exception exception) {
            throw this.err_parse(exception, string, string2, string3, "int");
        }
    }

    private long Parse_long(String string, String string2, String string3) {
        try {
            return Long_.parse(string3);
        }
        catch (Exception exception) {
            throw this.err_parse(exception, string, string2, string3, "long");
        }
    }

    private byte[] Parse_bry(String string, String string2, String string3) {
        try {
            return Bry_.new_u8(string3);
        }
        catch (Exception exception) {
            throw this.err_parse(exception, string, string2, string3, "byte[]");
        }
    }

    private DateAdp Parse_date(String string, String string2, String string3) {
        try {
            return DateAdp_.parse_gplx(string3);
        }
        catch (Exception exception) {
            throw this.err_parse(exception, string, string2, string3, "Date");
        }
    }

    private Guid_adp Parse_guid(String string, String string2, String string3) {
        try {
            return Guid_adp_.Parse(string3);
        }
        catch (Exception exception) {
            throw this.err_parse(exception, string, string2, string3, "Guid");
        }
    }

    private Err err_parse(Exception exception, String string, String string2, String string3, String string4) {
        return Err_.new_exc(exception, "db", "cfg.val is not parseable", "grp", string, "key", string2, "val", string3, "type", string4);
    }

    public static Db_cfg_tbl Get_by_key(Db_tbl_owner db_tbl_owner, String string) {
        return (Db_cfg_tbl)db_tbl_owner.Tbls__get_by_key(string);
    }
}

