/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.threads.poolables;

import gplx.Array_;
import gplx.Err_;
import gplx.Internal;
import gplx.core.memorys.Gfo_memory_itm;
import gplx.core.memorys.Gfo_memory_mgr;
import gplx.core.threads.poolables.Gfo_poolable_itm;

public class Gfo_poolable_mgr
implements Gfo_memory_itm {
    private final Object thread_lock = new Object();
    private final Gfo_poolable_itm prototype;
    private final Object[] make_args;
    private Gfo_poolable_itm[] pool;
    private int pool_nxt;
    private int pool_len;
    private int[] free_ary;
    private int free_len;

    public Gfo_poolable_mgr(Gfo_poolable_itm gfo_poolable_itm, Object[] objectArray, int n, int n2) {
        this.prototype = gfo_poolable_itm;
        this.make_args = objectArray;
        this.pool_len = n;
        this.Clear_fast();
    }

    @Override
    public void Rls_mem() {
        this.Clear_safe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Clear_safe() {
        Object object = this.thread_lock;
        synchronized (object) {
            this.Clear_fast();
        }
    }

    public void Clear_fast() {
        this.pool = new Gfo_poolable_itm[this.pool_len];
        for (int i = 0; i < this.pool_len; ++i) {
            this.pool[i] = this.prototype.Pool__make(this, i, this.make_args);
        }
        this.free_ary = new int[this.pool_len];
        this.free_len = 0;
        this.pool_nxt = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Gfo_poolable_itm Get_safe() {
        Object object = this.thread_lock;
        synchronized (object) {
            return this.Get_fast();
        }
    }

    public Gfo_poolable_itm Get_fast() {
        Gfo_poolable_itm gfo_poolable_itm = null;
        int n = -1;
        if (this.free_len > 0) {
            n = this.free_ary[--this.free_len];
            gfo_poolable_itm = this.pool[n];
        } else {
            if (this.pool_nxt == this.pool_len) {
                this.Expand_pool();
            }
            if ((gfo_poolable_itm = this.pool[n = this.pool_nxt++]) == null) {
                this.pool[n] = gfo_poolable_itm = this.prototype.Pool__make(this, n, this.make_args);
            }
        }
        return gfo_poolable_itm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Rls_safe(int n) {
        Object object = this.thread_lock;
        synchronized (object) {
            this.Rls_fast(n);
        }
    }

    public void Rls_fast(int n) {
        if (n == -1) {
            throw Err_.new_wo_type("rls called on poolable that was not created by pool_mgr", new Object[0]);
        }
        int n2 = this.pool_nxt - 1;
        if (n == n2) {
            if (this.free_len == 0) {
                this.pool_nxt = n2;
            } else {
                for (int i = 0; i < this.free_len; ++i) {
                    this.free_ary[i] = 0;
                }
                this.free_len = 0;
            }
        } else {
            this.free_ary[this.free_len] = n;
            ++this.free_len;
        }
    }

    private void Expand_pool() {
        int n = this.pool_len == 0 ? 2 : this.pool_len * 2;
        Gfo_poolable_itm[] gfo_poolable_itmArray = new Gfo_poolable_itm[n];
        Array_.Copy_to(this.pool, 0, gfo_poolable_itmArray, 0, this.pool_len);
        this.pool = gfo_poolable_itmArray;
        this.pool_len = n;
        int[] nArray = new int[this.pool_len];
        Array_.Copy_to(this.free_ary, 0, nArray, 0, this.free_len);
        this.free_ary = nArray;
    }

    @Internal
    protected int[] Free_ary() {
        return this.free_ary;
    }

    @Internal
    protected int Free_len() {
        return this.free_len;
    }

    @Internal
    protected int Pool_len() {
        return this.pool_len;
    }

    @Internal
    protected int Pool_nxt() {
        return this.pool_nxt;
    }

    public static Gfo_poolable_mgr New_rlsable(Gfo_poolable_itm gfo_poolable_itm, Object[] objectArray, int n, int n2) {
        Gfo_poolable_mgr gfo_poolable_mgr = new Gfo_poolable_mgr(gfo_poolable_itm, objectArray, n, n2);
        Gfo_memory_mgr.Instance.Reg_safe(gfo_poolable_mgr);
        return gfo_poolable_mgr;
    }
}

