/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.texts;

import gplx.Array_;
import gplx.Char_;
import gplx.Err_;
import gplx.String_;

public class CharStream {
    char[] ary;
    int len;
    int pos = -1;
    static final int BgnPos = -1;

    public char[] Ary() {
        return this.ary;
    }

    public int Len() {
        return this.len;
    }

    public int Pos() {
        return this.pos;
    }

    public boolean AtBgn() {
        return this.pos <= -1;
    }

    public boolean AtEnd() {
        return this.pos >= this.len;
    }

    public boolean AtMid() {
        return this.pos > -1 && this.pos < this.len;
    }

    public char Cur() {
        try {
            return this.ary[this.pos];
        }
        catch (Exception exception) {
            Err_.Noop(exception);
            throw Err_.new_missing_idx(this.pos, this.Len());
        }
    }

    public void MoveNext() {
        ++this.pos;
    }

    public void MoveNextBy(int n) {
        this.pos += n;
    }

    public void MoveBack() {
        --this.pos;
    }

    public void MoveBackBy(int n) {
        this.pos -= n;
    }

    public void Move_to(int n) {
        this.pos = n;
    }

    public boolean Match(String string) {
        int n = String_.Len(string);
        for (int i = 0; i < n; ++i) {
            int n2 = this.pos + i;
            if (n2 < this.len && this.ary[n2] == String_.CharAt(string, i)) continue;
            return false;
        }
        return true;
    }

    public boolean MatchAndMove(String string) {
        int n = String_.Len(string);
        boolean bl = this.Match(string);
        if (bl) {
            this.MoveNextBy(n);
        }
        return bl;
    }

    public boolean MatchAndMove(char c) {
        boolean bl;
        boolean bl2 = bl = this.ary[this.pos] == c;
        if (bl) {
            ++this.pos;
        }
        return bl;
    }

    public String To_str() {
        return Char_.To_str(this.ary, 0, this.len);
    }

    public String XtoStrAtCur(int n) {
        n = this.pos + n > this.len ? this.len - this.pos : n;
        return Char_.To_str(this.ary, this.pos, n);
    }

    public String To_str_by_pos(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.len - 1) {
            n2 = this.len - 1;
        }
        return Char_.To_str(this.ary, n, n2 - n + 1);
    }

    public static CharStream pos0_(String string) {
        CharStream charStream = new CharStream();
        charStream.ary = String_.XtoCharAry(string);
        charStream.len = Array_.Len(charStream.ary);
        charStream.MoveNext();
        return charStream;
    }

    CharStream() {
    }
}

