/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.stores;

import gplx.DateAdp;
import gplx.DateAdp_;
import gplx.Decimal_adp;
import gplx.Decimal_adp_;
import gplx.Err_;
import gplx.Internal;
import gplx.core.ios.streams.Io_stream_rdr;
import gplx.core.ios.streams.Io_stream_rdr_;
import gplx.core.stores.DataRdr;
import gplx.core.stores.DataRdr_base;
import gplx.core.stores.SrlMgr;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.GregorianCalendar;

public class Db_data_rdr
extends DataRdr_base
implements DataRdr {
    private String commandText;
    private ResultSet rdr;
    private int fieldCount;

    @Override
    public String NameOfNode() {
        return this.commandText;
    }

    @Override
    public String To_str() {
        return this.commandText;
    }

    @Override
    public int FieldCount() {
        return this.fieldCount;
    }

    @Override
    public String KeyAt(int n) {
        String string = null;
        try {
            string = this.rdr.getMetaData().getColumnLabel(n + 1);
        }
        catch (SQLException sQLException) {
            throw Err_.new_exc(sQLException, "db", "get columnName failed", "i", n, "commandText", this.commandText);
        }
        return string;
    }

    @Override
    public Object ReadAt(int n) {
        Object object;
        try {
            object = this.rdr.getObject(n + 1);
        }
        catch (Exception exception) {
            throw Err_.new_wo_type("could not read val from dataReader; idx not found or rdr not open", "idx", n, "sql", this.commandText);
        }
        return object;
    }

    @Override
    public Object Read(String string) {
        Object object;
        try {
            object = this.rdr.getObject(string);
        }
        catch (Exception exception) {
            throw Err_.new_wo_type("could not read val from dataReader; key not found or rdr may not be open", "key", string, "sql", this.commandText);
        }
        return object;
    }

    @Override
    public DateAdp ReadDate(String string) {
        Object object = this.Read(string);
        Timestamp timestamp = (Timestamp)object;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(timestamp);
        return DateAdp_.dateTime_(gregorianCalendar);
    }

    @Override
    public Decimal_adp ReadDecimal(String string) {
        return Decimal_adp_.db_(this.Read(string));
    }

    @Override
    public Io_stream_rdr ReadRdr(String string) {
        try {
            InputStream inputStream = this.rdr.getBinaryStream(string);
            return Io_stream_rdr_.New__raw(inputStream);
        }
        catch (SQLException sQLException) {
            return Io_stream_rdr_.Noop;
        }
    }

    @Override
    public boolean MoveNextPeer() {
        try {
            return this.rdr.next();
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "could not move next; check column casting error in SQL", "sql", this.commandText);
        }
    }

    @Override
    public DataRdr Subs() {
        throw Err_.new_unimplemented();
    }

    @Override
    public DataRdr Subs_byName(String string) {
        throw Err_.new_unimplemented();
    }

    @Override
    public DataRdr Subs_byName_moveFirst(String string) {
        throw Err_.new_unimplemented();
    }

    @Override
    public void Rls() {
        try {
            this.rdr.close();
        }
        catch (SQLException sQLException) {
            throw Err_.new_exc(sQLException, "db", "reader dispose failed", "commandText", this.commandText);
        }
        this.EnvVars().Clear();
    }

    @Internal
    protected Db_data_rdr ctor_db_data_rdr(ResultSet resultSet, String string) {
        this.rdr = resultSet;
        this.commandText = string;
        this.Parse_set(false);
        try {
            this.fieldCount = this.rdr.getMetaData().getColumnCount();
        }
        catch (SQLException sQLException) {
            Err_.new_exc(sQLException, "xo", "get columnCount failed", "commandText", string);
        }
        return this;
    }

    @Override
    public SrlMgr SrlMgr_new(Object object) {
        return new Db_data_rdr();
    }
}

