/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.stores;

import gplx.Err_;
import gplx.Gfo_invk;
import gplx.Gfo_invk_;
import gplx.Hash_adp;
import gplx.Hash_adp_;
import gplx.Keyval;
import gplx.Keyval_;
import gplx.List_adp;
import gplx.List_adp_;
import gplx.core.criterias.Criteria;
import gplx.core.criterias.Criteria_;
import gplx.core.criterias.Criteria_fld;
import gplx.core.gfo_ndes.GfoNde;
import gplx.core.gfo_ndes.GfoNdeList;
import gplx.core.gfo_ndes.GfoNde_;
import gplx.core.stores.DataRdr;
import gplx.core.stores.DataRdr_base;
import gplx.core.stores.DbMaprArg;
import gplx.core.stores.DbMaprItm;
import gplx.core.stores.DbMaprMgr;
import gplx.core.stores.SrlMgr;
import gplx.core.stores.SrlObj;
import gplx.dbs.Db_conn;
import gplx.dbs.Db_conn_info;
import gplx.dbs.Db_conn_pool;
import gplx.dbs.Db_crt_;
import gplx.dbs.Db_qry_;

public class DbMaprRdr
extends DataRdr_base
implements SrlMgr {
    Hash_adp tables = Hash_adp_.New();
    Db_conn conn;
    Criteria rootCrt;
    DbMaprMgr mgr;
    List_adp rowStack = List_adp_.New();

    @Override
    public String NameOfNode() {
        return "DbMaprRdr";
    }

    @Override
    public Object StoreRoot(SrlObj srlObj, String string) {
        this.mgr = (DbMaprMgr)this.EnvVars().Get_by_or_fail("DbMapr.mgr");
        DbMaprItm dbMaprItm = this.mgr.Root();
        GfoNde gfoNde = this.GetTbl(dbMaprItm, this.rootCrt);
        int n = gfoNde.Subs().Count();
        if (n == 0) {
            return null;
        }
        if (n > 1) {
            throw Err_.new_wo_type("criteria returned > 1 row", "criteria", this.rootCrt.To_str(), "subsCount", n);
        }
        SrlObj srlObj2 = srlObj.SrlObj_New(null);
        this.mgr.EnvStack_add(dbMaprItm, srlObj2);
        this.RowStack_add(gfoNde, 0);
        srlObj2.SrlObj_Srl(this);
        this.mgr.Clear();
        this.rowStack.Clear();
        return srlObj2;
    }

    @Override
    public void SrlList(String string, List_adp list_adp, SrlObj srlObj, String string2) {
        DbMaprItm dbMaprItm = (DbMaprItm)this.mgr.MaprStack().Get_at_last();
        DbMaprItm dbMaprItm2 = dbMaprItm.Subs_get(string);
        list_adp.Clear();
        Criteria criteria = this.MakeCrt(this.mgr, dbMaprItm2);
        GfoNde gfoNde = this.GetTbl(dbMaprItm2, criteria);
        int n = gfoNde.Subs().Count();
        for (int i = 0; i < n; ++i) {
            SrlObj srlObj2 = srlObj.SrlObj_New(null);
            GfoNde gfoNde2 = gfoNde.Subs().FetchAt_asGfoNde(i);
            this.mgr.EnvStack_add(dbMaprItm2, srlObj2);
            this.rowStack.Add(gfoNde2);
            srlObj2.SrlObj_Srl(this);
            list_adp.Add(srlObj2);
            this.mgr.EnvStack_del(dbMaprItm2, srlObj2);
            List_adp_.Del_at_last(this.rowStack);
        }
    }

    Criteria MakeCrt(DbMaprMgr dbMaprMgr, DbMaprItm dbMaprItm) {
        Criteria_fld criteria_fld = null;
        Criteria_fld criteria_fld2 = null;
        List_adp list_adp = this.GetIdxFlds(dbMaprMgr, dbMaprItm);
        for (Object t : list_adp) {
            Keyval keyval = (Keyval)t;
            criteria_fld2 = Db_crt_.New_eq(keyval.Key(), keyval.Val());
            criteria_fld = criteria_fld == null ? criteria_fld2 : Criteria_.And(criteria_fld, criteria_fld2);
        }
        return criteria_fld;
    }

    List_adp GetIdxFlds(DbMaprMgr dbMaprMgr, DbMaprItm dbMaprItm) {
        Object object;
        List_adp list_adp = List_adp_.New();
        int n = dbMaprMgr.MaprStack().Count() - 0;
        for (int i = 0; i < n; ++i) {
            DbMaprItm dbMaprItm2 = (DbMaprItm)dbMaprMgr.MaprStack().Get_at(i);
            object = (SrlObj)dbMaprMgr.OwnerStack().Get_at(i);
            for (Object t : dbMaprItm2.ContextFlds()) {
                DbMaprArg dbMaprArg = (DbMaprArg)t;
                Object object2 = Gfo_invk_.Invk_by_key((Gfo_invk)object, dbMaprArg.ObjProp());
                list_adp.Add(Keyval_.new_(dbMaprArg.DbFld(), object2));
            }
        }
        for (DbMaprItm dbMaprItm2 : dbMaprItm.ConstantFlds()) {
            object = (Keyval)((Object)dbMaprItm2);
            list_adp.Add(object);
        }
        return list_adp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GfoNde GetTbl(DbMaprItm dbMaprItm, Criteria criteria) {
        Object object;
        String string = dbMaprItm.TableName();
        GfoNde gfoNde = GfoNde_.as_(this.tables.Get_by(string));
        if (gfoNde == null) {
            object = null;
            try {
                object = this.conn.Exec_qry_as_old_rdr(Db_qry_.select_().From_(dbMaprItm.TableName()).Where_(this.rootCrt));
                gfoNde = GfoNde_.rdr_((DataRdr)object);
            }
            finally {
                object.Rls();
            }
            this.tables.Add(string, gfoNde);
        }
        object = GfoNde_.tbl_(dbMaprItm.TableName(), gfoNde.Flds(), new GfoNde[0]);
        for (int i = 0; i < gfoNde.Subs().Count(); ++i) {
            GfoNde gfoNde2 = gfoNde.Subs().FetchAt_asGfoNde(i);
            if (!criteria.Matches(gfoNde2)) continue;
            ((GfoNde)object).Subs().Add(gfoNde2);
        }
        return object;
    }

    void RowStack_add(GfoNde gfoNde, int n) {
        GfoNdeList gfoNdeList = gfoNde.Subs();
        if (n >= gfoNdeList.Count()) {
            throw Err_.new_missing_idx(n, gfoNdeList.Count());
        }
        this.rowStack.Add(gfoNde.Subs().FetchAt_asGfoNde(n));
    }

    @Override
    public Object Read(String string) {
        DbMaprItm dbMaprItm = (DbMaprItm)this.mgr.MaprStack().Get_at_last();
        GfoNde gfoNde = (GfoNde)this.rowStack.Get_at_last();
        DbMaprArg dbMaprArg = dbMaprItm.Flds_get(string);
        Object object = null;
        try {
            object = gfoNde.Read(dbMaprArg.DbFld());
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "db", "failed to read dbVal from row", "key", string, "fld", dbMaprArg.DbFld());
        }
        return object;
    }

    @Override
    public DataRdr Subs_byName_moveFirst(String string) {
        throw Err_.new_unimplemented();
    }

    @Override
    public DataRdr Subs() {
        throw Err_.new_unimplemented();
    }

    @Override
    public int FieldCount() {
        throw Err_.new_unimplemented();
    }

    @Override
    public String KeyAt(int n) {
        throw Err_.new_unimplemented();
    }

    @Override
    public Object ReadAt(int n) {
        throw Err_.new_unimplemented();
    }

    @Override
    public Keyval KeyValAt(int n) {
        throw Err_.new_unimplemented();
    }

    @Override
    public SrlMgr SrlMgr_new(Object object) {
        return new DbMaprRdr();
    }

    public static DbMaprRdr new_(Db_conn_info db_conn_info, Criteria criteria) {
        DbMaprRdr dbMaprRdr = new DbMaprRdr();
        dbMaprRdr.conn = Db_conn_pool.Instance.Get_or_new(db_conn_info);
        dbMaprRdr.rootCrt = criteria;
        return dbMaprRdr;
    }

    DbMaprRdr() {
    }
}

