/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.security;

import gplx.Array_;
import gplx.Bry_;
import gplx.String_;
import gplx.core.consoles.Console_adp;
import gplx.core.consoles.Console_adp_;
import gplx.core.ios.streams.IoStream;
import gplx.core.ios.streams.IoStream_;
import gplx.core.progs.Gfo_prog_ui;
import gplx.core.security.HashDlgWtr;
import gplx.core.security.HashDlgWtr_;
import gplx.core.security.Hash_algo;
import gplx.core.security.Hash_algo_utl_;
import gplx.core.security.Tiger192;

public class Hash_algo__tth_192
implements Hash_algo {
    public static final String KEY = "tth192";
    int blockSize = 1024;
    Tiger192 algo = new Tiger192();
    byte[][] hashMain;
    int hashMainCount = 0;
    byte[] blockA;
    byte[] blockB;
    byte[] branchRv;
    byte[] leaf0;
    byte[] leaf1;

    @Override
    public String Key() {
        return KEY;
    }

    public int BlockSize() {
        return this.blockSize;
    }

    public void BlockSize_set(int n) {
        this.blockSize = n;
    }

    @Override
    public String Hash_bry_as_str(byte[] byArray) {
        return String_.new_a7(this.Hash_bry_as_bry(byArray));
    }

    @Override
    public byte[] Hash_bry_as_bry(byte[] byArray) {
        return Bry_.new_a7(this.Hash_stream_as_str(Console_adp_.Noop, IoStream_.ary_(byArray)));
    }

    @Override
    public byte[] Hash_stream_as_bry(Gfo_prog_ui gfo_prog_ui, IoStream ioStream) {
        return Bry_.new_a7(this.Hash_stream_as_str(Console_adp_.Noop, ioStream));
    }

    @Override
    public String Hash_stream_as_str(Console_adp console_adp, IoStream ioStream) {
        int n = (int)(ioStream.Len() / (long)this.blockSize);
        HashDlgWtr hashDlgWtr = HashDlgWtr_.Current;
        hashDlgWtr.Bgn(console_adp, ioStream.Url(), this.CalcWorkUnits(ioStream.Len()));
        if (ioStream.Len() % (long)this.blockSize > 0L) {
            ++n;
        } else if (ioStream.Len() == 0L) {
            n = 1;
        }
        this.hashMain = new byte[n / 2 + 1][];
        this.hashMainCount = 0;
        this.HashAllBytes(hashDlgWtr, ioStream, n);
        byte[] byArray = this.HashAllHashes(hashDlgWtr);
        return Hash_algo_utl_.To_base_32_str(byArray);
    }

    byte[] CalcHash_next(IoStream ioStream) {
        if (this.blockA == null || this.blockA.length != this.blockSize) {
            this.blockA = new byte[this.blockSize];
        }
        if (this.blockB == null || this.blockB.length != this.blockSize) {
            this.blockB = new byte[this.blockSize];
        }
        int n = ioStream.Read(this.blockA, 0, this.blockSize);
        n = ioStream.Read(this.blockB, 0, this.blockSize);
        if (n < this.blockSize) {
            this.blockB = this.ShrinkArray(this.blockB, n);
        }
        return this.CalcHash_branch(this.CalcHash_leaf(this.blockA, 0), this.CalcHash_leaf(this.blockB, 1));
    }

    void HashAllBytes(HashDlgWtr hashDlgWtr, IoStream ioStream, int n) {
        int n2 = n / 2;
        for (int i = 0; i < n2; ++i) {
            if (hashDlgWtr.Canceled()) {
                hashDlgWtr.Fail(ioStream);
            }
            this.hashMain[this.hashMainCount++] = this.CalcHash_next(ioStream);
            hashDlgWtr.Do(2);
        }
        if (n % 2 == 1) {
            byte[] byArray = new byte[this.blockSize];
            int n3 = ioStream.Read(byArray, 0, this.blockSize);
            if (n3 < this.blockSize) {
                byArray = this.ShrinkArray(byArray, n3);
            }
            this.hashMain[this.hashMainCount++] = this.CalcHash_leaf(byArray, 0);
            hashDlgWtr.Do(1);
        }
        ioStream.Rls();
    }

    byte[] HashAllHashes(HashDlgWtr hashDlgWtr) {
        int n = 0;
        int n2 = this.hashMainCount - 1;
        int n3 = 0;
        while (n < n2) {
            while (n < n2) {
                byte[] byArray = this.hashMain[n++];
                byte[] byArray2 = this.hashMain[n++];
                this.hashMain[n3++] = this.CalcHash_branch(byArray, byArray2);
                hashDlgWtr.Do(2);
            }
            if (n == n2) {
                this.hashMain[n3++] = this.hashMain[n++];
            }
            n2 = n3 - 1;
            n = 0;
            n3 = 0;
        }
        hashDlgWtr.End();
        return this.hashMain[n2];
    }

    byte[] CalcHash_branch(byte[] byArray, byte[] byArray2) {
        if (this.branchRv == null || this.branchRv.length != byArray.length + byArray2.length + 1) {
            this.branchRv = new byte[byArray.length + byArray2.length + 1];
        }
        this.branchRv[0] = 1;
        Array_.Copy_to(byArray, this.branchRv, 1);
        Array_.Copy_to(byArray2, this.branchRv, byArray.length + 1);
        return this.CalcHash(this.branchRv);
    }

    byte[] CalcHash_leaf(byte[] byArray, int n) {
        byte[] byArray2 = null;
        if (n == 0) {
            if (this.leaf0 == null || this.leaf0.length != byArray.length + 1) {
                this.leaf0 = new byte[byArray.length + 1];
            }
            byArray2 = this.leaf0;
        } else {
            if (this.leaf1 == null || this.leaf1.length != byArray.length + 1) {
                this.leaf1 = new byte[byArray.length + 1];
            }
            byArray2 = this.leaf1;
        }
        byArray2[0] = 0;
        Array_.Copy_to(byArray, byArray2, 1);
        return this.CalcHash(byArray2);
    }

    byte[] CalcHash(byte[] byArray) {
        this.algo.Initialize();
        return this.algo.ComputeHash(byArray);
    }

    byte[] ShrinkArray(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray2[i] = byArray[i];
        }
        return byArray2;
    }

    public int CalcWorkUnits(long l) {
        int n;
        int n2 = n = (int)(l / (long)this.blockSize);
        if (n == 0) {
            n2 = 1;
        } else if (l % (long)this.blockSize != 0L) {
            ++n2;
        }
        int n3 = n2 <= 1 ? 0 : n2 - 1;
        return n2 + n3;
    }
}

