/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.primitives;

import gplx.Err_;

public class Int_ary {
    private int[] ary;
    private int len = 0;
    private int max;
    public static final int Not_found = -1;

    public Int_ary(int n) {
        this.max = n;
        this.ary = new int[n];
    }

    public int[] Ary() {
        return this.ary;
    }

    public void Clear() {
        for (int i = 0; i < this.len; ++i) {
            this.ary[i] = 0;
        }
        this.len = 0;
    }

    public int Len() {
        return this.len;
    }

    public int Get_at_or_fail(int n) {
        if (n > -1 && n < this.len) {
            return this.ary[n];
        }
        throw Err_.new_("core.int_ary", "index is invalid", "i", n, "len", this.len);
    }

    public void Add(int n) {
        if (this.len == this.max) {
            int n2 = this.max * 2;
            int[] nArray = new int[n2];
            for (int i = 0; i < this.len; ++i) {
                nArray[i] = this.ary[i];
            }
            this.ary = nArray;
            this.max = n2;
        }
        this.ary[this.len] = n;
        ++this.len;
    }

    public int Pop_or_fail() {
        if (this.len == 0) {
            throw Err_.new_("core.int_ary", "stack is empty", new Object[0]);
        }
        return this.Pop_or(-1);
    }

    public int Pop_or(int n) {
        if (this.len == 0) {
            return n;
        }
        int n2 = this.ary[this.len - 1];
        --this.len;
        return n2;
    }

    public int Idx_of(int n) {
        for (int i = this.len - 1; i > -1; --i) {
            if (this.ary[i] != n) continue;
            return i;
        }
        return -1;
    }

    public boolean Del_from_end(int n) {
        int n2 = this.Idx_of(n);
        if (n2 == -1) {
            return false;
        }
        int n3 = this.len - 1;
        for (int i = n2; i < n3; ++i) {
            this.ary[i] = this.ary[i + 1];
        }
        this.ary[n3] = 0;
        --this.len;
        return true;
    }
}

