/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.net.downloads;

import gplx.Err_;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.Long_;
import gplx.String_;
import gplx.core.net.downloads.Http_download_wkr;
import gplx.core.progs.Gfo_prog_ui;

public abstract class Http_download_wkr__base
implements Http_download_wkr {
    private long expd_size;
    private Io_url tmp_url;
    private Io_url checkpoint_url;
    private long downloaded;
    private long checkpoint_interval = 0x100000L;
    private long checkpoint_nxt = 0L;
    private Io_url trg_url;
    private String fail_msg;

    protected Io_url Checkpoint_url() {
        return this.checkpoint_url;
    }

    protected Io_url Trg_url() {
        return this.trg_url;
    }

    @Override
    public Io_url Tmp_url() {
        return this.tmp_url;
    }

    @Override
    public String Fail_msg() {
        return this.fail_msg;
    }

    @Override
    public abstract Http_download_wkr Make_new();

    @Override
    public byte Exec(Gfo_prog_ui gfo_prog_ui, String string, Io_url io_url, long l) {
        this.trg_url = io_url;
        this.downloaded = this.Checkpoint__load_by_trg_fil(io_url);
        this.checkpoint_nxt = this.downloaded + this.checkpoint_interval;
        this.expd_size = l;
        this.fail_msg = null;
        byte by = 8;
        try {
            by = this.Exec_hook(gfo_prog_ui, string, this.tmp_url, this.downloaded);
        }
        catch (Exception exception) {
            by = 8;
            this.fail_msg = Err_.Message_lang(exception);
        }
        switch (by) {
            case 4: {
                long l2;
                if (l != -1L && this.expd_size != (l2 = Io_mgr.Instance.QueryFil(this.tmp_url).Size())) {
                    this.fail_msg = String_.Format("bad size: bad={0} good={1}", l2, this.expd_size);
                    return 8;
                }
                Io_mgr.Instance.MoveFil_args(this.tmp_url, io_url, true).Exec();
                this.Exec_cleanup();
                break;
            }
        }
        return by;
    }

    protected abstract byte Exec_hook(Gfo_prog_ui var1, String var2, Io_url var3, long var4);

    @Override
    public void Exec_cleanup() {
        if (this.tmp_url != null) {
            Io_mgr.Instance.DeleteFil(this.tmp_url);
        }
        if (this.checkpoint_url != null) {
            Io_mgr.Instance.DeleteFil(this.checkpoint_url);
        }
    }

    @Override
    public long Checkpoint__load_by_trg_fil(Io_url io_url) {
        this.tmp_url = io_url.GenNewExt(".tmp");
        this.checkpoint_url = io_url.GenNewExt(".checkpoint");
        return this.Checkpoint__load();
    }

    private long Checkpoint__load() {
        byte[] byArray = Io_mgr.Instance.LoadFilBryOrNull(this.checkpoint_url);
        return byArray == null ? 0L : Long_.parse_or(String_.new_a7(byArray), 0L);
    }

    public void Checkpoint__save(long l) {
        if (l < this.checkpoint_nxt) {
            return;
        }
        Io_mgr.Instance.SaveFilStr(this.checkpoint_url, Long_.To_str(l));
        this.downloaded = l;
        this.checkpoint_nxt += this.checkpoint_interval;
    }
}

