/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios.streams;

import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.Err_;
import gplx.Io_url;
import gplx.Io_url_;
import gplx.Virtual;
import gplx.core.ios.IoEngine_system;
import gplx.core.ios.streams.IoStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class IoStream_base
implements IoStream {
    Io_url url = Io_url_.Empty;
    long pos;
    long length;
    Bry_bfr bfr = Bry_bfr_.Reset(16);
    RandomAccessFile under;
    boolean mode_is_append;
    byte mode;

    @Override
    @Virtual
    public Io_url Url() {
        return this.url;
    }

    @Override
    public void Transfer(IoStream ioStream, int n) {
        byte[] byArray = new byte[n];
        int n2 = -1;
        while (n2 != 0) {
            n2 = this.Read(byArray, 0, n);
            ioStream.Write(byArray, 0, n2);
        }
        ioStream.Flush();
    }

    @Override
    public int ReadAry(byte[] byArray) {
        return this.Read(byArray, 0, byArray.length);
    }

    @Override
    public void WriteAry(byte[] byArray) {
        this.Write(byArray, 0, byArray.length);
    }

    @Override
    @Virtual
    public Object UnderRdr() {
        return this.under;
    }

    @Virtual
    public void UnderRdr_(Object object) {
        this.under = (RandomAccessFile)object;
    }

    @Override
    @Virtual
    public long Pos() {
        return this.pos;
    }

    @Override
    @Virtual
    public long Len() {
        return this.length;
    }

    @Override
    @Virtual
    public int Read(byte[] byArray, int n, int n2) {
        try {
            int n3 = this.under.read(byArray, n, n2);
            return n3 == -1 ? 0 : n3;
        }
        catch (IOException iOException) {
            throw Err_.new_exc(iOException, "io", "file read failed", "url", this.url);
        }
    }

    @Override
    public long Seek(long l) {
        try {
            this.under.seek(l);
            this.pos = this.under.getFilePointer();
            return this.pos;
        }
        catch (IOException iOException) {
            throw Err_.new_exc(iOException, "io", "seek failed", "url", this.url);
        }
    }

    @Override
    @Virtual
    public void Write(byte[] byArray, int n, int n2) {
        this.bfr.Add_mid(byArray, n, n + n2);
        this.Flush();
    }

    @Override
    public void Write_and_flush(byte[] byArray, int n, int n2) {
        this.Flush();
        int n3 = 16384;
        byte[] byArray2 = new byte[n3];
        int n4 = n;
        boolean bl = true;
        while (bl) {
            int n5 = n4 + n3;
            if (n5 > n2) {
                n5 = n2;
                n3 = n2 - n4;
                bl = false;
            }
            for (int i = 0; i < n3; ++i) {
                byArray2[i] = byArray[i + n4];
            }
            try {
                this.under.write(byArray2, 0, n3);
            }
            catch (IOException iOException) {
                throw Err_.new_exc(iOException, "io", "write failed", "url", this.url);
            }
            n4 = n5;
        }
    }

    @Override
    @Virtual
    public void Flush() {
        try {
            if (this.mode_is_append) {
                this.under.seek(this.under.length());
            }
        }
        catch (IOException iOException) {
            throw Err_.new_exc(iOException, "io", "seek failed", "url", this.url);
        }
        try {
            this.under.write(this.bfr.Bfr(), 0, this.bfr.Len());
        }
        catch (IOException iOException) {
            throw Err_.new_exc(iOException, "io", "write failed", "url", this.url);
        }
        this.bfr.Clear();
    }

    @Override
    @Virtual
    public void Rls() {
        IoEngine_system.Closeable_close((Closeable)this.under, this.url, true);
    }

    public static IoStream_base rdr_wrapper_() {
        return new IoStream_base();
    }

    public static IoStream_base new_(Io_url io_url, int n) {
        IoStream_base ioStream_base = new IoStream_base();
        ioStream_base.url = io_url;
        ioStream_base.mode = (byte)n;
        File file = new File(io_url.Xto_api());
        String string = "";
        switch (n) {
            case 2: {
                ioStream_base.mode_is_append = n == 2;
                string = "rws";
                break;
            }
            case 1: {
                string = "rws";
                break;
            }
            case 0: {
                string = "r";
            }
        }
        try {
            ioStream_base.under = new RandomAccessFile(file, string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw Err_.new_exc(fileNotFoundException, "io", "file open failed", "url", io_url);
        }
        if (n == 1) {
            try {
                ioStream_base.under.setLength(0L);
            }
            catch (IOException iOException) {
                throw Err_.new_exc(iOException, "io", "file truncate failed", "url", io_url);
            }
        }
        ioStream_base.length = file.length();
        return ioStream_base;
    }

    public static IoStream_base new_(Object object) {
        IoStream_base ioStream_base = new IoStream_base();
        ioStream_base.url = Io_url_.Empty;
        return ioStream_base;
    }
}

