/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios;

import gplx.Bry_;
import gplx.Bry_bfr;
import gplx.DateAdp;
import gplx.DateAdp_;
import gplx.Err;
import gplx.Err_;
import gplx.Gfo_usr_dlg;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.Io_url_;
import gplx.Long_;
import gplx.String_;
import gplx.Type_;
import gplx.core.envs.Op_sys;
import gplx.core.ios.IoEngineArgs;
import gplx.core.ios.IoEnginePool;
import gplx.core.ios.IoEngineUtl;
import gplx.core.ios.IoEngine_base;
import gplx.core.ios.IoEngine_system_xtn;
import gplx.core.ios.IoEngine_xrg_deleteDir;
import gplx.core.ios.IoEngine_xrg_deleteFil;
import gplx.core.ios.IoEngine_xrg_downloadFil;
import gplx.core.ios.IoEngine_xrg_loadFilStr;
import gplx.core.ios.IoEngine_xrg_openWrite;
import gplx.core.ios.IoEngine_xrg_queryDir;
import gplx.core.ios.IoEngine_xrg_saveFilStr;
import gplx.core.ios.IoEngine_xrg_xferDir;
import gplx.core.ios.IoEngine_xrg_xferFil;
import gplx.core.ios.IoErr;
import gplx.core.ios.IoItmAttrib;
import gplx.core.ios.IoItmDir;
import gplx.core.ios.IoItmDir_;
import gplx.core.ios.IoItmFil;
import gplx.core.ios.IoItmFil_;
import gplx.core.ios.IoItm_base;
import gplx.core.ios.IoUrlInfo;
import gplx.core.ios.Io_download_fmt;
import gplx.core.ios.Io_stream_rdr_http;
import gplx.core.ios.streams.IoStream;
import gplx.core.ios.streams.IoStream_base;
import gplx.core.ios.streams.Io_stream_rdr;
import gplx.core.progs.Gfo_prog_ui;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class IoEngine_system
extends IoEngine_base {
    boolean user_agent_needs_resetting = true;
    Io_url session_fil;
    Bry_bfr prog_fmt_bfr;
    byte[] download_bfr;
    static final int Download_bfr_len = 131072;
    IoEngineUtl utl = IoEngineUtl.new_();
    static final String GRP_KEY = "Io_engine";
    public static boolean Web_access_enabled = true;

    @Override
    public String Key() {
        return "sys";
    }

    @Override
    public void DeleteDirDeep(IoEngine_xrg_deleteDir ioEngine_xrg_deleteDir) {
        this.utl.DeleteDirDeep(this, ioEngine_xrg_deleteDir.Url(), ioEngine_xrg_deleteDir);
    }

    @Override
    public void XferDir(IoEngine_xrg_xferDir ioEngine_xrg_xferDir) {
        Io_url io_url = ioEngine_xrg_xferDir.Trg();
        this.utl.XferDir(this, ioEngine_xrg_xferDir.Src(), IoEnginePool.Instance.Get_by(io_url.Info().EngineKey()), io_url, ioEngine_xrg_xferDir);
    }

    @Override
    public void XferFil(IoEngine_xrg_xferFil ioEngine_xrg_xferFil) {
        this.utl.XferFil(this, ioEngine_xrg_xferFil);
    }

    @Override
    public IoItmDir QueryDirDeep(IoEngine_xrg_queryDir ioEngine_xrg_queryDir) {
        return this.utl.QueryDirDeep(this, ioEngine_xrg_queryDir);
    }

    @Override
    public void CopyDir(Io_url io_url, Io_url io_url2) {
        IoEngine_xrg_xferDir.copy_(io_url, io_url2).Recur_().Exec();
    }

    @Override
    public void MoveDirDeep(IoEngine_xrg_xferDir ioEngine_xrg_xferDir) {
        Io_url io_url = ioEngine_xrg_xferDir.Trg();
        this.utl.XferDir(this, ioEngine_xrg_xferDir.Src(), IoEnginePool.Instance.Get_by(io_url.Info().EngineKey()), io_url, ioEngine_xrg_xferDir);
    }

    @Override
    public void DeleteFil_api(IoEngine_xrg_deleteFil ioEngine_xrg_deleteFil) {
        Io_url io_url = ioEngine_xrg_deleteFil.Url();
        File file = this.Fil_(io_url);
        if (!this.Fil_Exists(file)) {
            return;
        }
        this.MarkFileWritable(file, io_url, ioEngine_xrg_deleteFil.ReadOnlyFails(), "DeleteFile");
        this.DeleteFil_lang(file, io_url);
    }

    @Override
    public boolean ExistsFil_api(Io_url io_url) {
        File file = new File(io_url.Xto_api());
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void SaveFilText_api(IoEngine_xrg_saveFilStr ioEngine_xrg_saveFilStr) {
        Io_url io_url = ioEngine_xrg_saveFilStr.Url();
        byte[] byArray = null;
        byArray = Bry_.new_u8(ioEngine_xrg_saveFilStr.Text());
        FileChannel fileChannel = null;
        FileOutputStream fileOutputStream = null;
        if (!this.ExistsDir(io_url.OwnerDir())) {
            this.CreateDir(io_url.OwnerDir());
        }
        try {
            try {
                fileOutputStream = new FileOutputStream(io_url.Xto_api(), ioEngine_xrg_saveFilStr.Append());
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw IoEngine_system.Err_Fil_NotFound(fileNotFoundException, io_url);
            }
            fileChannel = fileOutputStream.getChannel();
            try {
                fileChannel.write(ByteBuffer.wrap(byArray));
            }
            catch (IOException iOException) {
                IoEngine_system.Closeable_close((Closeable)fileChannel, io_url, false);
                IoEngine_system.Closeable_close((Closeable)fileOutputStream, io_url, false);
                throw Err_.new_exc(iOException, "io", "write data to file failed", "url", io_url.Xto_api());
            }
            if (!Op_sys.Cur().Tid_is_drd()) {
                File file = new File(io_url.Xto_api());
                IoEngine_system_xtn.SetExecutable(file, true);
            }
        }
        catch (Throwable throwable) {
            IoEngine_system.Closeable_close(fileChannel, io_url, false);
            IoEngine_system.Closeable_close((Closeable)fileOutputStream, io_url, false);
            throw throwable;
        }
        IoEngine_system.Closeable_close((Closeable)fileChannel, io_url, false);
        IoEngine_system.Closeable_close((Closeable)fileOutputStream, io_url, false);
    }

    @Override
    public String LoadFilStr(IoEngine_xrg_loadFilStr ioEngine_xrg_loadFilStr) {
        Io_url io_url = ioEngine_xrg_loadFilStr.Url();
        String string = io_url.Xto_api();
        boolean bl = this.ExistsFil_api(io_url);
        if (!bl) {
            if (ioEngine_xrg_loadFilStr.MissingIgnored()) {
                return "";
            }
            throw IoEngine_system.Err_Fil_NotFound(io_url);
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (ioEngine_xrg_loadFilStr.MissingIgnored()) {
                return "";
            }
            throw IoEngine_system.Err_Fil_NotFound(fileNotFoundException, io_url);
        }
        return IoEngine_system.Load_from_stream_as_str(fileInputStream, string);
    }

    public static String Load_from_stream_as_str(InputStream inputStream, String string) {
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, IoEngineArgs.Instance.LoadFilStr_Encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            IoEngine_system.Closeable_close((Closeable)inputStream, string, false);
            throw IoEngine_system.Err_text_unsupported_encoding(IoEngineArgs.Instance.LoadFilStr_Encoding, "", string, unsupportedEncodingException);
        }
        char[] cArray = new char[IoEngineArgs.Instance.LoadFilStr_BufferSize];
        int n = 0;
        StringWriter stringWriter = new StringWriter();
        while (true) {
            try {
                n = inputStreamReader.read(cArray);
            }
            catch (IOException iOException) {
                try {
                    inputStream.close();
                    inputStreamReader.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                throw Err_.new_exc(iOException, "io", "read data from file failed", "url", string, "pos", n);
            }
            if (n == -1) break;
            stringWriter.write(cArray, 0, n);
        }
        IoEngine_system.Closeable_close((Closeable)inputStream, string, false);
        IoEngine_system.Closeable_close((Closeable)inputStreamReader, string, false);
        return stringWriter.toString();
    }

    public static byte[] Load_from_stream_as_bry(InputStream inputStream, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        int n = 0;
        try {
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public boolean ExistsDir(Io_url io_url) {
        return new File(io_url.Xto_api()).exists();
    }

    @Override
    public void CreateDir(Io_url io_url) {
        new File(io_url.Xto_api()).mkdirs();
    }

    @Override
    public void DeleteDir(Io_url io_url) {
        File file = new File(io_url.Xto_api());
        if (!file.exists()) {
            return;
        }
        boolean bl = file.delete();
        if (!bl) {
            throw Err_.new_(IoEngineArgs.Instance.Err_IoException, "delete dir failed", "url", io_url.Xto_api());
        }
    }

    @Override
    public IoItmDir QueryDir(Io_url io_url) {
        File file;
        IoItmDir ioItmDir = IoItmDir_.scan_(io_url);
        String string = io_url.Xto_api();
        if (Op_sys.Cur().Tid_is_wnt() && String_.Eq(io_url.OwnerDir().Raw(), "")) {
            string = string + "\\";
        }
        if (!(file = new File(string)).exists()) {
            ioItmDir.Exists_set(false);
            return ioItmDir;
        }
        IoUrlInfo ioUrlInfo = io_url.Info();
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return ioItmDir;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            IoItm_base ioItm_base;
            File file2 = fileArray[i];
            if (file2.isFile()) {
                ioItm_base = this.QueryMkr_fil(ioUrlInfo, file2);
                ioItmDir.SubFils().Add(ioItm_base);
                continue;
            }
            ioItm_base = this.QueryMkr_dir(ioUrlInfo, file2);
            ioItmDir.SubDirs().Add(ioItm_base);
        }
        return ioItmDir;
    }

    IoItmFil QueryMkr_fil(IoUrlInfo ioUrlInfo, File file) {
        Io_url io_url = Io_url_.new_inf_(file.getPath(), ioUrlInfo);
        long l = file.exists() ? file.length() : -1L;
        IoItmFil ioItmFil = IoItmFil_.new_(io_url, l, DateAdp_.MinValue, DateAdp_.unixtime_lcl_ms_(file.lastModified()));
        ioItmFil.ReadOnly_(!file.canWrite());
        return ioItmFil;
    }

    IoItmDir QueryMkr_dir(IoUrlInfo ioUrlInfo, File file) {
        Io_url io_url = Io_url_.new_inf_(file.getPath() + ioUrlInfo.DirSpr(), ioUrlInfo);
        return IoItmDir_.scan_(io_url);
    }

    @Override
    public IoItmFil QueryFil(Io_url io_url) {
        File file = new File(io_url.Xto_api());
        return this.QueryMkr_fil(io_url.Info(), file);
    }

    @Override
    public void UpdateFilAttrib(Io_url io_url, IoItmAttrib ioItmAttrib) {
        File file = new File(io_url.Xto_api());
        boolean bl = true;
        if (ioItmAttrib.ReadOnly() != this.Fil_ReadOnly(file)) {
            if (ioItmAttrib.ReadOnly()) {
                bl = file.setReadOnly();
            } else if (!Op_sys.Cur().Tid_is_drd()) {
                IoEngine_system_xtn.SetWritable(file, true);
            }
            if (!bl) {
                throw Err_.new_(IoEngineArgs.Instance.Err_IoException, "set file attribute failed", "attribute", "readOnly", "cur", this.Fil_ReadOnly(file), "new", ioItmAttrib.ReadOnly(), "url", io_url.Xto_api());
            }
        }
        if (ioItmAttrib.Hidden() != file.isHidden()) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void UpdateFilModifiedTime(Io_url io_url, DateAdp dateAdp) {
        long l;
        File file = new File(io_url.Xto_api());
        if (!file.setLastModified(l = dateAdp.UnderDateTime().getTimeInMillis()) && this.Fil_ReadOnly(file)) {
            boolean bl = false;
            try {
                this.UpdateFilAttrib(io_url, IoItmAttrib.normal_());
                bl = file.setLastModified(l);
            }
            finally {
                this.UpdateFilAttrib(io_url, IoItmAttrib.readOnly_());
            }
            if (!bl) {
                throw Err_.new_wo_type("could not update file modified time", "url", io_url.Xto_api(), "modifiedTime", dateAdp.XtoStr_gplx_long());
            }
        }
    }

    @Override
    public IoStream OpenStreamRead(Io_url io_url) {
        return IoStream_base.new_(io_url, 0);
    }

    @Override
    public IoStream OpenStreamWrite(IoEngine_xrg_openWrite ioEngine_xrg_openWrite) {
        Io_url io_url = ioEngine_xrg_openWrite.Url();
        if (!this.ExistsFil_api(io_url)) {
            this.SaveFilText_api(IoEngine_xrg_saveFilStr.new_(io_url, ""));
        }
        return IoStream_base.new_(io_url, ioEngine_xrg_openWrite.Mode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void CopyFil(IoEngine_xrg_xferFil ioEngine_xrg_xferFil) {
        boolean bl = ioEngine_xrg_xferFil.Overwrite();
        Io_url io_url = ioEngine_xrg_xferFil.Src();
        Io_url io_url2 = ioEngine_xrg_xferFil.Trg();
        File file = new File(io_url.Xto_api());
        File file2 = new File(io_url2.Xto_api());
        if (file2.isFile()) {
            this.Chk_TrgFil_Overwrite(bl, io_url2);
            this.MarkFileWritable(file2, io_url2, ioEngine_xrg_xferFil.ReadOnlyFails(), "copy");
        } else {
            boolean bl2 = true;
            if (!this.ExistsDir(io_url2.OwnerDir())) {
                this.CreateDir(io_url2.OwnerDir());
            }
            try {
                file2.createNewFile();
                if (!Op_sys.Cur().Tid_is_drd()) {
                    IoEngine_system_xtn.SetExecutable(file2, true);
                }
            }
            catch (IOException iOException) {
                bl2 = false;
            }
            if (!bl2) {
                throw Err_.new_wo_type("create file failed", "trg", io_url2.Xto_api());
            }
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        FileChannel fileChannel = null;
        FileChannel fileChannel2 = null;
        try {
            long l;
            block19: {
                try {
                    fileInputStream = new FileInputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw IoErr.FileNotFound("copy", io_url);
                }
                try {
                    fileOutputStream = new FileOutputStream(file2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileOutputStream = this.TryToUnHideFile(file2, io_url2);
                    if (fileOutputStream != null) break block19;
                    throw IoErr.FileNotFound("copy", io_url2);
                }
            }
            fileChannel = fileInputStream.getChannel();
            fileChannel2 = fileOutputStream.getChannel();
            long l2 = 0L;
            long l3 = 0L;
            try {
                l2 = fileChannel.size();
            }
            catch (IOException iOException) {
                throw Err_.new_exc(iOException, "io", "size failed", "src", io_url.Xto_api());
            }
            int n = IoEngineArgs.Instance.LoadFilStr_BufferSize;
            long l4 = l = l2 > (long)n ? (long)n : l2;
            for (long i = 0L; i < l2; i += l3) {
                try {
                    l3 = fileChannel2.transferFrom(fileChannel, i, l);
                }
                catch (IOException iOException) {
                    IoEngine_system.Closeable_close((Closeable)fileChannel, io_url, false);
                    IoEngine_system.Closeable_close((Closeable)fileChannel2, io_url2, false);
                    IoEngine_system.Closeable_close((Closeable)fileInputStream, io_url, false);
                    IoEngine_system.Closeable_close((Closeable)fileOutputStream, io_url, false);
                    throw Err_.new_exc(iOException, "io", "transfer data failed", "src", io_url.Xto_api(), "trg", io_url2.Xto_api());
                }
                if (l3 != -1L) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            IoEngine_system.Closeable_close(fileChannel, io_url, false);
            IoEngine_system.Closeable_close(fileChannel2, io_url2, false);
            IoEngine_system.Closeable_close((Closeable)fileInputStream, io_url, false);
            IoEngine_system.Closeable_close((Closeable)fileOutputStream, io_url, false);
            throw throwable;
        }
        IoEngine_system.Closeable_close((Closeable)fileChannel, io_url, false);
        IoEngine_system.Closeable_close((Closeable)fileChannel2, io_url2, false);
        IoEngine_system.Closeable_close((Closeable)fileInputStream, io_url, false);
        IoEngine_system.Closeable_close((Closeable)fileOutputStream, io_url, false);
        this.UpdateFilModifiedTime(io_url2, this.QueryFil(io_url).ModifiedTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void CopyFil(Gfo_prog_ui gfo_prog_ui, Io_url io_url, Io_url io_url2, boolean bl, boolean bl2) {
        File file = new File(io_url.Xto_api());
        File file2 = new File(io_url2.Xto_api());
        if (file2.isFile()) {
            this.Chk_TrgFil_Overwrite(bl, io_url2);
            this.MarkFileWritable(file2, io_url2, bl2, "copy");
        } else {
            boolean bl3 = true;
            if (!this.ExistsDir(io_url2.OwnerDir())) {
                this.CreateDir(io_url2.OwnerDir());
            }
            try {
                file2.createNewFile();
                if (!Op_sys.Cur().Tid_is_drd()) {
                    IoEngine_system_xtn.SetExecutable(file2, true);
                }
            }
            catch (IOException iOException) {
                bl3 = false;
            }
            if (!bl3) {
                throw Err_.new_wo_type("create file failed", "trg", io_url2.Xto_api());
            }
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        FileChannel fileChannel = null;
        FileChannel fileChannel2 = null;
        try {
            long l;
            block19: {
                try {
                    fileInputStream = new FileInputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw IoErr.FileNotFound("copy", io_url);
                }
                try {
                    fileOutputStream = new FileOutputStream(file2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileOutputStream = this.TryToUnHideFile(file2, io_url2);
                    if (fileOutputStream != null) break block19;
                    throw IoErr.FileNotFound("copy", io_url2);
                }
            }
            fileChannel = fileInputStream.getChannel();
            fileChannel2 = fileOutputStream.getChannel();
            long l2 = 0L;
            long l3 = 0L;
            try {
                l2 = fileChannel.size();
            }
            catch (IOException iOException) {
                throw Err_.new_exc(iOException, "io", "size failed", "src", io_url.Xto_api());
            }
            int n = IoEngineArgs.Instance.LoadFilStr_BufferSize;
            long l4 = l = l2 > (long)n ? (long)n : l2;
            for (long i = 0L; i < l2; i += l3) {
                try {
                    l3 = fileChannel2.transferFrom(fileChannel, i, l);
                }
                catch (IOException iOException) {
                    IoEngine_system.Closeable_close((Closeable)fileChannel, io_url, false);
                    IoEngine_system.Closeable_close((Closeable)fileChannel2, io_url2, false);
                    IoEngine_system.Closeable_close((Closeable)fileInputStream, io_url, false);
                    IoEngine_system.Closeable_close((Closeable)fileOutputStream, io_url, false);
                    throw Err_.new_exc(iOException, "io", "transfer data failed", "src", io_url.Xto_api(), "trg", io_url2.Xto_api());
                }
                if (l3 == -1L) break;
                if (!gfo_prog_ui.Prog_notify_and_chk_if_suspended(i, l2)) break block20;
            }
        }
        catch (Throwable throwable) {
            IoEngine_system.Closeable_close(fileChannel, io_url, false);
            IoEngine_system.Closeable_close(fileChannel2, io_url2, false);
            IoEngine_system.Closeable_close((Closeable)fileInputStream, io_url, false);
            IoEngine_system.Closeable_close((Closeable)fileOutputStream, io_url, false);
            throw throwable;
        }
        {
            block20: {
                IoEngine_system.Closeable_close((Closeable)fileChannel, io_url, false);
                IoEngine_system.Closeable_close((Closeable)fileChannel2, io_url2, false);
                IoEngine_system.Closeable_close((Closeable)fileInputStream, io_url, false);
                IoEngine_system.Closeable_close((Closeable)fileOutputStream, io_url, false);
                return;
            }
            continue;
        }
        IoEngine_system.Closeable_close((Closeable)fileChannel, io_url, false);
        IoEngine_system.Closeable_close((Closeable)fileChannel2, io_url2, false);
        IoEngine_system.Closeable_close((Closeable)fileInputStream, io_url, false);
        IoEngine_system.Closeable_close((Closeable)fileOutputStream, io_url, false);
        this.UpdateFilModifiedTime(io_url2, this.QueryFil(io_url).ModifiedTime());
    }

    FileOutputStream TryToUnHideFile(File file, Io_url io_url) {
        FileOutputStream fileOutputStream = null;
        if (file.exists()) {
            Process process = null;
            try {
                String string = "attrib -H \"" + io_url.Xto_api() + "\"";
                process = Runtime.getRuntime().exec(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            try {
                fileOutputStream = new FileOutputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        return fileOutputStream;
    }

    @Override
    public void MoveFil(IoEngine_xrg_xferFil ioEngine_xrg_xferFil) {
        String string;
        Io_url io_url = ioEngine_xrg_xferFil.Src();
        Io_url io_url2 = ioEngine_xrg_xferFil.Trg();
        String string2 = io_url.Xto_api();
        if (String_.Eq(string2, string = io_url2.Xto_api())) {
            return;
        }
        File file = new File(string2);
        File file2 = new File(string);
        if (String_.Eq(io_url.OwnerRoot().Raw(), io_url2.OwnerRoot().Raw())) {
            boolean bl = ioEngine_xrg_xferFil.Overwrite();
            if (!file.exists() && ioEngine_xrg_xferFil.MissingFails()) {
                throw IoErr.FileNotFound("move", io_url);
            }
            if (file2.exists()) {
                this.Chk_TrgFil_Overwrite(bl, io_url2);
                this.MarkFileWritable(file2, io_url2, ioEngine_xrg_xferFil.ReadOnlyFails(), "move");
                this.DeleteFil_lang(file2, ioEngine_xrg_xferFil.Trg());
            }
            if (!this.ExistsDir(io_url2.OwnerDir())) {
                this.CreateDir(io_url2.OwnerDir());
            }
            file.renameTo(file2);
        } else {
            if (!file.exists() && !ioEngine_xrg_xferFil.MissingFails()) {
                return;
            }
            this.CopyFil(ioEngine_xrg_xferFil);
            this.DeleteFil_lang(file, io_url);
        }
    }

    void Chk_TrgFil_Overwrite(boolean bl, Io_url io_url) {
        if (!bl) {
            throw Err_.new_invalid_op("trgFile exists but overwriteFlag not set").Args_add("trg", io_url.Xto_api());
        }
    }

    @Override
    public void MoveDir(Io_url io_url, Io_url io_url2) {
        String string = io_url.Xto_api();
        String string2 = io_url2.Xto_api();
        File file = new File(string);
        File file2 = new File(string2);
        if (file2.exists()) {
            throw Err_.new_invalid_op("cannot move dir if trg exists").Args_add("src", io_url, "trg", io_url2);
        }
        if (String_.Eq(io_url.OwnerRoot().Raw(), io_url2.OwnerRoot().Raw())) {
            file.renameTo(file2);
        } else {
            this.XferDir(IoEngine_xrg_xferDir.copy_(io_url, io_url2));
        }
    }

    public static void Closeable_close(Closeable closeable, Io_url io_url, boolean bl) {
        IoEngine_system.Closeable_close(closeable, io_url.Xto_api(), bl);
    }

    public static void Closeable_close(Closeable closeable, String string, boolean bl) {
        block3: {
            if (closeable == null) {
                return;
            }
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                if (!bl) break block3;
                throw Err_.new_exc(iOException, "io", "close object failed", "class", Type_.Name_by_obj(closeable), "url", string);
            }
        }
    }

    File Fil_(Io_url io_url) {
        return new File(io_url.Xto_api());
    }

    boolean Fil_Exists(File file) {
        return file.exists();
    }

    boolean Fil_ReadOnly(File file) {
        return !file.canWrite();
    }

    boolean Fil_Delete(File file) {
        return file.delete();
    }

    void Fil_Writable(File file) {
        if (!Op_sys.Cur().Tid_is_drd()) {
            IoEngine_system_xtn.SetWritable(file, true);
        }
    }

    private static Err Err_text_unsupported_encoding(String string, String string2, String string3, Exception exception) {
        return Err_.new_exc(exception, "io", "text is in unsupported encoding", new Object[0]).Args_add("encodingName", string, "text", string2, "url", string3);
    }

    @Override
    public Io_stream_rdr DownloadFil_as_rdr(IoEngine_xrg_downloadFil ioEngine_xrg_downloadFil) {
        Io_stream_rdr_http io_stream_rdr_http = new Io_stream_rdr_http(ioEngine_xrg_downloadFil);
        io_stream_rdr_http.Open();
        return io_stream_rdr_http;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean DownloadFil(IoEngine_xrg_downloadFil ioEngine_xrg_downloadFil) {
        IoStream ioStream = null;
        BufferedInputStream bufferedInputStream = null;
        URL uRL = null;
        HttpURLConnection httpURLConnection = null;
        if (this.user_agent_needs_resetting) {
            this.user_agent_needs_resetting = false;
            System.setProperty("http.agent", "");
        }
        boolean bl = Io_mgr.Instance.ExistsDir(ioEngine_xrg_downloadFil.Trg().OwnerDir());
        Gfo_usr_dlg gfo_usr_dlg = null;
        String string = ioEngine_xrg_downloadFil.Src();
        Io_download_fmt io_download_fmt = ioEngine_xrg_downloadFil.Download_fmt();
        gfo_usr_dlg = io_download_fmt.Usr_dlg();
        if (!Web_access_enabled) {
            if (gfo_usr_dlg != null) {
                if (this.session_fil == null) {
                    this.session_fil = gfo_usr_dlg.Log_wkr().Session_dir().GenSubFil("internet.txt");
                }
                gfo_usr_dlg.Log_wkr().Log_msg_to_url_fmt(this.session_fil, "download disabled: src='~{0}' trg='~{1}'", ioEngine_xrg_downloadFil.Src(), ioEngine_xrg_downloadFil.Trg().Raw());
            }
            return false;
        }
        try {
            ioStream = Io_mgr.Instance.OpenStreamWrite(ioEngine_xrg_downloadFil.Trg());
            uRL = new URL(string);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            String string2 = ioEngine_xrg_downloadFil.User_agent();
            if (string2 != null) {
                httpURLConnection.setRequestProperty("User-Agent", string2);
            }
            long l = Long_.parse_or(httpURLConnection.getHeaderField("Content-Length"), -1L);
            ioEngine_xrg_downloadFil.Src_content_length_(l);
            if (ioEngine_xrg_downloadFil.Src_last_modified_query()) {
                ioEngine_xrg_downloadFil.Src_last_modified_(DateAdp_.unixtime_lcl_ms_(httpURLConnection.getLastModified()));
            }
            if (ioEngine_xrg_downloadFil.Exec_meta_only()) {
                boolean bl2 = true;
                return bl2;
            }
            bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
            if (!bl) {
                Io_mgr.Instance.CreateDir(ioEngine_xrg_downloadFil.Trg().OwnerDir());
            }
            byte[] byArray = new byte[131072];
            io_download_fmt.Bgn(l);
            int n = 0;
            while ((n = bufferedInputStream.read(byArray, 0, 131072)) != -1) {
                if (ioEngine_xrg_downloadFil.Prog_cancel()) {
                    bufferedInputStream.close();
                    ioStream.Rls();
                    Io_mgr.Instance.DeleteFil(ioEngine_xrg_downloadFil.Trg());
                }
                io_download_fmt.Prog(n);
                ioStream.Write(byArray, 0, n);
            }
            if (gfo_usr_dlg != null) {
                io_download_fmt.Term();
                if (this.session_fil == null) {
                    this.session_fil = gfo_usr_dlg.Log_wkr().Session_dir().GenSubFil("internet.txt");
                }
                gfo_usr_dlg.Log_wkr().Log_msg_to_url_fmt(this.session_fil, "download pass: src='~{0}' trg='~{1}'", string, ioEngine_xrg_downloadFil.Trg().Raw());
            }
            boolean bl3 = true;
            return bl3;
        }
        catch (Exception exception) {
            ioEngine_xrg_downloadFil.Rslt_err_(exception);
            if (Type_.Eq_by_obj(exception, UnknownHostException.class)) {
                ioEngine_xrg_downloadFil.Rslt_((byte)1);
            } else if (Type_.Eq_by_obj(exception, FileNotFoundException.class)) {
                ioEngine_xrg_downloadFil.Rslt_((byte)2);
            } else {
                ioEngine_xrg_downloadFil.Rslt_((byte)3);
            }
            if (gfo_usr_dlg != null && !ioEngine_xrg_downloadFil.Prog_cancel()) {
                if (this.session_fil == null) {
                    this.session_fil = gfo_usr_dlg.Log_wkr().Session_dir().GenSubFil("internet.txt");
                }
                gfo_usr_dlg.Log_wkr().Log_msg_to_url_fmt(this.session_fil, "download fail: src='~{0}' trg='~{1}' error='~{2}'", string, ioEngine_xrg_downloadFil.Trg().Raw(), Err_.Message_lang(exception));
            }
            if (ioStream != null) {
                try {
                    ioStream.Rls();
                    this.DeleteFil_api(IoEngine_xrg_deleteFil.new_(ioEngine_xrg_downloadFil.Trg()));
                }
                catch (Exception exception2) {
                    Err_.Noop(exception2);
                }
            }
            boolean bl4 = false;
            return bl4;
        }
        finally {
            ioEngine_xrg_downloadFil.Prog_running_(false);
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                    httpURLConnection.getInputStream().close();
                }
            }
            catch (Exception exception) {
                Err_.Noop(exception);
            }
            if (ioStream != null) {
                ioStream.Rls();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean Truncate_fil(Io_url io_url, long l) {
        FileOutputStream fileOutputStream = null;
        FileChannel fileChannel = null;
        try {
            fileOutputStream = new FileOutputStream(io_url.Xto_api(), true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw Err_.new_("io", "truncate: open failed", "url", io_url.Xto_api(), "err", Err_.Message_gplx_log(fileNotFoundException));
        }
        fileChannel = fileOutputStream.getChannel();
        try {
            fileChannel.truncate(l);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (fileChannel != null) {
                    fileChannel.close();
                }
            }
            catch (IOException iOException) {
                return false;
            }
        }
    }

    public static Err Err_Fil_NotFound(Io_url io_url) {
        return Err_.new_(IoEngineArgs.Instance.Err_FileNotFound, "file not found", "url", io_url.Xto_api()).Trace_ignore_add_1_();
    }

    public static Err Err_Fil_NotFound(Exception exception, Io_url io_url) {
        return Err_.new_exc(exception, "io", "file not found", "url", io_url.Xto_api()).Trace_ignore_add_1_();
    }

    void MarkFileWritable(File file, Io_url io_url, boolean bl, String string) {
        if (this.Fil_ReadOnly(file)) {
            if (bl) {
                throw Err_.new_(IoEngineArgs.Instance.Err_ReadonlyFileNotWritable, "writable operation attempted on readOnly file", "op", string, "url", io_url.Xto_api());
            }
            this.Fil_Writable(file);
        }
    }

    void DeleteFil_lang(File file, Io_url io_url) {
        boolean bl = this.Fil_Delete(file);
        if (!bl) {
            throw Err_.new_(IoEngineArgs.Instance.Err_IoException, "file not deleted", "url", io_url.Xto_api());
        }
    }

    public static IoEngine_system new_() {
        return new IoEngine_system();
    }

    IoEngine_system() {
    }
}

