/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios;

import gplx.DateAdp;
import gplx.DateAdp_;
import gplx.Err_;
import gplx.Internal;
import gplx.Io_url;
import gplx.Tfds;
import gplx.Virtual;
import gplx.core.ios.IoEngine;
import gplx.core.ios.IoEngineFxt;
import gplx.core.ios.IoEngine_xrg_deleteDir;
import gplx.core.ios.IoEngine_xrg_xferFil;
import org.junit.Before;
import org.junit.Test;

public abstract class IoEngine_fil_xfer_base {
    protected IoEngine engine;
    @Internal
    protected IoEngineFxt fx;
    protected Io_url src;
    protected Io_url trg;
    protected Io_url root;
    DateAdp srcModifiedTime = DateAdp_.parse_gplx("2010.04.12 20.26.01.000");
    DateAdp trgModifiedTime = DateAdp_.parse_gplx("2010.04.01 01.01.01.000");

    @Before
    public void setup() {
        this.engine = this.engine_();
        this.fx = IoEngineFxt.new_();
        this.setup_hook();
        this.src = this.root.GenSubFil("src.txt");
        this.trg = this.root.GenSubFil("trg.txt");
    }

    protected abstract IoEngine engine_();

    protected abstract void setup_hook();

    protected abstract Io_url AltRoot();

    @Test
    @Virtual
    public void CopyFil() {
        this.fx.run_SaveFilText(this.src, "src");
        this.fx.run_UpdateFilModifiedTime(this.src, this.srcModifiedTime);
        this.fx.tst_ExistsPaths(true, this.src);
        this.fx.tst_ExistsPaths(false, this.trg);
        IoEngine_xrg_xferFil.copy_(this.src, this.trg).Exec();
        this.fx.tst_ExistsPaths(true, this.src, this.trg);
        this.fx.tst_LoadFilStr(this.trg, "src");
        this.fx.tst_QueryFil_modifiedTime(this.trg, this.srcModifiedTime);
    }

    @Test
    @Virtual
    public void CopyFil_overwrite_fail() {
        this.fx.run_SaveFilText(this.src, "src");
        this.fx.run_SaveFilText(this.trg, "trg");
        try {
            IoEngine_xrg_xferFil.copy_(this.src, this.trg).Exec();
        }
        catch (Exception exception) {
            Err_.Noop(exception);
            this.fx.tst_ExistsPaths(true, this.src, this.trg);
            this.fx.tst_LoadFilStr(this.trg, "trg");
            return;
        }
        Tfds.Fail_expdError();
    }

    @Test
    @Virtual
    public void CopyFil_overwrite_pass() {
        this.fx.run_SaveFilText(this.src, "src");
        this.fx.run_UpdateFilModifiedTime(this.src, this.srcModifiedTime);
        this.fx.run_SaveFilText(this.trg, "trg");
        this.fx.run_UpdateFilModifiedTime(this.trg, this.trgModifiedTime);
        IoEngine_xrg_xferFil.copy_(this.src, this.trg).Overwrite_().Exec();
        this.fx.tst_ExistsPaths(true, this.src, this.trg);
        this.fx.tst_LoadFilStr(this.trg, "src");
        this.fx.tst_QueryFil_modifiedTime(this.trg, this.srcModifiedTime);
    }

    @Test
    @Virtual
    public void MoveFil() {
        this.fx.run_SaveFilText(this.src, "src");
        this.fx.tst_ExistsPaths(true, this.src);
        this.fx.tst_ExistsPaths(false, this.trg);
        IoEngine_xrg_xferFil.move_(this.src, this.trg).Exec();
        this.fx.tst_ExistsPaths(false, this.src);
        this.fx.tst_ExistsPaths(true, this.trg);
    }

    @Test
    @Virtual
    public void MoveFil_overwrite_fail() {
        this.fx.run_SaveFilText(this.src, "src");
        this.fx.run_SaveFilText(this.trg, "trg");
        try {
            IoEngine_xrg_xferFil.move_(this.src, this.trg).Exec();
        }
        catch (Exception exception) {
            Err_.Noop(exception);
            this.fx.tst_ExistsPaths(true, this.src);
            this.fx.tst_ExistsPaths(true, this.trg);
            this.fx.tst_LoadFilStr(this.trg, "trg");
            return;
        }
        Tfds.Fail_expdError();
    }

    @Test
    @Virtual
    public void MoveFil_overwrite_pass() {
        this.fx.run_SaveFilText(this.src, "src");
        this.fx.run_UpdateFilModifiedTime(this.src, this.srcModifiedTime);
        this.fx.run_SaveFilText(this.trg, "trg");
        this.fx.run_UpdateFilModifiedTime(this.trg, this.trgModifiedTime);
        IoEngine_xrg_xferFil.move_(this.src, this.trg).Overwrite_().Exec();
        this.fx.tst_ExistsPaths(false, this.src);
        this.fx.tst_ExistsPaths(true, this.trg);
        this.fx.tst_LoadFilStr(this.trg, "src");
        this.fx.tst_QueryFil_modifiedTime(this.trg, this.srcModifiedTime);
    }

    @Test
    @Virtual
    public void MoveFil_betweenDrives() {
        IoEngine_xrg_deleteDir.new_(this.AltRoot()).Recur_().ReadOnlyFails_off().Exec();
        this.src = this.root.GenSubFil_nest("dir", "fil1a.txt");
        this.trg = this.AltRoot().GenSubFil_nest("dir", "fil1b.txt");
        this.fx.run_SaveFilText(this.src, "src");
        this.fx.tst_ExistsPaths(true, this.src);
        this.fx.tst_ExistsPaths(false, this.trg);
        IoEngine_xrg_xferFil.move_(this.src, this.trg).Exec();
        this.fx.tst_ExistsPaths(false, this.src);
        this.fx.tst_ExistsPaths(true, this.trg);
    }
}

