/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios;

import gplx.Internal;
import gplx.Io_url;
import gplx.Virtual;
import gplx.core.ios.IoEngine;
import gplx.core.ios.IoEngineFxt;
import org.junit.Before;
import org.junit.Test;

public abstract class IoEngine_dir_basic_base {
    protected IoEngine engine;
    @Internal
    protected IoEngineFxt fx;
    protected Io_url fil;
    protected Io_url root;

    @Before
    public void setup() {
        this.engine = this.engine_();
        this.fx = IoEngineFxt.new_();
        this.setup_hook();
    }

    protected abstract IoEngine engine_();

    protected abstract void setup_hook();

    @Test
    @Virtual
    public void CreateDir() {
        this.fx.tst_ExistsPaths(false, this.root);
        this.engine.CreateDir(this.root);
        this.fx.tst_ExistsPaths(true, this.root);
    }

    @Test
    public void DeleteDir() {
        this.engine.CreateDir(this.root);
        this.fx.tst_ExistsPaths(true, this.root);
        this.engine.DeleteDir(this.root);
        this.fx.tst_ExistsPaths(false, this.root);
    }

    @Test
    public void CreateDir_createAllOwners() {
        Io_url io_url = this.root.GenSubDir_nest("sub1");
        this.fx.tst_ExistsPaths(false, io_url, io_url.OwnerDir());
        this.engine.CreateDir(io_url);
        this.fx.tst_ExistsPaths(true, io_url, io_url.OwnerDir());
    }

    @Test
    public void DeleteDir_missing_pass() {
        this.engine.DeleteDir(this.root);
    }

    @Test
    @Virtual
    public void ScanDir() {
        Io_url io_url = this.root.GenSubFil("fil1.txt");
        this.fx.run_SaveFilText(io_url, "test");
        Io_url io_url2 = this.root.GenSubDir_nest("dir1");
        this.engine.CreateDir(io_url2);
        Io_url io_url3 = io_url2.GenSubDir_nest("dir1_1");
        this.engine.CreateDir(io_url3);
        this.fx.tst_ScanDir(this.root, io_url2, io_url);
    }

    @Test
    public void MoveDir() {
        Io_url io_url = this.root.GenSubDir_nest("src");
        Io_url io_url2 = this.root.GenSubDir_nest("trg");
        this.engine.CreateDir(io_url);
        this.fx.tst_ExistsPaths(true, io_url);
        this.fx.tst_ExistsPaths(false, io_url2);
        this.engine.MoveDir(io_url, io_url2);
        this.fx.tst_ExistsPaths(false, io_url);
        this.fx.tst_ExistsPaths(true, io_url2);
    }

    @Test
    @Virtual
    public void CopyDir() {
        Io_url io_url = this.root.GenSubDir_nest("src");
        Io_url io_url2 = this.root.GenSubDir_nest("trg");
        this.engine.CreateDir(io_url);
        this.fx.tst_ExistsPaths(true, io_url);
        this.fx.tst_ExistsPaths(false, io_url2);
        this.engine.CopyDir(io_url, io_url2);
        this.fx.tst_ExistsPaths(true, io_url, io_url2);
    }
}

