/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios;

import gplx.Array_;
import gplx.core.ios.Io_line_rdr;
import gplx.core.ios.Io_sort_split_itm;
import gplx.core.lists.ComparerAble;

class BinaryHeap_Io_line_rdr {
    ComparerAble comparer;
    Io_line_rdr[] ary = Ary_empty;
    int ary_len = 0;
    int ary_max = 0;
    Io_sort_split_itm lhs_itm = new Io_sort_split_itm();
    Io_sort_split_itm rhs_itm = new Io_sort_split_itm();
    private static final Io_line_rdr[] Ary_empty = new Io_line_rdr[0];

    public BinaryHeap_Io_line_rdr(ComparerAble comparerAble) {
        this.comparer = comparerAble;
    }

    public int Len() {
        return this.ary_len;
    }

    public void Add(Io_line_rdr io_line_rdr) {
        int n = this.ary_len + 1;
        if (n > this.ary_max) {
            this.ary_max = n * 2;
            this.ary = (Io_line_rdr[])Array_.Resize(this.ary, this.ary_max);
        }
        this.ary[this.ary_len] = io_line_rdr;
        this.ary_len = n;
        this.Add_move_up(this.ary_len - 1);
    }

    public Io_line_rdr Pop() {
        if (this.ary_len == 0) {
            return null;
        }
        Io_line_rdr io_line_rdr = this.ary[0];
        --this.ary_len;
        if (this.ary_len > 0) {
            this.ary[0] = this.ary[this.ary_len];
            this.Pop_move_down(0);
        }
        return io_line_rdr;
    }

    public void Rls() {
        for (int i = 0; i < this.ary_len; ++i) {
            Io_line_rdr io_line_rdr = this.ary[i];
            if (io_line_rdr != null) {
                io_line_rdr.Rls();
            }
            this.ary[i] = null;
        }
        this.ary = null;
        this.ary_len = 0;
    }

    private void Add_move_up(int n) {
        int n2;
        while (n > 0 && this.Compare(n, n2 = (n - 1) / 2) <= -1) {
            this.Swap(n, n2);
            n = n2;
        }
    }

    private void Pop_move_down(int n) {
        int n2 = this.ary_len - 1;
        while (n < this.ary_len / 2) {
            int n3 = 2 * n + 1;
            if (n3 < n2 && this.Compare(n3, n3 + 1) > 0) {
                ++n3;
            }
            if (this.Compare(n, n3) < 1) break;
            this.Swap(n, n3);
            n = n3;
        }
    }

    int Compare(int n, int n2) {
        Io_line_rdr io_line_rdr = this.ary[n];
        Io_line_rdr io_line_rdr2 = this.ary[n2];
        this.lhs_itm.Set(io_line_rdr);
        this.rhs_itm.Set(io_line_rdr2);
        return this.comparer.compare(this.lhs_itm, this.rhs_itm);
    }

    private void Swap(int n, int n2) {
        Io_line_rdr io_line_rdr = this.ary[n];
        this.ary[n] = this.ary[n2];
        this.ary[n2] = io_line_rdr;
    }
}

