/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.intls;

import gplx.Bry_;
import gplx.Err_;
import gplx.core.encoders.Hex_utl_;
import gplx.core.primitives.Int_obj_ref;

public class Utf16_ {
    public static int Surrogate_merge(int n, int n2) {
        return 65536 + (n - 55296) * 1024 + (n2 - 56320);
    }

    public static void Surrogate_split(int n, Int_obj_ref int_obj_ref, Int_obj_ref int_obj_ref2) {
        int_obj_ref.Val_((n - 65536) / 1024 + 55296);
        int_obj_ref2.Val_((n - 65536) % 1024 + 56320);
    }

    public static int Decode_to_int(byte[] byArray, int n) {
        byte by = byArray[n];
        if ((by & 0x80) == 0) {
            return by;
        }
        if ((by & 0xE0) == 192) {
            return (by & 0x1F) << 6 | byArray[n + 1] & 0x3F;
        }
        if ((by & 0xF0) == 224) {
            return (by & 0xF) << 12 | (byArray[n + 1] & 0x3F) << 6 | byArray[n + 2] & 0x3F;
        }
        if ((by & 0xF8) == 240) {
            return (by & 7) << 18 | (byArray[n + 1] & 0x3F) << 12 | (byArray[n + 2] & 0x3F) << 6 | byArray[n + 3] & 0x3F;
        }
        throw Err_.new_wo_type("invalid utf8 byte", "byte", by);
    }

    public static byte[] Encode_hex_to_bry(String string) {
        return Utf16_.Encode_hex_to_bry(Bry_.new_a7(string));
    }

    public static byte[] Encode_hex_to_bry(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = Hex_utl_.Parse_or(byArray, Integer.MIN_VALUE);
        return n == Integer.MIN_VALUE ? null : Utf16_.Encode_int_to_bry(n);
    }

    public static byte[] Encode_int_to_bry(int n) {
        int n2 = Utf16_.Len_by_int(n);
        byte[] byArray = new byte[n2];
        Utf16_.Encode_int(n, byArray, 0);
        return byArray;
    }

    public static int Encode_char(int n, char[] cArray, int n2, byte[] byArray, int n3) {
        if (n > -1 && n < 128) {
            byArray[n3] = (byte)n;
            return 1;
        }
        if (n < 2048) {
            byArray[n3] = (byte)(0xC0 | n >> 6);
            byArray[++n3] = (byte)(0x80 | n & 0x3F);
            return 1;
        }
        if (n > 55295 && n < 56320) {
            if (n2 >= cArray.length) {
                throw Err_.new_wo_type("incomplete surrogate pair at end of String", "char", n);
            }
            char c = cArray[n2 + 1];
            int n4 = Utf16_.Surrogate_merge(n, c);
            byArray[n3] = (byte)(0xF0 | n4 >> 18);
            byArray[++n3] = (byte)(0x80 | n4 >> 12 & 0x3F);
            byArray[++n3] = (byte)(0x80 | n4 >> 6 & 0x3F);
            byArray[++n3] = (byte)(0x80 | n4 & 0x3F);
            return 2;
        }
        byArray[n3] = (byte)(0xE0 | n >> 12);
        byArray[++n3] = (byte)(0x80 | n >> 6 & 0x3F);
        byArray[++n3] = (byte)(0x80 | n & 0x3F);
        return 1;
    }

    public static int Encode_int(int n, byte[] byArray, int n2) {
        if (n > -1 && n < 128) {
            byArray[n2] = (byte)n;
            return 1;
        }
        if (n < 2048) {
            byArray[n2] = (byte)(0xC0 | n >> 6);
            byArray[++n2] = (byte)(0x80 | n & 0x3F);
            return 2;
        }
        if (n < 65536) {
            byArray[n2] = (byte)(0xE0 | n >> 12);
            byArray[++n2] = (byte)(0x80 | n >> 6 & 0x3F);
            byArray[++n2] = (byte)(0x80 | n & 0x3F);
            return 3;
        }
        if (n < 0x200000) {
            byArray[n2] = (byte)(0xF0 | n >> 18);
            byArray[++n2] = (byte)(0x80 | n >> 12 & 0x3F);
            byArray[++n2] = (byte)(0x80 | n >> 6 & 0x3F);
            byArray[++n2] = (byte)(0x80 | n & 0x3F);
            return 4;
        }
        throw Err_.new_wo_type("UTF-16 int must be between 0 and 2097152", "char", n);
    }

    private static int Len_by_int(int n) {
        if (n > -1 && n < 128) {
            return 1;
        }
        if (n < 2048) {
            return 2;
        }
        if (n < 65536) {
            return 3;
        }
        if (n < 0x200000) {
            return 4;
        }
        throw Err_.new_wo_type("UTF-16 int must be between 0 and 2097152", "char", n);
    }

    public static int Len_by_char(int n) {
        if (n > -1 && n < 128) {
            return 1;
        }
        if (n < 2048) {
            return 2;
        }
        if (n > 55295 && n < 56320) {
            return 4;
        }
        if (n < 65536) {
            return 3;
        }
        throw Err_.new_wo_type("UTF-16 int must be between 0 and 65536", "char", n);
    }
}

