/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.envs;

import gplx.Char_;
import gplx.Err_;
import gplx.String_;

public class Op_sys {
    private final byte tid;
    private final byte sub_tid;
    private String os_name;
    private final byte bitness;
    private final String nl_str;
    private final String fsys_dir_spr_str;
    private final byte fsys_dir_spr_byte;
    private final boolean fsys_case_match;
    public static final byte Tid_nil = 0;
    public static final byte Tid_wnt = 1;
    public static final byte Tid_lnx = 2;
    public static final byte Tid_osx = 3;
    public static final byte Tid_drd = 4;
    public static final byte Tid_arm = 5;
    public static final byte Sub_tid_unknown = 0;
    public static final byte Sub_tid_win_xp = 1;
    public static final byte Sub_tid_win_7 = 2;
    public static final byte Sub_tid_win_8 = 3;
    public static final byte Bitness_32 = 1;
    public static final byte Bitness_64 = 2;
    public static final char Nl_char_lnx = '\n';
    public static final byte Dir_spr__lnx = 47;
    public static final byte Dir_spr__wnt = 92;
    public static final Op_sys Lnx = Op_sys.new_unx_flavor_((byte)2, "linux", (byte)1);
    public static final Op_sys Osx = Op_sys.new_unx_flavor_((byte)3, "macosx", (byte)1);
    public static final Op_sys Drd = Op_sys.new_unx_flavor_((byte)4, "android", (byte)1);
    public static final Op_sys Wnt = Op_sys.new_wnt_((byte)0, (byte)1);
    static Op_sys cur_op_sys = Op_sys.new_auto_identify_();
    static final String GRP_KEY = "gplx.op_sys";

    Op_sys(byte by, byte by2, String string, byte by3, String string2, byte by4, boolean bl) {
        this.tid = by;
        this.sub_tid = by2;
        this.os_name = string;
        this.bitness = by3;
        this.nl_str = string2;
        this.fsys_dir_spr_byte = by4;
        this.fsys_dir_spr_str = Char_.To_str((char)by4);
        this.fsys_case_match = bl;
    }

    public byte Tid() {
        return this.tid;
    }

    public byte Sub_tid() {
        return this.sub_tid;
    }

    public String Os_name() {
        return this.os_name;
    }

    public byte Bitness() {
        return this.bitness;
    }

    public String Bitness_str() {
        return this.bitness == 1 ? "32" : "64";
    }

    public String Nl_str() {
        return this.nl_str;
    }

    public String Fsys_dir_spr_str() {
        return this.fsys_dir_spr_str;
    }

    public byte Fsys_dir_spr_byte() {
        return this.fsys_dir_spr_byte;
    }

    public String Fsys_http_frag_to_url_str(String string) {
        return this.fsys_dir_spr_byte == 47 ? string : String_.Replace(string, Lnx.Fsys_dir_spr_str(), this.fsys_dir_spr_str);
    }

    public boolean Fsys_case_match() {
        return this.fsys_case_match;
    }

    public String Fsys_case_match_str(String string) {
        return String_.CaseNormalize(this.fsys_case_match, string);
    }

    public boolean Tid_is_wnt() {
        return this.tid == 1;
    }

    public boolean Tid_is_lnx() {
        return this.tid == 2;
    }

    public boolean Tid_is_osx() {
        return this.tid == 3;
    }

    public boolean Tid_is_drd() {
        return this.tid == 4;
    }

    public String To_str() {
        return this.os_name + this.Bitness_str();
    }

    public static Op_sys Cur() {
        return cur_op_sys;
    }

    public static String Fsys_path_to_lnx(String string) {
        return cur_op_sys.Tid_is_wnt() ? String_.Replace(string, Op_sys.Wnt.fsys_dir_spr_str, Op_sys.Lnx.fsys_dir_spr_str) : string;
    }

    public static String Fsys_path_to_wnt(String string) {
        return cur_op_sys.Tid_is_wnt() ? String_.Replace(string, Op_sys.Lnx.fsys_dir_spr_str, Op_sys.Wnt.fsys_dir_spr_str) : string;
    }

    private static Op_sys new_wnt_(byte by, byte by2) {
        return new Op_sys(1, by2, "windows", by, "\r\n", 92, false);
    }

    private static Op_sys new_unx_flavor_(byte by, String string, byte by2) {
        return new Op_sys(by, 0, string, by2, "\n", 47, true);
    }

    public static void Cur_(int n) {
        switch (n) {
            case 1: {
                cur_op_sys = Wnt;
                break;
            }
            case 2: {
                cur_op_sys = Lnx;
                break;
            }
            case 3: {
                cur_op_sys = Osx;
                break;
            }
            case 4: {
                cur_op_sys = Drd;
                break;
            }
            default: {
                throw Err_.new_unhandled_default(n);
            }
        }
    }

    static Op_sys new_auto_identify_() {
        String string = "";
        try {
            String string2 = System.getProperty("sun.arch.data.model");
            if (string2 == null) {
                return Drd;
            }
            string2 = string2.toLowerCase();
            byte by = 1;
            if (String_.Eq(string2, "32")) {
                by = 1;
            } else if (String_.Eq(string2, "64")) {
                by = 2;
            } else {
                throw Err_.new_wo_type("unknown bitness; expecting 32 or 64; System.getProperty(\"bit.level\")", "val", string2);
            }
            string = System.getProperty("os.name").toLowerCase();
            String string3 = System.getProperty("os.arch").toLowerCase();
            if (String_.Eq(string3, "arm")) {
                return Op_sys.new_unx_flavor_((byte)5, string, by);
            }
            if (String_.Has_at_bgn(string, "win")) {
                String string4 = System.getProperty("os.version").toLowerCase();
                int n = 0;
                if (String_.Eq(string, "windows xp") && String_.Eq(string4, "5.1")) {
                    n = 1;
                } else if (String_.Eq(string, "windows 7") && String_.Eq(string4, "6.1")) {
                    n = 2;
                } else if (String_.Eq(string, "windows 8")) {
                    n = 3;
                }
                return Op_sys.new_wnt_(by, (byte)n);
            }
            if (String_.Eq(string, "linux")) {
                return Op_sys.new_unx_flavor_((byte)2, string, by);
            }
            if (String_.Has_at_bgn(string, "mac")) {
                return Op_sys.new_unx_flavor_((byte)3, string, by);
            }
            throw Err_.new_wo_type("unknown os_name; expecting windows, linux, mac; System.getProperty(\"os.name\")", "val", string);
        }
        catch (Exception exception) {
            Op_sys.Drd.os_name = string;
            return Drd;
        }
    }

    public static void Cur_is_drd_() {
        cur_op_sys = Drd;
    }
}

