/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.criterias;

import gplx.Array_;
import gplx.Err_;
import gplx.core.criterias.Criteria;
import gplx.core.criterias.Criteria_and;
import gplx.core.criterias.Criteria_between;
import gplx.core.criterias.Criteria_comp;
import gplx.core.criterias.Criteria_const;
import gplx.core.criterias.Criteria_eq;
import gplx.core.criterias.Criteria_in;
import gplx.core.criterias.Criteria_like;
import gplx.core.criterias.Criteria_not;
import gplx.core.criterias.Criteria_or;
import gplx.core.texts.RegxPatn_cls_like_;

public class Criteria_ {
    public static final Criteria All = new Criteria_const(true);
    public static final Criteria None = new Criteria_const(false);
    public static final byte Tid_custom = 0;
    public static final byte Tid_const = 1;
    public static final byte Tid_not = 2;
    public static final byte Tid_and = 3;
    public static final byte Tid_or = 4;
    public static final byte Tid_eq = 5;
    public static final byte Tid_between = 6;
    public static final byte Tid_in = 7;
    public static final byte Tid_like = 8;
    public static final byte Tid_comp = 9;
    public static final byte Tid_wrapper = 10;
    public static final byte Tid_iomatch = 11;
    public static final byte Tid_db_obj_ary = 12;

    public static Criteria Not(Criteria criteria) {
        return new Criteria_not(criteria);
    }

    public static Criteria And(Criteria criteria, Criteria criteria2) {
        return new Criteria_and(criteria, criteria2);
    }

    public static Criteria And_many(Criteria ... criteriaArray) {
        int n = Array_.Len(criteriaArray);
        if (n == 0) {
            throw Err_.new_wo_type("cannot AND 0 criterias;", new Object[0]);
        }
        Criteria criteria = criteriaArray[0];
        for (int i = 1; i < n; ++i) {
            criteria = Criteria_.And(criteria, criteriaArray[i]);
        }
        return criteria;
    }

    public static Criteria Or(Criteria criteria, Criteria criteria2) {
        return new Criteria_or(criteria, criteria2);
    }

    public static Criteria Or_many(Criteria ... criteriaArray) {
        int n = Array_.Len(criteriaArray);
        if (n == 0) {
            throw Err_.new_wo_type("cannot OR 0 criterias;", new Object[0]);
        }
        Criteria criteria = criteriaArray[0];
        for (int i = 1; i < n; ++i) {
            criteria = Criteria_.Or(criteria, criteriaArray[i]);
        }
        return criteria;
    }

    public static Criteria eq_(Object object) {
        return new Criteria_eq(false, object);
    }

    public static Criteria eqn_(Object object) {
        return new Criteria_eq(true, object);
    }

    public static Criteria in_(Object ... objectArray) {
        return new Criteria_in(false, objectArray);
    }

    public static Criteria inn_(Object ... objectArray) {
        return new Criteria_in(true, objectArray);
    }

    public static Criteria lt_(Comparable comparable) {
        return new Criteria_comp(-1, comparable);
    }

    public static Criteria lte_(Comparable comparable) {
        return new Criteria_comp(-2, comparable);
    }

    public static Criteria mt_(Comparable comparable) {
        return new Criteria_comp(1, comparable);
    }

    public static Criteria mte_(Comparable comparable) {
        return new Criteria_comp(2, comparable);
    }

    public static Criteria between_(Comparable comparable, Comparable comparable2) {
        return new Criteria_between(false, comparable, comparable2);
    }

    public static Criteria between_(boolean bl, Comparable comparable, Comparable comparable2) {
        return new Criteria_between(bl, comparable, comparable2);
    }

    public static Criteria like_(String string) {
        return new Criteria_like(false, RegxPatn_cls_like_.parse(string, '|'));
    }

    public static Criteria liken_(String string) {
        return new Criteria_like(true, RegxPatn_cls_like_.parse(string, '|'));
    }
}

