/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.consoles;

import gplx.Bry_;
import gplx.Err_;
import gplx.String_;
import gplx.core.consoles.Console_adp;
import gplx.core.envs.Env_;
import gplx.core.envs.Op_sys;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class Console_adp__sys
implements Console_adp {
    private String tmp_txt;
    private boolean canceled = false;
    int chars_per_line_max = 80;
    private boolean backspace_by_bytes = Op_sys.Cur().Tid_is_lnx();
    public static final Console_adp__sys Instance = new Console_adp__sys();

    @Override
    public boolean Enabled() {
        return true;
    }

    public boolean Canceled() {
        return this.canceled;
    }

    public void Canceled_set(boolean bl) {
        this.canceled = bl;
    }

    @Override
    public boolean Canceled_chk() {
        if (this.canceled) {
            throw Err_.new_op_canceled();
        }
        return this.canceled;
    }

    @Override
    public int Chars_per_line_max() {
        return this.chars_per_line_max;
    }

    @Override
    public void Chars_per_line_max_(int n) {
        this.chars_per_line_max = n;
    }

    public boolean Backspace_by_bytes() {
        return this.backspace_by_bytes;
    }

    public Console_adp__sys Backspace_by_bytes_(boolean bl) {
        this.backspace_by_bytes = bl;
        return this;
    }

    @Override
    public void Write_str(String string) {
        this.Clear_tmp();
        this.Write_str_lang(string);
    }

    public void Write_str_w_nl(String string) {
        this.Clear_tmp();
        this.Write_str_w_nl_lang(string);
    }

    @Override
    public void Write_fmt_w_nl(String string, Object ... objectArray) {
        this.Clear_tmp();
        this.Write_str_w_nl_lang(String_.Format(string, objectArray));
    }

    @Override
    public char Read_key(String string) {
        this.Write_str(string);
        return this.Read_key_lang();
    }

    @Override
    public String Read_line(String string) {
        this.Write_str(string);
        return this.Read_line_lang();
    }

    @Override
    public void Write_tmp(String string) {
        this.Clear_tmp();
        if (String_.Has(string, "\r")) {
            string = String_.Replace(string, "\r", " ");
        }
        if (String_.Has(string, "\n")) {
            string = String_.Replace(string, "\n", " ");
        }
        if (String_.Len(string) >= this.chars_per_line_max) {
            string = String_.Mid(string, 0, this.chars_per_line_max - String_.Len("...") - 1) + "...";
        }
        this.tmp_txt = string;
        this.Write_str_lang(string);
    }

    private void Clear_tmp() {
        if (this.tmp_txt == null) {
            return;
        }
        if (Env_.Mode_debug()) {
            this.Write_str_lang("\r\n");
            return;
        }
        int n = this.backspace_by_bytes ? Bry_.new_u8(this.tmp_txt).length : String_.Len(this.tmp_txt);
        String string = String_.Repeat("\b", n);
        this.Write_str_lang(string);
        this.Write_str_lang(String_.Repeat(" ", n));
        this.Write_str_lang(string);
        this.tmp_txt = null;
    }

    private void Write_str_lang(String string) {
        System.out.print(string);
    }

    private void Write_str_w_nl_lang(String string) {
        System.out.println(string);
    }

    private String Read_line_lang() {
        return System.console() == null ? "" : System.console().readLine();
    }

    private char Read_key_lang() {
        String string = this.Read_line_lang();
        return String_.Len(string) == 0 ? (char)'\u0000' : String_.CharAt(string, 0);
    }

    public void Write_str_w_nl_utf8(String string) {
        PrintStream printStream;
        try {
            printStream = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw Err_.new_wo_type("unsupported exception", new Object[0]);
        }
        printStream.println(string);
    }
}

