/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.brys;

import gplx.Bry_;
import gplx.Bry_find_;
import gplx.Byte_;
import gplx.Byte_ascii;
import gplx.Double_;
import gplx.String_;
import gplx.Virtual;
import gplx.core.brys.Bry_err_wkr;
import gplx.core.btries.Btrie_rv;
import gplx.core.btries.Btrie_slim_mgr;
import gplx.core.encoders.Gfo_hzip_int_;
import gplx.core.primitives.Byte_obj_val;
import gplx.core.primitives.Int_obj_ref;

public class Bry_rdr {
    private final Int_obj_ref pos_ref = Int_obj_ref.New_neg1();
    private final Btrie_rv trv = new Btrie_rv();
    protected byte[] src;
    protected int src_end;
    protected int pos;
    private byte dflt_dlm;
    private Bry_err_wkr err_wkr = new Bry_err_wkr();
    private static final int Fail_if_missing = Integer.MIN_VALUE;

    public byte[] Src() {
        return this.src;
    }

    public int Src_end() {
        return this.src_end;
    }

    public int Pos() {
        return this.pos;
    }

    public boolean Pos_is_eos() {
        return this.pos == this.src_end;
    }

    public Bry_rdr Dflt_dlm_(byte by) {
        this.dflt_dlm = by;
        return this;
    }

    public Bry_rdr Fail_throws_err_(boolean bl) {
        this.err_wkr.Fail_throws_err_(bl);
        return this;
    }

    public Bry_rdr Init_by_src(byte[] byArray) {
        this.err_wkr.Init_by_page("", byArray);
        this.pos = 0;
        this.src = byArray;
        this.src_end = byArray.length;
        return this;
    }

    public Bry_rdr Init_by_page(byte[] byArray, byte[] byArray2, int n) {
        this.err_wkr.Init_by_page(String_.new_u8(byArray), byArray2);
        this.pos = 0;
        this.src = byArray2;
        this.src_end = n;
        return this;
    }

    public Bry_rdr Init_by_sect(String string, int n, int n2) {
        this.err_wkr.Init_by_sect(string, n);
        this.pos = n2;
        return this;
    }

    public Bry_rdr Init_by_wkr(Bry_err_wkr bry_err_wkr, String string, int n, int n2) {
        this.pos = n;
        this.src = bry_err_wkr.Src();
        this.src_end = n2;
        this.err_wkr.Init_by_page(bry_err_wkr.Page(), this.src);
        this.err_wkr.Init_by_sect(string, n);
        return this;
    }

    public Bry_err_wkr Err_wkr() {
        return this.err_wkr;
    }

    public int Move_to(int n) {
        this.pos = n;
        return this.pos;
    }

    public int Move_by_one() {
        return this.Move_by(1);
    }

    public int Move_by(int n) {
        this.pos += n;
        return this.pos;
    }

    public int Find_fwd_lr() {
        return this.Find_fwd(this.dflt_dlm, true, false, Integer.MIN_VALUE);
    }

    public int Find_fwd_lr(byte by) {
        return this.Find_fwd(by, true, false, Integer.MIN_VALUE);
    }

    public int Find_fwd_lr_or(byte by, int n) {
        return this.Find_fwd(by, true, false, n);
    }

    public int Find_fwd_lr(byte[] byArray) {
        return this.Find_fwd(byArray, true, false, Integer.MIN_VALUE);
    }

    public int Find_fwd_rr() {
        return this.Find_fwd(this.dflt_dlm, false, false, Integer.MIN_VALUE);
    }

    public int Find_fwd_rr(byte by) {
        return this.Find_fwd(by, false, false, Integer.MIN_VALUE);
    }

    public int Find_fwd_rr(byte[] byArray) {
        return this.Find_fwd(byArray, false, false, Integer.MIN_VALUE);
    }

    public int Find_fwd_rr_or(byte[] byArray, int n) {
        return this.Find_fwd(byArray, false, false, n);
    }

    private int Find_fwd(byte by, boolean bl, boolean bl2, int n) {
        int n2 = Bry_find_.Find_fwd(this.src, by, this.pos, this.src_end);
        if (n2 == -1) {
            if (n == Integer.MIN_VALUE) {
                this.err_wkr.Fail("find failed", "find", Byte_ascii.To_str(by));
                return -1;
            }
            return n;
        }
        this.pos = n2 + (bl2 ? 0 : 1);
        return bl ? n2 : this.pos;
    }

    private int Find_fwd(byte[] byArray, boolean bl, boolean bl2, int n) {
        int n2 = Bry_find_.Find_fwd(this.src, byArray, this.pos, this.src_end);
        if (n2 == -1) {
            if (n == Integer.MIN_VALUE) {
                this.err_wkr.Fail("find failed", "find", String_.new_u8(byArray));
                return -1;
            }
            return n;
        }
        this.pos = n2 + (bl2 ? 0 : byArray.length);
        return bl ? n2 : this.pos;
    }

    public byte Read_byte() {
        byte by = this.src[this.pos];
        ++this.pos;
        return by;
    }

    public byte Read_byte_to() {
        return this.Read_byte_to(this.dflt_dlm);
    }

    public byte Read_byte_to(byte by) {
        byte by2 = this.src[this.pos];
        ++this.pos;
        if (this.pos < this.src_end) {
            if (this.src[this.pos] != by) {
                this.err_wkr.Fail("read byte to failed", "to", Byte_ascii.To_str(by));
                return 127;
            }
            ++this.pos;
        }
        return by2;
    }

    public double Read_double_to() {
        return this.Read_double_to(this.dflt_dlm);
    }

    public double Read_double_to(byte by) {
        byte[] byArray = this.Read_bry_to(by);
        return Double_.parse(String_.new_a7(byArray));
    }

    public int Read_int_to() {
        return this.Read_int_to(this.dflt_dlm);
    }

    public int Read_int_to_non_num() {
        return this.Read_int_to((byte)0);
    }

    public int Read_int_to(byte by) {
        int n = this.pos;
        int n2 = 0;
        int n3 = 1;
        block4: while (this.pos < this.src_end) {
            boolean bl;
            byte by2 = this.src[this.pos++];
            switch (by2) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    n2 = n2 * 10 + (by2 - 48);
                    continue block4;
                }
                case 45: {
                    if (n3 == -1) {
                        this.err_wkr.Fail("invalid int", "mid", String_.new_u8(this.src, n, this.pos));
                        return Integer.MIN_VALUE;
                    }
                    n3 = -1;
                    continue block4;
                }
            }
            boolean bl2 = bl = by2 == by;
            if (by == 0) {
                --this.pos;
                bl = true;
            }
            if (!bl) {
                this.err_wkr.Fail("invalid int", "mid", String_.new_u8(this.src, n, this.pos));
                return Integer.MIN_VALUE;
            }
            return n2 * n3;
        }
        if (n == this.pos) {
            this.err_wkr.Fail("int is empty", new Object[0]);
            return Integer.MIN_VALUE;
        }
        return n2 * n3;
    }

    public int Read_hzip_int(int n) {
        int n2 = Gfo_hzip_int_.Decode(n, this.src, this.src_end, this.pos, this.pos_ref);
        this.pos = this.pos_ref.Val();
        return n2;
    }

    public byte[] Read_bry_to() {
        return this.Read_bry_to(this.dflt_dlm);
    }

    public byte[] Read_bry_to(byte by) {
        int n = this.pos;
        return Bry_.Mid(this.src, n, this.Find_fwd_lr(by));
    }

    public boolean Is(byte by) {
        boolean bl;
        boolean bl2 = bl = this.src[this.pos] == by;
        if (bl) {
            ++this.pos;
        }
        return bl;
    }

    public boolean Is(byte[] byArray) {
        int n = byArray.length;
        int n2 = this.pos + n;
        boolean bl = Bry_.Match(this.src, this.pos, n2, byArray, 0, n);
        if (bl) {
            this.pos = n2;
        }
        return bl;
    }

    public int Chk(byte by) {
        if (this.src[this.pos] != by) {
            this.err_wkr.Fail("failed check", "chk", Byte_.To_str(by));
            return -1;
        }
        ++this.pos;
        return this.pos;
    }

    public int Chk(byte[] byArray) {
        int n = this.pos + byArray.length;
        if (!Bry_.Match(this.src, this.pos, n, byArray)) {
            this.err_wkr.Fail("failed check", "chk", String_.new_u8(byArray));
            return -1;
        }
        this.pos = n;
        return this.pos;
    }

    public byte Chk(Btrie_slim_mgr btrie_slim_mgr) {
        return this.Chk(btrie_slim_mgr, this.pos, this.src_end);
    }

    public void Chk_trie_val(Btrie_slim_mgr btrie_slim_mgr, byte by) {
        byte by2 = this.Chk_or(btrie_slim_mgr, (byte)127);
        if (by2 == 127) {
            this.err_wkr.Fail("failed trie check", "mid", String_.new_u8(Bry_.Mid_by_len_safe(this.src, this.pos, 16)));
        }
    }

    public Object Chk_trie_as_obj(Btrie_rv btrie_rv, Btrie_slim_mgr btrie_slim_mgr) {
        Object object = btrie_slim_mgr.Match_at(btrie_rv, this.src, this.pos, this.src_end);
        if (object == null) {
            this.err_wkr.Fail("failed trie check", "mid", String_.new_u8(Bry_.Mid_by_len_safe(this.src, this.pos, 16)));
        }
        return object;
    }

    public byte Chk_or(Btrie_rv btrie_rv, Btrie_slim_mgr btrie_slim_mgr, byte by) {
        Object object = btrie_slim_mgr.Match_at(btrie_rv, this.src, this.pos, this.src_end);
        return object == null ? by : ((Byte_obj_val)object).Val();
    }

    public byte Chk_or(Btrie_slim_mgr btrie_slim_mgr, byte by) {
        return this.Chk_or(btrie_slim_mgr, this.pos, this.src_end, by);
    }

    public byte Chk(Btrie_slim_mgr btrie_slim_mgr, int n, int n2) {
        byte by = this.Chk_or(btrie_slim_mgr, n, n2, (byte)127);
        if (by == 127) {
            this.err_wkr.Fail("failed trie check", "mid", String_.new_u8(Bry_.Mid_by_len_safe(this.src, this.pos, 16)));
            return 127;
        }
        return by;
    }

    public byte Chk_or(Btrie_slim_mgr btrie_slim_mgr, int n, int n2, byte by) {
        Object object = btrie_slim_mgr.Match_at(this.trv, this.src, n, n2);
        if (object == null) {
            return by;
        }
        this.pos = this.trv.Pos();
        return ((Byte_obj_val)object).Val();
    }

    @Virtual
    public Bry_rdr Skip_ws() {
        block3: while (this.pos < this.src_end) {
            switch (this.src[this.pos]) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    ++this.pos;
                    continue block3;
                }
            }
            return this;
        }
        return this;
    }

    public Bry_rdr Skip_alpha_num_under() {
        block3: while (this.pos < this.src_end) {
            switch (this.src[this.pos]) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    ++this.pos;
                    continue block3;
                }
            }
            return this;
        }
        return this;
    }
}

