/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.tidy.Clean;
import org.w3c.tidy.Configuration;
import org.w3c.tidy.DOMDocumentImpl;
import org.w3c.tidy.DOMNodeImpl;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.Node;
import org.w3c.tidy.Out;
import org.w3c.tidy.OutFactory;
import org.w3c.tidy.PPrint;
import org.w3c.tidy.ParsePropertyImpl;
import org.w3c.tidy.ParserImpl;
import org.w3c.tidy.Report;
import org.w3c.tidy.StreamIn;
import org.w3c.tidy.StreamInFactory;
import org.w3c.tidy.TagTable;
import org.w3c.tidy.TidyMessageListener;
import org.w3c.tidy.TidyUtils;

public class Tidy
implements Serializable {
    static final long serialVersionUID = -2794371560623987718L;
    private static final Map CMDLINE_ALIAS = new HashMap();
    private PrintWriter errout;
    private PrintWriter stderr;
    private Configuration configuration;
    private String inputStreamName = "InputStream";
    private int parseErrors;
    private int parseWarnings;
    private Report report = new Report();

    public Tidy() {
        this.configuration = new Configuration(this.report);
        TagTable tagTable = new TagTable();
        tagTable.setConfiguration(this.configuration);
        this.configuration.tt = tagTable;
        this.configuration.errfile = null;
        this.errout = this.stderr = new PrintWriter(System.err, true);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public PrintWriter getStderr() {
        return this.stderr;
    }

    public int getParseErrors() {
        return this.parseErrors;
    }

    public int getParseWarnings() {
        return this.parseWarnings;
    }

    public void setInputStreamName(String string) {
        if (string != null) {
            this.inputStreamName = string;
        }
    }

    public String getInputStreamName() {
        return this.inputStreamName;
    }

    public PrintWriter getErrout() {
        return this.errout;
    }

    public void setErrout(PrintWriter printWriter) {
        this.errout = printWriter;
    }

    public void setConfigurationFromFile(String string) {
        this.configuration.parseFile(string);
    }

    public void setConfigurationFromProps(Properties properties) {
        this.configuration.addProps(properties);
    }

    public static Document createEmptyDocument() {
        Node node = new Node(0, new byte[0], 0, 0);
        Node node2 = new Node(5, new byte[0], 0, 0, "html", new TagTable());
        if (node != null && node2 != null) {
            node.insertNodeAtStart(node2);
            return (Document)node.getAdapter();
        }
        return null;
    }

    public Node parse(InputStream inputStream, OutputStream outputStream) {
        StreamIn streamIn = StreamInFactory.getStreamIn(this.configuration, inputStream);
        Out out = null;
        if (outputStream != null) {
            out = OutFactory.getOut(this.configuration, outputStream);
        }
        return this.parse(streamIn, out);
    }

    public Node parse(Reader reader, OutputStream outputStream) {
        StreamIn streamIn = StreamInFactory.getStreamIn(this.configuration, reader);
        Out out = null;
        if (outputStream != null) {
            out = OutFactory.getOut(this.configuration, outputStream);
        }
        return this.parse(streamIn, out);
    }

    public Node parse(Reader reader, Writer writer) {
        StreamIn streamIn = StreamInFactory.getStreamIn(this.configuration, reader);
        Out out = null;
        if (writer != null) {
            out = OutFactory.getOut(this.configuration, writer);
        }
        return this.parse(streamIn, out);
    }

    public Node parse(InputStream inputStream, Writer writer) {
        StreamIn streamIn = StreamInFactory.getStreamIn(this.configuration, inputStream);
        Out out = null;
        if (writer != null) {
            out = OutFactory.getOut(this.configuration, writer);
        }
        return this.parse(streamIn, out);
    }

    public Document parseDOM(InputStream inputStream, OutputStream outputStream) {
        Node node = this.parse(inputStream, outputStream);
        if (node != null) {
            return (Document)node.getAdapter();
        }
        return null;
    }

    public Document parseDOM(Reader reader, Writer writer) {
        Node node = this.parse(reader, writer);
        if (node != null) {
            return (Document)node.getAdapter();
        }
        return null;
    }

    public void pprint(Document document, OutputStream outputStream) {
        if (!(document instanceof DOMDocumentImpl)) {
            return;
        }
        this.pprint(((DOMDocumentImpl)document).adaptee, outputStream);
    }

    public void pprint(org.w3c.dom.Node node, OutputStream outputStream) {
        if (!(node instanceof DOMNodeImpl)) {
            return;
        }
        this.pprint(((DOMNodeImpl)node).adaptee, outputStream);
    }

    private Node parse(StreamIn streamIn, Out out) {
        Node node;
        Object object;
        Node node2 = null;
        if (this.errout == null) {
            return null;
        }
        this.configuration.adjust();
        this.configuration.tt.freeAnchors();
        this.parseErrors = 0;
        this.parseWarnings = 0;
        Lexer lexer = new Lexer(streamIn, this.configuration, this.report);
        lexer.errout = this.errout;
        streamIn.setLexer(lexer);
        this.report.setFilename(this.inputStreamName);
        if (this.configuration.xmlTags) {
            node2 = ParserImpl.parseXMLDocument(lexer);
            if (!node2.checkNodeIntegrity()) {
                if (!this.configuration.quiet) {
                    this.report.badTree(this.errout);
                }
                return null;
            }
        } else {
            lexer.warnings = 0;
            node2 = ParserImpl.parseDocument(lexer);
            if (!node2.checkNodeIntegrity()) {
                if (!this.configuration.quiet) {
                    this.report.badTree(this.errout);
                }
                return null;
            }
            object = new Clean(this.configuration.tt);
            ((Clean)object).nestedEmphasis(node2);
            ((Clean)object).list2BQ(node2);
            ((Clean)object).bQ2Div(node2);
            if (this.configuration.logicalEmphasis) {
                ((Clean)object).emFromI(node2);
            }
            if (this.configuration.word2000 && ((Clean)object).isWord2000(node2)) {
                ((Clean)object).dropSections(lexer, node2);
                ((Clean)object).cleanWord2000(lexer, node2);
                Node.dropEmptyElements(lexer, node2);
            }
            if (this.configuration.makeClean || this.configuration.dropFontTags) {
                ((Clean)object).cleanTree(lexer, node2);
            }
            if (!node2.checkNodeIntegrity()) {
                this.report.badTree(this.errout);
                return null;
            }
            node = node2.findDocType();
            if (node != null) {
                node = node.cloneNode(false);
            }
            if (node2.content != null) {
                if (this.configuration.xHTML) {
                    lexer.setXHTMLDocType(node2);
                } else {
                    lexer.fixDocType(node2);
                }
                if (this.configuration.tidyMark) {
                    lexer.addGenerator(node2);
                }
            }
            if (this.configuration.xmlOut && this.configuration.xmlPi) {
                lexer.fixXmlDecl(node2);
            }
            if (!this.configuration.quiet && node2.content != null) {
                this.report.reportVersion(this.errout, lexer, this.inputStreamName, node);
            }
        }
        if (!this.configuration.quiet) {
            this.parseWarnings = lexer.warnings;
            this.parseErrors = lexer.errors;
            this.report.reportNumWarnings(this.errout, lexer);
        }
        if (!this.configuration.quiet && lexer.errors > 0 && !this.configuration.forceOutput) {
            this.report.needsAuthorIntervention(this.errout);
        }
        if (!this.configuration.onlyErrors && (lexer.errors == 0 || this.configuration.forceOutput)) {
            if (this.configuration.burstSlides) {
                object = null;
                node = node2.findDocType();
                if (node != null) {
                    Node.discardElement(node);
                }
                lexer.versions = (short)(lexer.versions | 8);
                if (this.configuration.xHTML) {
                    lexer.setXHTMLDocType(node2);
                } else {
                    lexer.fixDocType(node2);
                }
                object = node2.findBody(this.configuration.tt);
                if (object != null) {
                    PPrint pPrint = new PPrint(this.configuration);
                    if (!this.configuration.quiet) {
                        this.report.reportNumberOfSlides(this.errout, pPrint.countSlides((Node)object));
                    }
                    pPrint.createSlides(lexer, node2);
                } else if (!this.configuration.quiet) {
                    this.report.missingBody(this.errout);
                }
            } else if (out != null) {
                PPrint pPrint = new PPrint(this.configuration);
                if (node2.findDocType() == null) {
                    this.configuration.numEntities = true;
                }
                if (this.configuration.bodyOnly) {
                    pPrint.printBody(out, lexer, node2, this.configuration.xmlOut);
                } else if (this.configuration.xmlOut && !this.configuration.xHTML) {
                    pPrint.printXMLTree(out, (short)0, 0, lexer, node2);
                } else {
                    pPrint.printTree(out, (short)0, 0, lexer, node2);
                }
                pPrint.flushLine(out, 0);
                out.flush();
            }
        }
        if (!this.configuration.quiet) {
            this.report.errorSummary(lexer);
        }
        this.configuration.tt.freeAnchors();
        return node2;
    }

    private Node parse(InputStream inputStream, String string, OutputStream outputStream) throws FileNotFoundException, IOException {
        Out out = null;
        boolean bl = false;
        boolean bl2 = false;
        if (string != null) {
            inputStream = new FileInputStream(string);
            bl = true;
            this.inputStreamName = string;
        } else if (inputStream == null) {
            inputStream = System.in;
            this.inputStreamName = "stdin";
        }
        StreamIn streamIn = StreamInFactory.getStreamIn(this.configuration, inputStream);
        if (this.configuration.writeback && string != null) {
            outputStream = new FileOutputStream(string);
            bl2 = true;
        }
        if (outputStream != null) {
            out = OutFactory.getOut(this.configuration, outputStream);
        }
        Node node = this.parse(streamIn, out);
        if (bl) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (bl2) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return node;
    }

    private void pprint(Node node, OutputStream outputStream) {
        if (outputStream != null) {
            Out out = OutFactory.getOut(this.configuration, outputStream);
            Lexer lexer = new Lexer(null, this.configuration, this.report);
            PPrint pPrint = new PPrint(this.configuration);
            if (this.configuration.xmlTags) {
                pPrint.printXMLTree(out, (short)0, 0, lexer, node);
            } else {
                pPrint.printTree(out, (short)0, 0, lexer, node);
            }
            pPrint.flushLine(out, 0);
            out.flush();
        }
    }

    public static void main(String[] stringArray) {
        Tidy tidy = new Tidy();
        int n = tidy.mainExec(stringArray);
        System.exit(n);
    }

    protected int mainExec(String[] stringArray) {
        int n = stringArray.length;
        int n2 = 0;
        Properties properties = new Properties();
        while (n > 0) {
            String string;
            if (stringArray[n2].startsWith("-")) {
                String string2;
                string = stringArray[n2].toLowerCase();
                while (string.length() > 0 && string.charAt(0) == '-') {
                    string = string.substring(1);
                }
                if (string.equals("help") || string.equals("h") || string.equals("?")) {
                    this.report.helpText(new PrintWriter(System.out, true));
                    return 0;
                }
                if (string.equals("help-config")) {
                    this.configuration.printConfigOptions(new PrintWriter(System.out, true), false);
                    return 0;
                }
                if (string.equals("show-config")) {
                    this.configuration.adjust();
                    this.configuration.printConfigOptions(this.errout, true);
                    return 0;
                }
                if (string.equals("version") || string.equals("v")) {
                    this.report.showVersion(this.errout);
                    return 0;
                }
                String string3 = null;
                if (n > 2 && !stringArray[n2 + 1].startsWith("-")) {
                    string3 = stringArray[n2 + 1];
                    --n;
                    ++n2;
                }
                if ((string2 = (String)CMDLINE_ALIAS.get(string)) != null) {
                    string = string2;
                }
                if (Configuration.isKnownOption(string)) {
                    properties.setProperty(string, string3 == null ? "" : string3);
                } else if (string.equals("config")) {
                    if (string3 != null) {
                        this.configuration.parseFile(string3);
                    }
                } else if (TidyUtils.isCharEncodingSupported(string)) {
                    properties.setProperty("char-encoding", string);
                } else {
                    block18: for (int i = 0; i < string.length(); ++i) {
                        switch (string.charAt(i)) {
                            case 'i': {
                                this.configuration.indentContent = true;
                                this.configuration.smartIndent = true;
                                continue block18;
                            }
                            case 'o': {
                                this.configuration.hideEndTags = true;
                                continue block18;
                            }
                            case 'u': {
                                this.configuration.upperCaseTags = true;
                                continue block18;
                            }
                            case 'c': {
                                this.configuration.makeClean = true;
                                continue block18;
                            }
                            case 'b': {
                                this.configuration.makeBare = true;
                                continue block18;
                            }
                            case 'n': {
                                this.configuration.numEntities = true;
                                continue block18;
                            }
                            case 'm': {
                                this.configuration.writeback = true;
                                continue block18;
                            }
                            case 'e': {
                                this.configuration.onlyErrors = true;
                                continue block18;
                            }
                            case 'q': {
                                this.configuration.quiet = true;
                                continue block18;
                            }
                            default: {
                                this.report.unknownOption(this.errout, string.charAt(i));
                            }
                        }
                    }
                }
                --n;
                ++n2;
                continue;
            }
            this.configuration.addProps(properties);
            this.configuration.adjust();
            if (this.configuration.errfile != null && !this.configuration.errfile.equals(string = "stderr")) {
                if (this.errout != this.stderr) {
                    this.errout.close();
                }
                try {
                    this.setErrout(new PrintWriter((Writer)new FileWriter(this.configuration.errfile), true));
                    string = this.configuration.errfile;
                }
                catch (IOException iOException) {
                    string = "stderr";
                    this.setErrout(this.stderr);
                }
            }
            String string4 = n > 0 ? stringArray[n2] : "stdin";
            try {
                this.parse(null, string4, System.out);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.report.unknownFile(this.errout, string4);
            }
            catch (IOException iOException) {
                this.report.unknownFile(this.errout, string4);
            }
            ++n2;
            if (--n > 0) continue;
        }
        if (this.parseErrors + this.parseWarnings > 0 && !this.configuration.quiet) {
            this.report.generalInfo(this.errout);
        }
        if (this.errout != this.stderr) {
            this.errout.close();
        }
        if (this.parseErrors > 0) {
            return 2;
        }
        if (this.parseWarnings > 0) {
            return 1;
        }
        return 0;
    }

    public void setMessageListener(TidyMessageListener tidyMessageListener) {
        this.report.addMessageListener(tidyMessageListener);
    }

    public void setSpaces(int n) {
        this.configuration.spaces = n;
    }

    public int getSpaces() {
        return this.configuration.spaces;
    }

    public void setWraplen(int n) {
        this.configuration.wraplen = n;
    }

    public int getWraplen() {
        return this.configuration.wraplen;
    }

    public void setTabsize(int n) {
        this.configuration.tabsize = n;
    }

    public int getTabsize() {
        return this.configuration.tabsize;
    }

    public void setErrfile(String string) {
        this.configuration.errfile = string;
    }

    public String getErrfile() {
        return this.configuration.errfile;
    }

    public void setWriteback(boolean bl) {
        this.configuration.writeback = bl;
    }

    public boolean getWriteback() {
        return this.configuration.writeback;
    }

    public void setOnlyErrors(boolean bl) {
        this.configuration.onlyErrors = bl;
    }

    public boolean getOnlyErrors() {
        return this.configuration.onlyErrors;
    }

    public void setShowWarnings(boolean bl) {
        this.configuration.showWarnings = bl;
    }

    public boolean getShowWarnings() {
        return this.configuration.showWarnings;
    }

    public void setQuiet(boolean bl) {
        this.configuration.quiet = bl;
    }

    public boolean getQuiet() {
        return this.configuration.quiet;
    }

    public void setIndentContent(boolean bl) {
        this.configuration.indentContent = bl;
    }

    public boolean getIndentContent() {
        return this.configuration.indentContent;
    }

    public void setSmartIndent(boolean bl) {
        this.configuration.smartIndent = bl;
    }

    public boolean getSmartIndent() {
        return this.configuration.smartIndent;
    }

    public void setHideEndTags(boolean bl) {
        this.configuration.hideEndTags = bl;
    }

    public boolean getHideEndTags() {
        return this.configuration.hideEndTags;
    }

    public void setXmlTags(boolean bl) {
        this.configuration.xmlTags = bl;
    }

    public boolean getXmlTags() {
        return this.configuration.xmlTags;
    }

    public void setXmlOut(boolean bl) {
        this.configuration.xmlOut = bl;
    }

    public boolean getXmlOut() {
        return this.configuration.xmlOut;
    }

    public void setXHTML(boolean bl) {
        this.configuration.xHTML = bl;
    }

    public boolean getXHTML() {
        return this.configuration.xHTML;
    }

    public void setUpperCaseTags(boolean bl) {
        this.configuration.upperCaseTags = bl;
    }

    public boolean getUpperCaseTags() {
        return this.configuration.upperCaseTags;
    }

    public void setUpperCaseAttrs(boolean bl) {
        this.configuration.upperCaseAttrs = bl;
    }

    public boolean getUpperCaseAttrs() {
        return this.configuration.upperCaseAttrs;
    }

    public void setMakeClean(boolean bl) {
        this.configuration.makeClean = bl;
    }

    public boolean getMakeClean() {
        return this.configuration.makeClean;
    }

    public void setMakeBare(boolean bl) {
        this.configuration.makeBare = bl;
    }

    public boolean getMakeBare() {
        return this.configuration.makeBare;
    }

    public void setBreakBeforeBR(boolean bl) {
        this.configuration.breakBeforeBR = bl;
    }

    public boolean getBreakBeforeBR() {
        return this.configuration.breakBeforeBR;
    }

    public void setBurstSlides(boolean bl) {
        this.configuration.burstSlides = bl;
    }

    public boolean getBurstSlides() {
        return this.configuration.burstSlides;
    }

    public void setNumEntities(boolean bl) {
        this.configuration.numEntities = bl;
    }

    public boolean getNumEntities() {
        return this.configuration.numEntities;
    }

    public void setQuoteMarks(boolean bl) {
        this.configuration.quoteMarks = bl;
    }

    public boolean getQuoteMarks() {
        return this.configuration.quoteMarks;
    }

    public void setQuoteNbsp(boolean bl) {
        this.configuration.quoteNbsp = bl;
    }

    public boolean getQuoteNbsp() {
        return this.configuration.quoteNbsp;
    }

    public void setQuoteAmpersand(boolean bl) {
        this.configuration.quoteAmpersand = bl;
    }

    public boolean getQuoteAmpersand() {
        return this.configuration.quoteAmpersand;
    }

    public void setWrapAttVals(boolean bl) {
        this.configuration.wrapAttVals = bl;
    }

    public boolean getWrapAttVals() {
        return this.configuration.wrapAttVals;
    }

    public void setWrapScriptlets(boolean bl) {
        this.configuration.wrapScriptlets = bl;
    }

    public boolean getWrapScriptlets() {
        return this.configuration.wrapScriptlets;
    }

    public void setWrapSection(boolean bl) {
        this.configuration.wrapSection = bl;
    }

    public boolean getWrapSection() {
        return this.configuration.wrapSection;
    }

    public void setAltText(String string) {
        this.configuration.altText = string;
    }

    public String getAltText() {
        return this.configuration.altText;
    }

    public void setXmlPi(boolean bl) {
        this.configuration.xmlPi = bl;
    }

    public boolean getXmlPi() {
        return this.configuration.xmlPi;
    }

    public void setDropFontTags(boolean bl) {
        this.configuration.dropFontTags = bl;
    }

    public boolean getDropFontTags() {
        return this.configuration.dropFontTags;
    }

    public void setDropProprietaryAttributes(boolean bl) {
        this.configuration.dropProprietaryAttributes = bl;
    }

    public boolean getDropProprietaryAttributes() {
        return this.configuration.dropProprietaryAttributes;
    }

    public void setDropEmptyParas(boolean bl) {
        this.configuration.dropEmptyParas = bl;
    }

    public boolean getDropEmptyParas() {
        return this.configuration.dropEmptyParas;
    }

    public void setFixComments(boolean bl) {
        this.configuration.fixComments = bl;
    }

    public boolean getFixComments() {
        return this.configuration.fixComments;
    }

    public void setWrapAsp(boolean bl) {
        this.configuration.wrapAsp = bl;
    }

    public boolean getWrapAsp() {
        return this.configuration.wrapAsp;
    }

    public void setWrapJste(boolean bl) {
        this.configuration.wrapJste = bl;
    }

    public boolean getWrapJste() {
        return this.configuration.wrapJste;
    }

    public void setWrapPhp(boolean bl) {
        this.configuration.wrapPhp = bl;
    }

    public boolean getWrapPhp() {
        return this.configuration.wrapPhp;
    }

    public void setFixBackslash(boolean bl) {
        this.configuration.fixBackslash = bl;
    }

    public boolean getFixBackslash() {
        return this.configuration.fixBackslash;
    }

    public void setIndentAttributes(boolean bl) {
        this.configuration.indentAttributes = bl;
    }

    public boolean getIndentAttributes() {
        return this.configuration.indentAttributes;
    }

    public void setDocType(String string) {
        if (string != null) {
            this.configuration.docTypeStr = (String)ParsePropertyImpl.DOCTYPE.parse(string, "doctype", this.configuration);
        }
    }

    public String getDocType() {
        String string = null;
        switch (this.configuration.docTypeMode) {
            case 0: {
                string = "omit";
                break;
            }
            case 1: {
                string = "auto";
                break;
            }
            case 2: {
                string = "strict";
                break;
            }
            case 3: {
                string = "loose";
                break;
            }
            case 4: {
                string = this.configuration.docTypeStr;
            }
        }
        return string;
    }

    public void setLogicalEmphasis(boolean bl) {
        this.configuration.logicalEmphasis = bl;
    }

    public boolean getLogicalEmphasis() {
        return this.configuration.logicalEmphasis;
    }

    public void setXmlPIs(boolean bl) {
        this.configuration.xmlPIs = bl;
    }

    public boolean getXmlPIs() {
        return this.configuration.xmlPIs;
    }

    public void setEncloseText(boolean bl) {
        this.configuration.encloseBodyText = bl;
    }

    public boolean getEncloseText() {
        return this.configuration.encloseBodyText;
    }

    public void setEncloseBlockText(boolean bl) {
        this.configuration.encloseBlockText = bl;
    }

    public boolean getEncloseBlockText() {
        return this.configuration.encloseBlockText;
    }

    public void setWord2000(boolean bl) {
        this.configuration.word2000 = bl;
    }

    public boolean getWord2000() {
        return this.configuration.word2000;
    }

    public void setTidyMark(boolean bl) {
        this.configuration.tidyMark = bl;
    }

    public boolean getTidyMark() {
        return this.configuration.tidyMark;
    }

    public void setXmlSpace(boolean bl) {
        this.configuration.xmlSpace = bl;
    }

    public boolean getXmlSpace() {
        return this.configuration.xmlSpace;
    }

    public void setEmacs(boolean bl) {
        this.configuration.emacs = bl;
    }

    public boolean getEmacs() {
        return this.configuration.emacs;
    }

    public void setLiteralAttribs(boolean bl) {
        this.configuration.literalAttribs = bl;
    }

    public boolean getLiteralAttribs() {
        return this.configuration.literalAttribs;
    }

    public void setPrintBodyOnly(boolean bl) {
        this.configuration.bodyOnly = bl;
    }

    public boolean getPrintBodyOnly() {
        return this.configuration.bodyOnly;
    }

    public void setFixUri(boolean bl) {
        this.configuration.fixUri = bl;
    }

    public boolean getFixUri() {
        return this.configuration.fixUri;
    }

    public void setLowerLiterals(boolean bl) {
        this.configuration.lowerLiterals = bl;
    }

    public boolean getLowerLiterals() {
        return this.configuration.lowerLiterals;
    }

    public void setHideComments(boolean bl) {
        this.configuration.hideComments = bl;
    }

    public boolean getHideComments() {
        return this.configuration.hideComments;
    }

    public void setIndentCdata(boolean bl) {
        this.configuration.indentCdata = bl;
    }

    public boolean getIndentCdata() {
        return this.configuration.indentCdata;
    }

    public void setForceOutput(boolean bl) {
        this.configuration.forceOutput = bl;
    }

    public boolean getForceOutput() {
        return this.configuration.forceOutput;
    }

    public void setShowErrors(int n) {
        this.configuration.showErrors = n;
    }

    public int getShowErrors() {
        return this.configuration.showErrors;
    }

    public void setAsciiChars(boolean bl) {
        this.configuration.asciiChars = bl;
    }

    public boolean getAsciiChars() {
        return this.configuration.asciiChars;
    }

    public void setJoinClasses(boolean bl) {
        this.configuration.joinClasses = bl;
    }

    public boolean getJoinClasses() {
        return this.configuration.joinClasses;
    }

    public void setJoinStyles(boolean bl) {
        this.configuration.joinStyles = bl;
    }

    public boolean getJoinStyles() {
        return this.configuration.joinStyles;
    }

    public void setTrimEmptyElements(boolean bl) {
        this.configuration.trimEmpty = bl;
    }

    public boolean getTrimEmptyElements() {
        return this.configuration.trimEmpty;
    }

    public void setReplaceColor(boolean bl) {
        this.configuration.replaceColor = bl;
    }

    public boolean getReplaceColor() {
        return this.configuration.replaceColor;
    }

    public void setEscapeCdata(boolean bl) {
        this.configuration.escapeCdata = bl;
    }

    public boolean getEscapeCdata() {
        return this.configuration.escapeCdata;
    }

    public void setRepeatedAttributes(int n) {
        this.configuration.duplicateAttrs = n;
    }

    public int getRepeatedAttributes() {
        return this.configuration.duplicateAttrs;
    }

    public void setKeepFileTimes(boolean bl) {
        this.configuration.keepFileTimes = bl;
    }

    public boolean getKeepFileTimes() {
        return this.configuration.keepFileTimes;
    }

    public void setRawOut(boolean bl) {
        this.configuration.rawOut = bl;
    }

    public boolean getRawOut() {
        return this.configuration.rawOut;
    }

    public void setInputEncoding(String string) {
        this.configuration.setInCharEncodingName(string);
    }

    public String getInputEncoding() {
        return this.configuration.getInCharEncodingName();
    }

    public void setOutputEncoding(String string) {
        this.configuration.setOutCharEncodingName(string);
    }

    public String getOutputEncoding() {
        return this.configuration.getOutCharEncodingName();
    }

    static {
        CMDLINE_ALIAS.put("xml", "input-xml");
        CMDLINE_ALIAS.put("xml", "output-xhtml");
        CMDLINE_ALIAS.put("asxml", "output-xhtml");
        CMDLINE_ALIAS.put("ashtml", "output-html");
        CMDLINE_ALIAS.put("omit", "hide-endtags");
        CMDLINE_ALIAS.put("upper", "uppercase-tags");
        CMDLINE_ALIAS.put("raw", "output-raw");
        CMDLINE_ALIAS.put("numeric", "numeric-entities");
        CMDLINE_ALIAS.put("change", "write-back");
        CMDLINE_ALIAS.put("update", "write-back");
        CMDLINE_ALIAS.put("modify", "write-back");
        CMDLINE_ALIAS.put("errors", "only-errors");
        CMDLINE_ALIAS.put("slides", "split");
        CMDLINE_ALIAS.put("lang", "language");
        CMDLINE_ALIAS.put("w", "wrap");
        CMDLINE_ALIAS.put("file", "error-file");
        CMDLINE_ALIAS.put("f", "error-file");
    }
}

