/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import org.w3c.tidy.AttVal;
import org.w3c.tidy.AttributeTable;
import org.w3c.tidy.DOMCDATASectionImpl;
import org.w3c.tidy.DOMCommentImpl;
import org.w3c.tidy.DOMDocumentImpl;
import org.w3c.tidy.DOMDocumentTypeImpl;
import org.w3c.tidy.DOMElementImpl;
import org.w3c.tidy.DOMNodeImpl;
import org.w3c.tidy.DOMProcessingInstructionImpl;
import org.w3c.tidy.DOMTextImpl;
import org.w3c.tidy.Dict;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.TagTable;
import org.w3c.tidy.TidyUtils;

public class Node {
    public static final short ROOT_NODE = 0;
    public static final short DOCTYPE_TAG = 1;
    public static final short COMMENT_TAG = 2;
    public static final short PROC_INS_TAG = 3;
    public static final short TEXT_NODE = 4;
    public static final short START_TAG = 5;
    public static final short END_TAG = 6;
    public static final short START_END_TAG = 7;
    public static final short CDATA_TAG = 8;
    public static final short SECTION_TAG = 9;
    public static final short ASP_TAG = 10;
    public static final short JSTE_TAG = 11;
    public static final short PHP_TAG = 12;
    public static final short XML_DECL = 13;
    private static final String[] NODETYPE_STRING = new String[]{"RootNode", "DocTypeTag", "CommentTag", "ProcInsTag", "TextNode", "StartTag", "EndTag", "StartEndTag", "SectionTag", "AspTag", "PhpTag", "XmlDecl"};
    protected Node parent = null;
    protected Node prev = null;
    protected Node next = null;
    protected Node last = null;
    protected int start;
    protected int end;
    protected byte[] textarray;
    protected short type;
    protected boolean closed;
    protected boolean implicit;
    protected boolean linebreak;
    protected Dict was;
    protected Dict tag;
    protected String element;
    protected AttVal attributes;
    protected Node content;
    protected org.w3c.dom.Node adapter;

    public Node() {
        this(4, null, 0, 0);
    }

    public Node(short s, byte[] byArray, int n, int n2) {
        this.start = n;
        this.end = n2;
        this.textarray = byArray;
        this.type = s;
        this.closed = false;
        this.implicit = false;
        this.linebreak = false;
        this.was = null;
        this.tag = null;
        this.element = null;
        this.attributes = null;
        this.content = null;
    }

    public Node(short s, byte[] byArray, int n, int n2, String string, TagTable tagTable) {
        this.start = n;
        this.end = n2;
        this.textarray = byArray;
        this.type = s;
        this.closed = false;
        this.implicit = false;
        this.linebreak = false;
        this.was = null;
        this.tag = null;
        this.element = string;
        this.attributes = null;
        this.content = null;
        if (s == 5 || s == 7 || s == 6) {
            tagTable.findTag(this);
        }
    }

    public AttVal getAttrByName(String string) {
        AttVal attVal = this.attributes;
        while (!(attVal == null || string != null && attVal.attribute != null && attVal.attribute.equals(string))) {
            attVal = attVal.next;
        }
        return attVal;
    }

    public void checkAttributes(Lexer lexer) {
        AttVal attVal = this.attributes;
        while (attVal != null) {
            attVal.checkAttribute(lexer, this);
            attVal = attVal.next;
        }
    }

    public void repairDuplicateAttributes(Lexer lexer) {
        AttVal attVal = this.attributes;
        while (attVal != null) {
            if (attVal.asp == null && attVal.php == null) {
                AttVal attVal2 = attVal.next;
                while (attVal2 != null) {
                    if (attVal2.asp == null && attVal2.php == null && attVal.attribute != null && attVal.attribute.equalsIgnoreCase(attVal2.attribute)) {
                        AttVal attVal3;
                        if ("class".equalsIgnoreCase(attVal2.attribute) && lexer.configuration.joinClasses) {
                            attVal2.value = attVal2.value + " " + attVal.value;
                            attVal3 = attVal.next;
                            attVal2 = attVal3.next == null ? null : attVal2.next;
                            lexer.report.attrError(lexer, this, attVal, (short)68);
                            this.removeAttribute(attVal);
                            attVal = attVal3;
                            continue;
                        }
                        if ("style".equalsIgnoreCase(attVal2.attribute) && lexer.configuration.joinStyles && attVal2.value != null && attVal.value != null) {
                            int n = attVal2.value.length() - 1;
                            attVal2.value = attVal2.value.charAt(n) == ';' ? attVal2.value + " " + attVal.value : (attVal2.value.charAt(n) == '}' ? attVal2.value + " { " + attVal.value + " }" : attVal2.value + "; " + attVal.value);
                            attVal3 = attVal.next;
                            attVal2 = attVal3.next == null ? null : attVal2.next;
                            lexer.report.attrError(lexer, this, attVal, (short)68);
                            this.removeAttribute(attVal);
                            attVal = attVal3;
                            continue;
                        }
                        if (lexer.configuration.duplicateAttrs == 0) {
                            attVal3 = attVal2.next;
                            lexer.report.attrError(lexer, this, attVal2, (short)55);
                            this.removeAttribute(attVal2);
                            attVal2 = attVal3;
                            continue;
                        }
                        attVal3 = attVal.next;
                        attVal2 = attVal.next == null ? null : attVal2.next;
                        lexer.report.attrError(lexer, this, attVal, (short)55);
                        this.removeAttribute(attVal);
                        attVal = attVal3;
                        continue;
                    }
                    attVal2 = attVal2.next;
                }
                attVal = attVal.next;
                continue;
            }
            attVal = attVal.next;
        }
    }

    public void addAttribute(String string, String string2) {
        AttVal attVal = new AttVal(null, null, null, null, 34, string, string2);
        attVal.dict = AttributeTable.getDefaultAttributeTable().findAttribute(attVal);
        if (this.attributes == null) {
            this.attributes = attVal;
        } else {
            AttVal attVal2 = this.attributes;
            while (attVal2.next != null) {
                attVal2 = attVal2.next;
            }
            attVal2.next = attVal;
        }
    }

    public void removeAttribute(AttVal attVal) {
        AttVal attVal2 = null;
        AttVal attVal3 = this.attributes;
        while (attVal3 != null) {
            AttVal attVal4 = attVal3.next;
            if (attVal3 == attVal) {
                if (attVal2 != null) {
                    attVal2.next = attVal4;
                } else {
                    this.attributes = attVal4;
                }
            } else {
                attVal2 = attVal3;
            }
            attVal3 = attVal4;
        }
    }

    public Node findDocType() {
        Node node = this.content;
        while (node != null && node.type != 1) {
            node = node.next;
        }
        return node;
    }

    public void discardDocType() {
        Node node = this.findDocType();
        if (node != null) {
            if (node.prev != null) {
                node.prev.next = node.next;
            } else {
                node.parent.content = node.next;
            }
            if (node.next != null) {
                node.next.prev = node.prev;
            }
            node.next = null;
        }
    }

    public static Node discardElement(Node node) {
        Node node2 = null;
        if (node != null) {
            node2 = node.next;
            node.removeNode();
        }
        return node2;
    }

    public void insertNodeAtStart(Node node) {
        node.parent = this;
        if (this.content == null) {
            this.last = node;
        } else {
            this.content.prev = node;
        }
        node.next = this.content;
        node.prev = null;
        this.content = node;
    }

    public void insertNodeAtEnd(Node node) {
        node.parent = this;
        node.prev = this.last;
        if (this.last != null) {
            this.last.next = node;
        } else {
            this.content = node;
        }
        this.last = node;
    }

    public static void insertNodeAsParent(Node node, Node node2) {
        node2.content = node;
        node2.last = node;
        node2.parent = node.parent;
        node.parent = node2;
        if (node2.parent.content == node) {
            node2.parent.content = node2;
        }
        if (node2.parent.last == node) {
            node2.parent.last = node2;
        }
        node2.prev = node.prev;
        node.prev = null;
        if (node2.prev != null) {
            node2.prev.next = node2;
        }
        node2.next = node.next;
        node.next = null;
        if (node2.next != null) {
            node2.next.prev = node2;
        }
    }

    public static void insertNodeBeforeElement(Node node, Node node2) {
        Node node3;
        node2.parent = node3 = node.parent;
        node2.next = node;
        node2.prev = node.prev;
        node.prev = node2;
        if (node2.prev != null) {
            node2.prev.next = node2;
        }
        if (node3 != null && node3.content == node) {
            node3.content = node2;
        }
    }

    public void insertNodeAfterElement(Node node) {
        Node node2;
        node.parent = node2 = this.parent;
        if (node2 != null && node2.last == this) {
            node2.last = node;
        } else {
            node.next = this.next;
            if (node.next != null) {
                node.next.prev = node;
            }
        }
        this.next = node;
        node.prev = this;
    }

    public static Node trimEmptyElement(Lexer lexer, Node node) {
        if (lexer.configuration.trimEmpty && lexer.canPrune(node)) {
            if (node.type != 4) {
                lexer.report.warning(lexer, node, null, (short)23);
            }
            return Node.discardElement(node);
        }
        return node.next;
    }

    public static Node dropEmptyElements(Lexer lexer, Node node) {
        Node node2 = null;
        while (node != null) {
            node2 = node.next;
            if (node.content != null) {
                Node.dropEmptyElements(lexer, node.content);
            }
            if (node.type != 5 && node.type != 7 && node.type != 4 && node.start >= node.end) {
                node = node2;
                continue;
            }
            node = node2 = Node.trimEmptyElement(lexer, node);
        }
        return node;
    }

    public static void trimTrailingSpace(Lexer lexer, Node node, Node node2) {
        TagTable tagTable = lexer.configuration.tt;
        if (node2 != null && node2.type == 4) {
            byte by;
            if (node2.end > node2.start && ((by = lexer.lexbuf[node2.end - 1]) == 160 || by == 32)) {
                if (by == 160 && (node.tag == tagTable.tagTd || node.tag == tagTable.tagTh)) {
                    if (node2.end > node2.start + 1) {
                        --node2.end;
                    }
                } else {
                    --node2.end;
                    if (TidyUtils.toBoolean(node.tag.model & 0x10) && !TidyUtils.toBoolean(node.tag.model & 0x400)) {
                        lexer.insertspace = true;
                    }
                }
            }
            if (node2.start == node2.end) {
                Node.trimEmptyElement(lexer, node2);
            }
        }
    }

    protected static Node escapeTag(Lexer lexer, Node node) {
        Node node2 = lexer.newNode();
        node2.start = lexer.lexsize;
        node2.textarray = node.textarray;
        lexer.addByte(60);
        if (node.type == 6) {
            lexer.addByte(47);
        }
        if (node.element != null) {
            lexer.addStringLiteral(node.element);
        } else if (node.type == 1) {
            lexer.addByte(33);
            lexer.addByte(68);
            lexer.addByte(79);
            lexer.addByte(67);
            lexer.addByte(84);
            lexer.addByte(89);
            lexer.addByte(80);
            lexer.addByte(69);
            lexer.addByte(32);
            for (int i = node.start; i < node.end; ++i) {
                lexer.addByte(lexer.lexbuf[i]);
            }
        }
        if (node.type == 7) {
            lexer.addByte(47);
        }
        lexer.addByte(62);
        node2.end = lexer.lexsize;
        return node2;
    }

    public boolean isBlank(Lexer lexer) {
        if (this.type == 4) {
            if (this.end == this.start) {
                return true;
            }
            if (this.end == this.start + 1 && lexer.lexbuf[this.end - 1] == 32) {
                return true;
            }
        }
        return false;
    }

    public static void trimInitialSpace(Lexer lexer, Node node, Node node2) {
        if (node2.type == 4 && node2.textarray[node2.start] == 32 && node2.start < node2.end) {
            if (TidyUtils.toBoolean(node.tag.model & 0x10) && !TidyUtils.toBoolean(node.tag.model & 0x400) && node.parent.content != node) {
                Node node3 = node.prev;
                if (node3 != null && node3.type == 4) {
                    if (node3.textarray[node3.end - 1] != 32) {
                        node3.textarray[node3.end++] = 32;
                    }
                    ++node.start;
                } else {
                    Node node4 = lexer.newNode();
                    if (node.start >= node.end) {
                        node4.start = 0;
                        node4.end = 1;
                        node4.textarray = new byte[1];
                    } else {
                        node4.start = node.start++;
                        node4.end = node.start;
                        node4.textarray = node.textarray;
                    }
                    node4.textarray[node4.start] = 32;
                    node4.prev = node3;
                    if (node3 != null) {
                        node3.next = node4;
                    }
                    node4.next = node;
                    node.prev = node4;
                    node4.parent = node.parent;
                }
            }
            ++node2.start;
        }
    }

    public static void trimSpaces(Lexer lexer, Node node) {
        Node node2 = node.content;
        TagTable tagTable = lexer.configuration.tt;
        if (node2 != null && node2.type == 4 && node.tag != tagTable.tagPre) {
            Node.trimInitialSpace(lexer, node, node2);
        }
        if ((node2 = node.last) != null && node2.type == 4) {
            Node.trimTrailingSpace(lexer, node, node2);
        }
    }

    public boolean isDescendantOf(Dict dict) {
        Node node = this.parent;
        while (node != null) {
            if (node.tag == dict) {
                return true;
            }
            node = node.parent;
        }
        return false;
    }

    public static void insertDocType(Lexer lexer, Node node, Node node2) {
        TagTable tagTable = lexer.configuration.tt;
        lexer.report.warning(lexer, node, node2, (short)34);
        while (node.tag != tagTable.tagHtml) {
            node = node.parent;
        }
        Node.insertNodeBeforeElement(node, node2);
    }

    public Node findBody(TagTable tagTable) {
        Node node = this.content;
        while (node != null && node.tag != tagTable.tagHtml) {
            node = node.next;
        }
        if (node == null) {
            return null;
        }
        node = node.content;
        while (node != null && node.tag != tagTable.tagBody && node.tag != tagTable.tagFrameset) {
            node = node.next;
        }
        if (node.tag == tagTable.tagFrameset) {
            node = node.content;
            while (node != null && node.tag != tagTable.tagNoframes) {
                node = node.next;
            }
            if (node != null) {
                node = node.content;
                while (node != null && node.tag != tagTable.tagBody) {
                    node = node.next;
                }
            }
        }
        return node;
    }

    public boolean isElement() {
        return this.type == 5 || this.type == 7;
    }

    public static void moveBeforeTable(Node node, Node node2, TagTable tagTable) {
        Node node3 = node.parent;
        while (node3 != null) {
            if (node3.tag == tagTable.tagTable) {
                if (node3.parent.content == node3) {
                    node3.parent.content = node2;
                }
                node2.prev = node3.prev;
                node2.next = node3;
                node3.prev = node2;
                node2.parent = node3.parent;
                if (node2.prev == null) break;
                node2.prev.next = node2;
                break;
            }
            node3 = node3.parent;
        }
    }

    public static void fixEmptyRow(Lexer lexer, Node node) {
        if (node.content == null) {
            Node node2 = lexer.inferredTag("td");
            node.insertNodeAtEnd(node2);
            lexer.report.warning(lexer, node, node2, (short)12);
        }
    }

    public static void coerceNode(Lexer lexer, Node node, Dict dict) {
        Node node2 = lexer.inferredTag(dict.name);
        lexer.report.warning(lexer, node, node2, (short)20);
        node.was = node.tag;
        node.tag = dict;
        node.type = (short)5;
        node.implicit = true;
        node.element = dict.name;
    }

    public void removeNode() {
        if (this.prev != null) {
            this.prev.next = this.next;
        }
        if (this.next != null) {
            this.next.prev = this.prev;
        }
        if (this.parent != null) {
            if (this.parent.content == this) {
                this.parent.content = this.next;
            }
            if (this.parent.last == this) {
                this.parent.last = this.prev;
            }
        }
        this.parent = null;
        this.prev = null;
        this.next = null;
    }

    public static boolean insertMisc(Node node, Node node2) {
        if (node2.type == 2 || node2.type == 3 || node2.type == 8 || node2.type == 9 || node2.type == 10 || node2.type == 11 || node2.type == 12 || node2.type == 13) {
            node.insertNodeAtEnd(node2);
            return true;
        }
        return false;
    }

    public boolean isNewNode() {
        if (this.tag != null) {
            return TidyUtils.toBoolean(this.tag.model & 0x100000);
        }
        return true;
    }

    public boolean hasOneChild() {
        return this.content != null && this.content.next == null;
    }

    public Node findHTML(TagTable tagTable) {
        Node node = this.content;
        while (node != null && node.tag != tagTable.tagHtml) {
            node = node.next;
        }
        return node;
    }

    public Node findHEAD(TagTable tagTable) {
        Node node = this.findHTML(tagTable);
        if (node != null) {
            node = node.content;
            while (node != null && node.tag != tagTable.tagHead) {
                node = node.next;
            }
        }
        return node;
    }

    public Node findTITLE(TagTable tagTable) {
        Node node = this.findHEAD(tagTable);
        if (node != null) {
            node = node.content;
            while (node != null && node.tag != tagTable.tagTitle) {
                node = node.next;
            }
        }
        return node;
    }

    public boolean checkNodeIntegrity() {
        if (this.prev != null && this.prev.next != this) {
            return false;
        }
        if (this.next != null && (this.next == this || this.next.prev != this)) {
            return false;
        }
        if (this.parent != null) {
            if (this.prev == null && this.parent.content != this) {
                return false;
            }
            if (this.next == null && this.parent.last != this) {
                return false;
            }
        }
        Node node = this.content;
        while (node != null) {
            if (node.parent != this || !node.checkNodeIntegrity()) {
                return false;
            }
            node = node.next;
        }
        return true;
    }

    public void addClass(String string) {
        AttVal attVal = this.getAttrByName("class");
        if (attVal != null) {
            attVal.value = attVal.value + " " + string;
        } else {
            this.addAttribute("class", string);
        }
    }

    public String toString() {
        String string = "";
        Node node = this;
        while (node != null) {
            string = string + "[Node type=";
            string = string + NODETYPE_STRING[node.type];
            string = string + ",element=";
            string = node.element != null ? string + node.element : string + "null";
            if (node.type == 4 || node.type == 2 || node.type == 3) {
                string = string + ",text=";
                if (node.textarray != null && node.start <= node.end) {
                    string = string + "\"";
                    string = string + TidyUtils.getString(node.textarray, node.start, node.end - node.start);
                    string = string + "\"";
                } else {
                    string = string + "null";
                }
            }
            string = string + ",content=";
            string = node.content != null ? string + node.content.toString() : string + "null";
            string = string + "]";
            if (node.next != null) {
                string = string + ",";
            }
            node = node.next;
        }
        return string;
    }

    protected org.w3c.dom.Node getAdapter() {
        if (this.adapter == null) {
            switch (this.type) {
                case 0: {
                    this.adapter = new DOMDocumentImpl(this);
                    break;
                }
                case 5: 
                case 7: {
                    this.adapter = new DOMElementImpl(this);
                    break;
                }
                case 1: {
                    this.adapter = new DOMDocumentTypeImpl(this);
                    break;
                }
                case 2: {
                    this.adapter = new DOMCommentImpl(this);
                    break;
                }
                case 4: {
                    this.adapter = new DOMTextImpl(this);
                    break;
                }
                case 8: {
                    this.adapter = new DOMCDATASectionImpl(this);
                    break;
                }
                case 3: {
                    this.adapter = new DOMProcessingInstructionImpl(this);
                    break;
                }
                default: {
                    this.adapter = new DOMNodeImpl(this);
                }
            }
        }
        return this.adapter;
    }

    protected Node cloneNode(boolean bl) {
        Node node = new Node(this.type, this.textarray, this.start, this.end);
        node.parent = this.parent;
        node.closed = this.closed;
        node.implicit = this.implicit;
        node.tag = this.tag;
        node.element = this.element;
        if (this.attributes != null) {
            node.attributes = (AttVal)this.attributes.clone();
        }
        if (bl) {
            Node node2 = this.content;
            while (node2 != null) {
                Node node3 = node2.cloneNode(bl);
                node.insertNodeAtEnd(node3);
                node2 = node2.next;
            }
        }
        return node;
    }

    protected void setType(short s) {
        this.type = s;
    }

    public boolean isJavaScript() {
        boolean bl = false;
        if (this.attributes == null) {
            return true;
        }
        AttVal attVal = this.attributes;
        while (attVal != null) {
            if (("language".equalsIgnoreCase(attVal.attribute) || "type".equalsIgnoreCase(attVal.attribute)) && "javascript".equalsIgnoreCase(attVal.value)) {
                bl = true;
            }
            attVal = attVal.next;
        }
        return bl;
    }

    public boolean expectsContent() {
        if (this.type != 5) {
            return false;
        }
        if (this.tag == null) {
            return true;
        }
        return !TidyUtils.toBoolean(this.tag.model & 1);
    }

    public boolean hasCm(int n) {
        return (this.tag.model & n) != 0;
    }
}

