/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import org.w3c.tidy.TidyUtils;
import org.w3c.tidy.ValidUTF8Sequence;

public final class EncodingUtils {
    public static final int UNICODE_BOM_BE = 65279;
    public static final int UNICODE_BOM = 65279;
    public static final int UNICODE_BOM_LE = 65534;
    public static final int UNICODE_BOM_UTF8 = 0xEFBBBF;
    public static final int FSM_ASCII = 0;
    public static final int FSM_ESC = 1;
    public static final int FSM_ESCD = 2;
    public static final int FSM_ESCDP = 3;
    public static final int FSM_ESCP = 4;
    public static final int FSM_NONASCII = 5;
    public static final int MAX_UTF8_FROM_UCS4 = 0x10FFFF;
    public static final int MAX_UTF16_FROM_UCS4 = 0x10FFFF;
    public static final int LOW_UTF16_SURROGATE = 55296;
    public static final int UTF16_SURROGATES_BEGIN = 65536;
    public static final int UTF16_LOW_SURROGATE_BEGIN = 55296;
    public static final int UTF16_LOW_SURROGATE_END = 56319;
    public static final int UTF16_HIGH_SURROGATE_BEGIN = 56320;
    public static final int UTF16_HIGH_SURROGATE_END = 57343;
    public static final int HIGH_UTF16_SURROGATE = 57343;
    private static final int UTF8_BYTE_SWAP_NOT_A_CHAR = 65534;
    private static final int UTF8_NOT_A_CHAR = 65535;
    private static final int[] WIN2UNICODE = new int[]{8364, 0, 8218, 402, 8222, 8230, 8224, 8225, 710, 8240, 352, 8249, 338, 0, 381, 0, 0, 8216, 8217, 8220, 8221, 8226, 8211, 8212, 732, 8482, 353, 8250, 339, 0, 382, 376};
    private static final int[] MAC2UNICODE = new int[]{196, 197, 199, 201, 209, 214, 220, 225, 224, 226, 228, 227, 229, 231, 233, 232, 234, 235, 237, 236, 238, 239, 241, 243, 242, 244, 246, 245, 250, 249, 251, 252, 8224, 176, 162, 163, 167, 8226, 182, 223, 174, 169, 8482, 180, 168, 8800, 198, 216, 8734, 177, 8804, 8805, 165, 181, 8706, 8721, 8719, 960, 8747, 170, 186, 937, 230, 248, 191, 161, 172, 8730, 402, 8776, 8710, 171, 187, 8230, 160, 192, 195, 213, 338, 339, 8211, 8212, 8220, 8221, 8216, 8217, 247, 9674, 255, 376, 8260, 8364, 8249, 8250, 64257, 64258, 8225, 183, 8218, 8222, 8240, 194, 202, 193, 203, 200, 205, 206, 207, 204, 211, 212, 63743, 210, 218, 219, 217, 305, 710, 732, 175, 728, 729, 730, 184, 733, 731, 711};
    private static final int[] SYMBOL2UNICODE = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 8704, 35, 8707, 37, 38, 8717, 40, 41, 8727, 43, 44, 8722, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 8773, 913, 914, 935, 916, 917, 934, 915, 919, 921, 977, 922, 923, 924, 925, 927, 928, 920, 929, 931, 932, 933, 962, 937, 926, 936, 918, 91, 8756, 93, 8869, 95, 175, 945, 946, 967, 948, 949, 966, 947, 951, 953, 981, 954, 955, 956, 957, 959, 960, 952, 961, 963, 964, 965, 982, 969, 958, 968, 950, 123, 124, 125, 8764, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 160, 978, 8242, 8804, 8260, 8734, 402, 9827, 9830, 9829, 9824, 8596, 8592, 8593, 8594, 8595, 176, 177, 8243, 8805, 215, 8733, 8706, 183, 247, 8800, 8801, 8776, 8230, 63, 63, 8629, 8501, 8465, 8476, 8472, 8855, 8853, 8709, 8745, 8746, 8835, 8839, 8836, 8834, 8838, 8712, 8713, 8736, 8711, 174, 169, 8482, 8719, 8730, 8901, 172, 8743, 8744, 8660, 8656, 8657, 8658, 8659, 9674, 9001, 174, 169, 8482, 8721, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 8364, 9002, 8747, 8992, 63, 8993, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63};
    private static final ValidUTF8Sequence[] VALID_UTF8 = new ValidUTF8Sequence[]{new ValidUTF8Sequence(0, 127, 1, new char[]{'\u0000', '\u007f', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'}), new ValidUTF8Sequence(128, 2047, 2, new char[]{'\u00c2', '\u00df', '\u0080', '\u00bf', '\u0000', '\u0000', '\u0000', '\u0000'}), new ValidUTF8Sequence(2048, 4095, 3, new char[]{'\u00e0', '\u00e0', '\u00a0', '\u00bf', '\u0080', '\u00bf', '\u0000', '\u0000'}), new ValidUTF8Sequence(4096, 65535, 3, new char[]{'\u00e1', '\u00ef', '\u0080', '\u00bf', '\u0080', '\u00bf', '\u0000', '\u0000'}), new ValidUTF8Sequence(65536, 262143, 4, new char[]{'\u00f0', '\u00f0', '\u0090', '\u00bf', '\u0080', '\u00bf', '\u0080', '\u00bf'}), new ValidUTF8Sequence(262144, 1048575, 4, new char[]{'\u00f1', '\u00f3', '\u0080', '\u00bf', '\u0080', '\u00bf', '\u0080', '\u00bf'}), new ValidUTF8Sequence(0x100000, 0x10FFFF, 4, new char[]{'\u00f4', '\u00f4', '\u0080', '\u008f', '\u0080', '\u00bf', '\u0080', '\u00bf'})};
    private static final int NUM_UTF8_SEQUENCES = VALID_UTF8.length;
    private static final int[] OFFSET_UTF8_SEQUENCES = new int[]{0, 1, 2, 4, NUM_UTF8_SEQUENCES};

    private EncodingUtils() {
    }

    protected static int decodeWin1252(int n) {
        return WIN2UNICODE[n - 128];
    }

    protected static int decodeMacRoman(int n) {
        if (127 < n) {
            n = MAC2UNICODE[n - 128];
        }
        return n;
    }

    static int decodeSymbolFont(int n) {
        if (n > 255) {
            return n;
        }
        return SYMBOL2UNICODE[n];
    }

    static boolean decodeUTF8BytesToChar(int[] nArray, int n, byte[] byArray, GetBytes getBytes, int[] nArray2, int n2) {
        int n3;
        byte[] byArray2 = new byte[10];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        if (byArray.length != 0) {
            byArray2 = byArray;
        }
        if (n == -1) {
            nArray[0] = n;
            nArray2[0] = 1;
            return false;
        }
        n4 = TidyUtils.toUnsigned(n);
        if (n4 <= 127) {
            n5 = n4;
            n6 = 1;
        } else if ((n4 & 0xE0) == 192) {
            n5 = n4 & 0x1F;
            n6 = 2;
        } else if ((n4 & 0xF0) == 224) {
            n5 = n4 & 0xF;
            n6 = 3;
        } else if ((n4 & 0xF8) == 240) {
            n5 = n4 & 7;
            n6 = 4;
        } else if ((n4 & 0xFC) == 248) {
            n5 = n4 & 3;
            n6 = 5;
            bl = true;
        } else if ((n4 & 0xFE) == 252) {
            n5 = n4 & 1;
            n6 = 6;
            bl = true;
        } else {
            n5 = n4;
            n6 = 1;
            bl = true;
        }
        for (n3 = 1; n3 < n6; ++n3) {
            int[] nArray3;
            int[] nArray4 = new int[1];
            if (getBytes != null && n6 - n3 > 0) {
                nArray4[0] = 1;
                nArray3 = new int[]{byArray2[n2 + n3 - 1]};
                getBytes.doGet(nArray3, nArray4, false);
                if (nArray4[0] <= 0) {
                    bl = true;
                    n6 = n3;
                    break;
                }
            }
            if ((byArray2[n2 + n3 - 1] & 0xC0) != 128) {
                bl = true;
                n6 = n3;
                if (getBytes == null) break;
                nArray3 = new int[]{byArray2[n2 + n3 - 1]};
                nArray4[0] = 1;
                getBytes.doGet(nArray3, nArray4, true);
                break;
            }
            n5 = n5 << 6 | byArray2[n2 + n3 - 1] & 0x3F;
        }
        if (!(bl || n5 != 65534 && n5 != 65535)) {
            bl = true;
        }
        if (!bl && n5 > 0x10FFFF) {
            bl = true;
        }
        if (!bl) {
            int n7 = OFFSET_UTF8_SEQUENCES[n6 - 1];
            int n8 = OFFSET_UTF8_SEQUENCES[n6] - 1;
            if (n5 < EncodingUtils.VALID_UTF8[n7].lowChar || n5 > EncodingUtils.VALID_UTF8[n8].highChar) {
                bl = true;
            } else {
                bl = true;
                block1: for (n3 = n7; n3 <= n8; ++n3) {
                    for (int i = 0; i < n6; ++i) {
                        char c = !TidyUtils.toBoolean(i) ? (char)n : (char)byArray2[n2 + i - 1];
                        if (c >= EncodingUtils.VALID_UTF8[n3].validBytes[i * 2] && c <= EncodingUtils.VALID_UTF8[n3].validBytes[i * 2 + 1]) {
                            bl = false;
                        }
                        if (bl) continue block1;
                    }
                }
            }
        }
        nArray2[0] = n6;
        nArray[0] = n5;
        return bl;
    }

    static boolean encodeCharToUTF8Bytes(int n, byte[] byArray, PutBytes putBytes, int[] nArray) {
        int n2 = 0;
        byte[] byArray2 = new byte[10];
        if (byArray != null) {
            byArray2 = byArray;
        }
        boolean bl = false;
        if (n <= 127) {
            byArray2[0] = (byte)n;
            n2 = 1;
        } else if (n <= 2047) {
            byArray2[0] = (byte)(0xC0 | n >> 6);
            byArray2[1] = (byte)(0x80 | n & 0x3F);
            n2 = 2;
        } else if (n <= 65535) {
            byArray2[0] = (byte)(0xE0 | n >> 12);
            byArray2[1] = (byte)(0x80 | n >> 6 & 0x3F);
            byArray2[2] = (byte)(0x80 | n & 0x3F);
            n2 = 3;
            if (n == 65534 || n == 65535) {
                bl = true;
            } else if (n >= 55296 && n <= 57343) {
                // empty if block
            }
        } else if (n <= 0x1FFFFF) {
            byArray2[0] = (byte)(0xF0 | n >> 18);
            byArray2[1] = (byte)(0x80 | n >> 12 & 0x3F);
            byArray2[2] = (byte)(0x80 | n >> 6 & 0x3F);
            byArray2[3] = (byte)(0x80 | n & 0x3F);
            n2 = 4;
            if (n > 0x10FFFF) {
                bl = true;
            }
        } else if (n <= 0x3FFFFFF) {
            byArray2[0] = (byte)(0xF8 | n >> 24);
            byArray2[1] = (byte)(0x80 | n >> 18);
            byArray2[2] = (byte)(0x80 | n >> 12 & 0x3F);
            byArray2[3] = (byte)(0x80 | n >> 6 & 0x3F);
            byArray2[4] = (byte)(0x80 | n & 0x3F);
            n2 = 5;
            bl = true;
        } else if (n <= Integer.MAX_VALUE) {
            byArray2[0] = (byte)(0xFC | n >> 30);
            byArray2[1] = (byte)(0x80 | n >> 24 & 0x3F);
            byArray2[2] = (byte)(0x80 | n >> 18 & 0x3F);
            byArray2[3] = (byte)(0x80 | n >> 12 & 0x3F);
            byArray2[4] = (byte)(0x80 | n >> 6 & 0x3F);
            byArray2[5] = (byte)(0x80 | n & 0x3F);
            n2 = 6;
            bl = true;
        } else {
            bl = true;
        }
        if (!bl && putBytes != null) {
            int[] nArray2 = new int[]{n2};
            putBytes.doPut(byArray2, nArray2);
            if (nArray2[0] < n2) {
                bl = true;
            }
        }
        nArray[0] = n2;
        return bl;
    }

    static interface PutBytes {
        public void doPut(byte[] var1, int[] var2);
    }

    static interface GetBytes {
        public void doGet(int[] var1, int[] var2, boolean var3);
    }
}

