/*
 * Decompiled with CFR 0.152.
 */
package gplx.langs.xmls;

import gplx.Bry_;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.Io_url_;
import gplx.String_;
import gplx.Tfds;
import gplx.langs.xmls.XmlFileSplitter;
import org.junit.Before;
import org.junit.Test;

public class XmlFileSplitter_tst {
    XmlFileSplitter splitter;

    @Before
    public void setup() {
        this.splitter = new XmlFileSplitter();
        Io_mgr.Instance.InitEngine_mem();
    }

    @Test
    public void FindMatchPos() {
        this.tst_FindMatchPos("abcde", "a", 0);
        this.tst_FindMatchPos("abcde", "b", 1);
        this.tst_FindMatchPos("abcde", "cd", 2);
        this.tst_FindMatchPos("abcde", "f", -1);
        this.tst_FindMatchPos("abcde", "fg", -1);
    }

    void tst_FindMatchPos(String src, String find, int expd) {
        Tfds.Eq(expd, this.splitter.FindMatchPos(this.byte_(src), this.byteAry_(find)));
    }

    @Test
    public void FindMatchPosRev() {
        this.tst_FindMatchPosRev("abcde", "a", 0);
        this.tst_FindMatchPosRev("abcde", "b", 1);
        this.tst_FindMatchPosRev("abcde", "cd", 2);
        this.tst_FindMatchPosRev("abcde", "f", -1);
        this.tst_FindMatchPosRev("abcde", "ef", -1);
        this.tst_FindMatchPosRev("abcde", "za", -1);
        this.tst_FindMatchPosRev("dbcde", "d", 3);
    }

    void tst_FindMatchPosRev(String src, String find, int expd) {
        Tfds.Eq(expd, this.splitter.FindMatchPosRev(this.byte_(src), this.byteAry_(find)));
    }

    @Test
    public void ExtractHdr() {
        this.tst_ExtractHdr("<a><b>", "<b", "<a>", "<b>");
    }

    @Test
    public void Split() {
        this.splitter.Opts().FileSizeMax_(30).XmlNames_("<a").XmlEnd_("</root>");
        this.tst_Split("<root><a id='1'/><a id='2'/><a id='3'/><a id='4'/><a id='5'/></root>", "<root><a id='1'/><a id='2'/></root>", "<root><a id='3'/><a id='4'/></root>", "<root><a id='5'/></root>");
        this.tst_Split("<root><a id='1' name='long_text_that_will_force_next_read'/><a id='2'/></root>", "<root><a id='1' name='long_text_that_will_force_next_read'/></root>", "<root><a id='2'/></root>");
    }

    void tst_Split(String txt, String ... expd) {
        Io_url xmlFil = Io_url_.mem_fil_("mem/800_misc/txt.xml");
        Io_url tmpDir = xmlFil.OwnerDir().GenSubDir("temp_xml");
        Io_mgr.Instance.DeleteDirDeep(tmpDir);
        this.splitter.Opts().StatusFmt_(null).PartDir_(tmpDir);
        this.splitter.Opts().Namer().Ctor_io(tmpDir, "", "fil_{0}.xml", "000", new int[0]);
        Io_mgr.Instance.SaveFilStr(xmlFil, txt);
        this.splitter.Split(xmlFil);
        Io_url[] tmpFilAry = Io_mgr.Instance.QueryDir_fils(tmpDir);
        Tfds.Eq(expd.length, tmpFilAry.length);
        int i = 0;
        while (i < tmpFilAry.length) {
            Io_url tmpFil = tmpFilAry[i];
            Tfds.Eq(expd[i], Io_mgr.Instance.LoadFilStr(tmpFil));
            ++i;
        }
    }

    byte[] byte_(String s) {
        return Bry_.new_u8(s);
    }

    byte[][] byteAry_(String s) {
        byte[][] rv = new byte[][]{Bry_.new_u8(s)};
        return rv;
    }

    void tst_ExtractHdr(String src, String find, String expdHdr, String expdSrc) {
        this.splitter.Clear();
        byte[] srcAry = this.byte_(src);
        int findPos = this.splitter.FindMatchPos(srcAry, this.byteAry_(find));
        srcAry = this.splitter.SplitHdr(srcAry, findPos);
        Tfds.Eq(String_.new_u8(this.splitter.Hdr()), expdHdr);
        Tfds.Eq(String_.new_u8(srcAry), expdSrc);
    }
}

