/*
 * Decompiled with CFR 0.152.
 */
package gplx.langs.xmls;

import gplx.Array_;
import gplx.Bry_;
import gplx.Err_;
import gplx.Io_url;
import gplx.String_;
import gplx.core.consoles.Console_adp__sys;
import gplx.langs.xmls.XmlFileSplitterOpts;
import gplx.langs.xmls.XmlSplitRdr;
import gplx.langs.xmls.XmlSplitWtr;

public class XmlFileSplitter {
    XmlFileSplitterOpts opts = new XmlFileSplitterOpts();
    private byte[] hdr;

    public XmlFileSplitterOpts Opts() {
        return this.opts;
    }

    public byte[] Hdr() {
        return this.hdr;
    }

    public void Clear() {
        this.hdr = null;
    }

    public void Split(Io_url xmlUrl) {
        boolean done;
        Io_url partDir = this.opts.PartDir();
        byte[] xmlEndTagAry = Bry_.new_u8(this.opts.XmlEnd());
        byte[][] nameAry = this.XtoByteAry(this.opts.XmlNames());
        int partIdx = 0;
        XmlSplitRdr rdr = new XmlSplitRdr().Init_(xmlUrl, this.opts.FileSizeMax());
        rdr.Read();
        int findPos = this.FindMatchPos(rdr.CurAry(), nameAry);
        if (findPos == -1) {
            throw Err_.new_wo_type("could not find any names in first segment", new Object[0]);
        }
        byte[] dataAry = this.SplitHdr(rdr.CurAry(), findPos);
        if (this.opts.XmlBgn() != null) {
            this.hdr = Bry_.new_u8(this.opts.XmlBgn());
        }
        byte[] tempAry = new byte[]{};
        int newFindPos = this.FindMatchPosRev(dataAry, nameAry);
        findPos = newFindPos <= findPos ? -1 : newFindPos;
        boolean first = true;
        XmlSplitWtr partWtr = new XmlSplitWtr().Init_(partDir, this.hdr, this.opts);
        do {
            partWtr.Bgn(partIdx++);
            if (this.opts.StatusFmt() != null) {
                Console_adp__sys.Instance.Write_str_w_nl(String_.Format(this.opts.StatusFmt(), partWtr.Url().NameOnly()));
            }
            partWtr.Write(tempAry);
            if (!first) {
                rdr.Read();
                dataAry = rdr.CurAry();
                findPos = this.FindMatchPosRev(dataAry, nameAry);
            } else {
                first = false;
            }
            while (findPos == -1) {
                if (rdr.Done()) {
                    findPos = rdr.CurRead();
                    break;
                }
                partWtr.Write(dataAry);
                rdr.Read();
                dataAry = rdr.CurAry();
                findPos = this.FindMatchPosRev(dataAry, nameAry);
            }
            byte[][] rv = this.SplitRest(dataAry, findPos);
            partWtr.Write(rv[0]);
            tempAry = rv[1];
            boolean bl = done = rdr.Done() && tempAry.length == 0;
            if (!done) {
                partWtr.Write(xmlEndTagAry);
            }
            partWtr.Rls();
        } while (!done);
        rdr.Rls();
    }

    public byte[] SplitHdr(byte[] src, int findPos) {
        this.hdr = new byte[findPos];
        Array_.Copy_to(src, 0, this.hdr, 0, findPos);
        byte[] rv = new byte[src.length - findPos];
        Array_.Copy_to(src, findPos, rv, 0, rv.length);
        return rv;
    }

    public byte[][] SplitRest(byte[] src, int findPos) {
        byte[][] rv = new byte[2][];
        rv[0] = new byte[findPos];
        Array_.Copy_to(src, 0, rv[0], 0, findPos);
        rv[1] = new byte[src.length - findPos];
        Array_.Copy_to(src, findPos, rv[1], 0, rv[1].length);
        return rv;
    }

    public int FindMatchPos(byte[] src, byte[][] wordAry) {
        return this.FindMatchPos(src, wordAry, true);
    }

    public int FindMatchPosRev(byte[] src, byte[][] wordAry) {
        return this.FindMatchPos(src, wordAry, false);
    }

    int FindMatchPos(byte[] src, byte[][] wordAry, boolean fwd) {
        int[] findAry = new int[wordAry.length];
        int i = 0;
        while (i < findAry.length) {
            findAry[i] = fwd ? -1 : Integer.MAX_VALUE;
            ++i;
        }
        i = 0;
        while (i < wordAry.length) {
            int srcDif;
            int srcEnd;
            int srcPos;
            int srcLen = src.length;
            if (fwd) {
                srcPos = 0;
                srcEnd = srcLen;
                srcDif = 1;
            } else {
                srcPos = srcLen - 1;
                srcEnd = -1;
                srcDif = -1;
            }
            while (srcPos != srcEnd) {
                int aryDif;
                int aryEnd;
                int aryPos;
                byte[] ary = wordAry[i];
                int aryLen = ary.length;
                if (fwd) {
                    aryPos = 0;
                    aryEnd = aryLen;
                    aryDif = 1;
                } else {
                    aryPos = aryLen - 1;
                    aryEnd = -1;
                    aryDif = -1;
                }
                boolean found = true;
                while (aryPos != aryEnd) {
                    int lkpPos = srcPos + aryPos;
                    if (lkpPos >= srcLen) {
                        found = false;
                        break;
                    }
                    if (ary[aryPos] != src[lkpPos]) {
                        found = false;
                        break;
                    }
                    aryPos += aryDif;
                }
                if (found) {
                    findAry[i] = srcPos;
                    break;
                }
                srcPos += srcDif;
            }
            ++i;
        }
        int best = fwd ? -1 : Integer.MAX_VALUE;
        int[] nArray = findAry;
        int n = findAry.length;
        int n2 = 0;
        while (n2 < n) {
            int find = nArray[n2];
            if (fwd && find > best || !fwd && find < best) {
                best = find;
            }
            ++n2;
        }
        if (best == Integer.MAX_VALUE) {
            best = -1;
        }
        return best;
    }

    byte[][] XtoByteAry(String[] names) {
        byte[][] rv = new byte[names.length][];
        int i = 0;
        while (i < names.length) {
            rv[i] = Bry_.new_u8(names[i]);
            ++i;
        }
        return rv;
    }
}

