/*
 * Decompiled with CFR 0.152.
 */
package gplx.langs.regxs;

import gplx.Array_;
import gplx.List_adp;
import gplx.List_adp_;
import gplx.Tfds;
import gplx.core.tests.TfdsEqListItmStr;
import gplx.langs.regxs.Regx_adp;
import gplx.langs.regxs.Regx_adp_;
import gplx.langs.regxs.Regx_bldr;
import gplx.langs.regxs.Regx_group;
import gplx.langs.regxs.Regx_match;
import org.junit.Test;

public class Regx_adp__tst
implements TfdsEqListItmStr {
    @Test
    public void Match() {
        this.tst_Match("a", "a", true);
        this.tst_Match("a", "b", false);
        this.tst_Match("a", "ab", true);
        this.tst_Match("a\\+b", "a+b", true);
        this.tst_Match("[^a]", "b", true);
    }

    void tst_Match(String find, String input, boolean expd) {
        Tfds.Eq(expd, Regx_adp_.Match(input, find));
    }

    @Test
    public void Match_all() {
        this.tst_Match_all("#REDIRECT [[Template:Error]]", "^\\p{Nd}*", 1);
        this.tst_Match_all("a", "$", 1);
    }

    void tst_Match_all(String input, String regx, int expd) {
        Tfds.Eq(expd, Regx_adp_.new_(regx).Match_all(input, 0).length);
    }

    @Test
    public void Replace() {
        this.tst_Replace("ab", "a", "b", "bb");
        this.tst_Replace("ab", "c", "b", "ab");
        this.tst_Replace("aba", "a", "b", "bbb");
    }

    void tst_Replace(String input, String find, String replace, String expd) {
        Tfds.Eq(expd, Regx_adp_.Replace(input, find, replace));
    }

    @Test
    public void Match_WholeWord() {
        this.tst_WholeWord("a", "ab a", true);
        this.tst_WholeWord("a", "ab c", false);
        this.tst_WholeWord("a", "a_", false);
        this.tst_WholeWord("[a]", "a [a] c", true);
        this.tst_WholeWord("[a]", "a[a]c", false);
    }

    void tst_WholeWord(String regx, String text, boolean expd) {
        Tfds.Eq(expd, Regx_adp_.Match(text, Regx_bldr.WholeWord(regx)));
    }

    @Test
    public void Match_As() {
        this.tst_Regx("public static [A-Za-z0-9_]+ as_\\(Object obj\\)", "public static Obj1 as_(Object obj) {return obj instanceof Obj1 ? (Obj1)obj : null;}", true);
        this.tst_Regx("public static [A-Za-z0-9_]+ as_\\(Object obj\\)", "public static boolean Asterisk(Object obj) {}", false);
    }

    void tst_Regx(String regx, String text, boolean expd) {
        Tfds.Eq(expd, Regx_adp_.Match(text, regx));
    }

    @Test
    public void Find() {
        this.tst_Matches("b", "a b c b a", this.match_(2, 1), this.match_(6, 1));
        this.tst_Matches("d", "a b c b a", new Regx_match[0]);
        this.tst_Matches("b", "a b c b a b b", this.matches_(2, 6, 10, 12));
    }

    @Test
    public void Groups() {
        this.tst_Groups("abc def ghi dz", "(d\\p{L}+)", "def", "dz");
    }

    Regx_match[] matches_(int ... bgnAry) {
        int aryLen = Array_.Len(bgnAry);
        Regx_match[] rv = new Regx_match[aryLen];
        int i = 0;
        while (i < aryLen) {
            rv[i] = this.match_(bgnAry[i]);
            ++i;
        }
        return rv;
    }

    Regx_match match_(int bgn) {
        return this.match_(bgn, Integer.MIN_VALUE);
    }

    Regx_match match_(int bgn, int len) {
        return new Regx_match(true, bgn, bgn + len, Regx_group.Ary_empty);
    }

    void tst_Matches(String find, String input, Regx_match ... expd) {
        List_adp expdList = Array_.To_list(expd);
        List_adp actlList = Regx_adp_.Find_all(input, find);
        Tfds.Eq_list(expdList, actlList, this);
    }

    void tst_Groups(String text, String regx, String ... expd) {
        Regx_adp regx_mgr = Regx_adp_.new_(regx);
        Regx_match[] rslts = regx_mgr.Match_all(text, 0);
        Tfds.Eq_ary_str(expd, this.To_ary(rslts));
    }

    String[] To_ary(Regx_match[] ary) {
        List_adp rv = List_adp_.New();
        int len = ary.length;
        int i = 0;
        while (i < len) {
            Regx_match itm = ary[i];
            int cap_len = itm.Groups().length;
            int j = 0;
            while (j < cap_len) {
                rv.Add(itm.Groups()[j].Val());
                ++j;
            }
            ++i;
        }
        return rv.To_str_ary();
    }

    @Override
    public String To_str(Object curObj, Object expdObj) {
        Regx_match cur = (Regx_match)curObj;
        Regx_match expd = (Regx_match)expdObj;
        String rv = "bgn=" + cur.Find_bgn();
        if (expd != null && expd.Find_len() != Integer.MIN_VALUE) {
            rv = String.valueOf(rv) + " len=" + cur.Find_len();
        }
        return rv;
    }
}

