/*
 * Decompiled with CFR 0.152.
 */
package gplx.langs.dsvs;

import gplx.Internal;
import gplx.core.gfo_ndes.GfoFld;
import gplx.core.gfo_ndes.GfoFldList;
import gplx.core.gfo_ndes.GfoFldList_;
import gplx.core.stores.DataWtr;
import gplx.core.stores.DataWtr_base;
import gplx.core.stores.SrlMgr;
import gplx.langs.dsvs.DsvHeaderItm;
import gplx.langs.dsvs.DsvStoreLayout;
import gplx.langs.dsvs.DsvStringBldr;
import gplx.langs.dsvs.DsvSymbols;

public class DsvDataWtr
extends DataWtr_base
implements DataWtr {
    DsvStringBldr sb;
    DsvSymbols sym = DsvSymbols.default_();
    DsvStoreLayout layout = DsvStoreLayout.csv_dat_();

    @Override
    public void InitWtr(String key, Object val) {
        if (key == "StoreLayoutWtr") {
            this.layout = (DsvStoreLayout)val;
        }
    }

    @Override
    public void WriteData(String name, Object val) {
        this.sb.WriteFld(val == null ? null : val.toString());
    }

    @Override
    public void WriteLeafBgn(String leafName) {
    }

    @Override
    public void WriteLeafEnd() {
        this.sb.WriteRowSep();
    }

    @Override
    public void WriteNodeBgn(String name) {
        this.WriteTableBgn(name, GfoFldList_.Null);
    }

    @Override
    public void WriteTableBgn(String name, GfoFldList flds) {
        int i = 0;
        while (i < this.layout.HeaderList().Count()) {
            DsvHeaderItm data = this.layout.HeaderList().Get_at(i);
            int id = data.Id();
            if (id == 2) {
                this.WriteTableName(name);
            } else if (id == 5) {
                this.WriteMeta(flds, true, this.sym.FldNamesSym());
            } else if (id == 4) {
                this.WriteMeta(flds, false, this.sym.FldTypesSym());
            } else if (id == 3) {
                this.sb.WriteRowSep();
            } else if (id == 1) {
                this.WriteComment(data.Val().toString());
            }
            ++i;
        }
    }

    @Override
    public void WriteNodeEnd() {
    }

    @Override
    public void Clear() {
        this.sb.Clear();
    }

    @Override
    public String To_str() {
        return this.sb.To_str();
    }

    void WriteTableName(String tableName) {
        this.sb.WriteFld(tableName);
        this.sb.WriteCmd(this.sym.TblNameSym());
        this.sb.WriteRowSep();
    }

    void WriteMeta(GfoFldList flds, boolean isName, String cmd) {
        int i = 0;
        while (i < flds.Count()) {
            GfoFld fld = flds.Get_at(i);
            String val = isName ? fld.Key() : fld.Type().Key();
            this.sb.WriteFld(val);
            ++i;
        }
        if (this.layout.WriteCmdSequence()) {
            this.sb.WriteCmd(cmd);
        }
        this.sb.WriteRowSep();
    }

    void WriteComment(String comment) {
        this.sb.WriteFld(comment);
        this.sb.WriteCmd(this.sym.CommentSym());
        this.sb.WriteRowSep();
    }

    @Override
    public SrlMgr SrlMgr_new(Object o) {
        return new DsvDataWtr();
    }

    @Internal
    protected DsvDataWtr() {
        this.sb = DsvStringBldr.new_(this.sym);
    }
}

