/*
 * Decompiled with CFR 0.152.
 */
package gplx.langs.dsvs;

import gplx.core.gfo_ndes.GfoFldList_;
import gplx.core.type_xtns.IntClassXtn;
import gplx.core.type_xtns.StringClassXtn;
import gplx.langs.dsvs.DsvDataRdr_fxt;
import org.junit.Before;
import org.junit.Test;

public class DsvDataRdr_dsv_misc_tst {
    DsvDataRdr_fxt fx = DsvDataRdr_fxt.new_();

    @Before
    public void setup() {
        this.fx.Clear();
    }

    @Test
    public void CmdDlm_NearMatches() {
        this.fx.run_parse_("a, ,b");
        this.fx.tst_DatCsv(new Object[][]{this.fx.ary_("a", " ", "b")});
        this.fx.Clear();
        this.fx.run_parse_("a,\" \",b");
        this.fx.tst_DatCsv(new Object[][]{this.fx.ary_("a", " ", "b")});
        this.fx.Clear();
        this.fx.run_parse_("a, ,b,\" \",c");
        this.fx.tst_DatCsv(new Object[][]{this.fx.ary_("a", " ", "b", " ", "c")});
        this.fx.Clear();
    }

    @Test
    public void CmdDlm_DoNotSpanLines() {
        this.fx.run_parse_lines_("a, ", "\" \",b");
        this.fx.tst_DatCsv(this.fx.ary_("a", " "), this.fx.ary_(" ", "b"));
    }

    @Test
    public void CmdDlm_SecondFldMustBeQuoted() {
        this.fx.run_parse_lines_("a, , ,b");
        this.fx.tst_DatCsv(new Object[][]{this.fx.ary_("a", " ", " ", "b")});
    }

    @Test
    public void Null_Int() {
        this.fx.run_parse_("int,string, ,\" \",$", "\r\n", ",val1");
        this.fx.tst_Tbls("");
        this.fx.tst_Flds(0, GfoFldList_.new_().Add("fld0", IntClassXtn.Instance).Add("fld1", StringClassXtn.Instance));
        this.fx.tst_Dat(0, new Object[][]{this.fx.ary_(null, "val1")});
    }

    @Test
    public void Null_String() {
        this.fx.run_parse_("string,string, ,\" \",$", "\r\n", ",val1");
        this.fx.tst_Tbls("");
        this.fx.tst_Flds(0, GfoFldList_.new_().Add("fld0", StringClassXtn.Instance).Add("fld1", StringClassXtn.Instance));
        this.fx.tst_Dat(0, new Object[][]{this.fx.ary_(null, "val1")});
    }

    @Test
    public void EmptyString() {
        this.fx.run_parse_("string,string, ,\" \",$", "\r\n", "\"\",val1");
        this.fx.tst_Tbls("");
        this.fx.tst_Flds(0, GfoFldList_.new_().Add("fld0", StringClassXtn.Instance).Add("fld1", StringClassXtn.Instance));
        this.fx.tst_Dat(0, new Object[][]{this.fx.ary_("", "val1")});
    }
}

