/*
 * Decompiled with CFR 0.152.
 */
package gplx.langs.dsvs;

import gplx.Err;
import gplx.Err_;
import gplx.String_;
import gplx.Tfds;
import gplx.core.gfo_ndes.GfoFldList_;
import gplx.langs.dsvs.DsvDataRdr_fxt;
import gplx.langs.dsvs.DsvParser;
import org.junit.Before;
import org.junit.Test;

public class DsvDataRdr_csv_dat_tst {
    DsvDataRdr_fxt fx = DsvDataRdr_fxt.new_();

    @Before
    public void setup() {
        this.fx.Parser_(DsvParser.csv_(false, GfoFldList_.Null));
        this.fx.Clear();
    }

    @Test
    public void Empty() {
        this.fx.run_parse_("");
        this.fx.tst_DatNull();
    }

    @Test
    public void Fld_0() {
        this.fx.run_parse_("a");
        this.fx.tst_DatCsv(new Object[][]{this.fx.ary_("a")});
    }

    @Test
    public void Fld_N() {
        this.fx.run_parse_("a,b,c");
        this.fx.tst_FldListCsv("fld0", "fld1", "fld2");
        this.fx.tst_DatCsv(new Object[][]{this.fx.ary_("a", "b", "c")});
    }

    @Test
    public void Row_N() {
        this.fx.run_parse_("a,b,c", "\r\n", "1,2,3");
        this.fx.tst_DatCsv(this.fx.ary_("a", "b", "c"), this.fx.ary_("1", "2", "3"));
    }

    @Test
    public void Escape_WhiteSpace() {
        this.fx.run_parse_("a,\" \t\",c");
        this.fx.tst_DatCsv(new Object[][]{this.fx.ary_("a", " \t", "c")});
    }

    @Test
    public void Escape_FldSep() {
        this.fx.run_parse_("a,\",\",c");
        this.fx.tst_DatCsv(new Object[][]{this.fx.ary_("a", ",", "c")});
    }

    @Test
    public void Escape_RowSep() {
        this.fx.run_parse_("a,\"\r\n\",c");
        this.fx.tst_DatCsv(new Object[][]{this.fx.ary_("a", "\r\n", "c")});
    }

    @Test
    public void Escape_Quote() {
        this.fx.run_parse_("a,\"\"\"\",c");
        this.fx.tst_DatCsv(new Object[][]{this.fx.ary_("a", "\"", "c")});
    }

    @Test
    public void Blank_Null() {
        this.fx.run_parse_("a,,c");
        this.fx.tst_DatCsv(new Object[][]{this.fx.ary_("a", null, "c")});
    }

    @Test
    public void Blank_EmptyString() {
        this.fx.run_parse_("a,\"\",c");
        this.fx.tst_DatCsv(new Object[][]{this.fx.ary_("a", "", "c")});
    }

    @Test
    public void Blank_Null_Multiple() {
        this.fx.run_parse_(",,");
        this.fx.tst_DatCsv(new Object[][]{this.fx.ary_(null, null, null)});
    }

    @Test
    public void TrailingNull() {
        this.fx.run_parse_("a,");
        this.fx.tst_DatCsv(new Object[][]{this.fx.ary_("a", null)});
    }

    @Test
    public void TrailingEmpty() {
        this.fx.run_parse_("a,\"\"");
        this.fx.tst_DatCsv(new Object[][]{this.fx.ary_("a", "")});
    }

    @Test
    public void Quote_Error() {
        try {
            this.fx.run_parse_("a,\"\" ,c");
            Tfds.Fail_expdError();
        }
        catch (Err e) {
            Tfds.Eq_true(String_.Has(Err_.Message_lang(e), "invalid quote in quoted field"));
        }
    }

    @Test
    public void Misc_AllowValsLessThanFields() {
        this.fx.run_parse_("a0,a1", "\r\n", "b0");
        this.fx.tst_DatCsv(this.fx.ary_("a0", "a1"), this.fx.ary_("b0", null));
    }

    @Test
    public void Misc_NewLineValidForSingleColumnTables() {
        this.fx.run_parse_("a", "\r\n", "\r\n", "c", "\r\n", "\r\n");
        this.fx.tst_DatCsv(this.fx.ary_("a"), this.fx.ary_null_(), this.fx.ary_("c"), this.fx.ary_null_());
    }

    @Test
    public void Misc_NewLineValidForSingleColumnTables_FirstLine() {
        this.fx.run_parse_("\r\n", "b", "\r\n", "c");
        this.fx.tst_DatCsv(this.fx.ary_null_(), this.fx.ary_("b"), this.fx.ary_("c"));
    }

    @Test
    public void Hdr_Basic() {
        this.fx.Parser_(DsvParser.csv_(true, GfoFldList_.Null));
        this.fx.run_parse_("id,name", "\r\n", "0,me");
        this.fx.tst_FldListCsv("id", "name");
        this.fx.tst_DatCsv(new Object[][]{this.fx.ary_("0", "me")});
    }
}

