/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.times;

import gplx.Decimal_adp_;
import gplx.Tfds;
import gplx.Time_span;
import gplx.Time_span_;
import org.junit.Test;

public class Time_span__basic_tst {
    @Test
    public void seconds_() {
        Time_span expd = Time_span_.fracs_(123987L);
        Time_span actl = Time_span_.seconds_(123.987);
        Tfds.Eq(expd, actl);
    }

    @Test
    public void TotalSecs() {
        Time_span val = Time_span_.fracs_(1987L);
        Tfds.Eq_decimal(Decimal_adp_.parts_(1L, 987), val.Total_secs());
    }

    @Test
    public void Units() {
        this.tst_Units("01:02:03.987", 1, 2, 3, 987);
        this.tst_Units("01:00:03", 1, 0, 3, 0);
        this.tst_Units("01:00:00.987", 1, 0, 0, 987);
        this.tst_Units("02:00.987", 0, 2, 0, 987);
    }

    @Test
    public void Add() {
        Time_span val = Time_span_.fracs_(3L);
        Time_span arg = Time_span_.fracs_(2L);
        Time_span expd = Time_span_.fracs_(5L);
        Time_span actl = val.Add(arg);
        Tfds.Eq(expd, actl);
    }

    @Test
    public void Subtract() {
        Time_span val = Time_span_.fracs_(3L);
        Time_span arg = Time_span_.fracs_(2L);
        Time_span expd = Time_span_.fracs_(1L);
        Time_span actl = val.Subtract(arg);
        Tfds.Eq(expd, actl);
    }

    @Test
    public void Add_unit_identity() {
        this.tst_AddUnit("00:00:01.000", 0, 0, "00:00:01.000");
    }

    @Test
    public void Add_unit_basic() {
        this.tst_AddUnit("01:59:58.987", 0, 1013, "02:00:00.000");
        this.tst_AddUnit("01:59:58.987", 1, 2, "02:00:00.987");
        this.tst_AddUnit("01:59:58.987", 2, 1, "02:00:58.987");
        this.tst_AddUnit("01:59:58.987", 3, 1, "02:59:58.987");
    }

    @Test
    public void Add_unit_negative() {
        this.tst_AddUnit("01:00:00.00", 0, -1, "00:59:59.999");
        this.tst_AddUnit("01:00:00.00", 1, -1, "00:59:59.000");
        this.tst_AddUnit("01:00:00.00", 2, -1, "00:59:00.000");
        this.tst_AddUnit("01:00:00.00", 3, -1, "00:00:00.000");
    }

    @Test
    public void XtoStrUiAbbrv() {
        this.tst_XtoStrUiAbbrv("01:02:03.004", "1h 2m 3s 4f");
        this.tst_XtoStrUiAbbrv("00:00:03.004", "3s 4f");
        this.tst_XtoStrUiAbbrv("00:00:03.000", "3s 0f");
        this.tst_XtoStrUiAbbrv("11:22:33.444", "11h 22m 33s 444f");
        this.tst_XtoStrUiAbbrv("00:00:00.000", "0f");
    }

    void tst_XtoStrUiAbbrv(String raw, String expd) {
        Tfds.Eq(expd, Time_span_.parse(raw).XtoStrUiAbbrv());
    }

    void tst_AddUnit(String valRaw, int unitIdx, int delta, String expdRaw) {
        Time_span val = Time_span_.parse(valRaw);
        Time_span actl = val.Add_unit(unitIdx, delta);
        Tfds.Eq(Time_span_.parse(expdRaw), actl);
    }

    void tst_Units(String text, int ... expd) {
        Time_span val = Time_span_.parse(text);
        int hour = 0;
        int min = 0;
        int sec = 0;
        int frac = 0;
        int[] ary = val.Units();
        hour = ary[3];
        min = ary[2];
        sec = ary[1];
        frac = ary[0];
        Tfds.Eq(expd[0], hour);
        Tfds.Eq(expd[1], min);
        Tfds.Eq(expd[2], sec);
        Tfds.Eq(expd[3], frac);
    }
}

