/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.threads.poolables;

import gplx.Array_;
import gplx.Err_;
import gplx.Internal;
import gplx.core.memorys.Gfo_memory_itm;
import gplx.core.memorys.Gfo_memory_mgr;
import gplx.core.threads.poolables.Gfo_poolable_itm;

public class Gfo_poolable_mgr
implements Gfo_memory_itm {
    private final Object thread_lock = new Object();
    private final Gfo_poolable_itm prototype;
    private final Object[] make_args;
    private Gfo_poolable_itm[] pool;
    private int pool_nxt;
    private int pool_len;
    private int[] free_ary;
    private int free_len;

    public Gfo_poolable_mgr(Gfo_poolable_itm prototype, Object[] make_args, int init_pool_len, int pool_max) {
        this.prototype = prototype;
        this.make_args = make_args;
        this.pool_len = init_pool_len;
        this.Clear_fast();
    }

    @Override
    public void Rls_mem() {
        this.Clear_safe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Clear_safe() {
        Object object = this.thread_lock;
        synchronized (object) {
            this.Clear_fast();
        }
    }

    public void Clear_fast() {
        this.pool = new Gfo_poolable_itm[this.pool_len];
        int i = 0;
        while (i < this.pool_len) {
            this.pool[i] = this.prototype.Pool__make(this, i, this.make_args);
            ++i;
        }
        this.free_ary = new int[this.pool_len];
        this.free_len = 0;
        this.pool_nxt = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Gfo_poolable_itm Get_safe() {
        Object object = this.thread_lock;
        synchronized (object) {
            return this.Get_fast();
        }
    }

    public Gfo_poolable_itm Get_fast() {
        Gfo_poolable_itm rv = null;
        int pool_idx = -1;
        if (this.free_len > 0) {
            pool_idx = this.free_ary[--this.free_len];
            rv = this.pool[pool_idx];
        } else {
            if (this.pool_nxt == this.pool_len) {
                this.Expand_pool();
            }
            if ((rv = this.pool[pool_idx = this.pool_nxt++]) == null) {
                this.pool[pool_idx] = rv = this.prototype.Pool__make(this, pool_idx, this.make_args);
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Rls_safe(int idx) {
        Object object = this.thread_lock;
        synchronized (object) {
            this.Rls_fast(idx);
        }
    }

    public void Rls_fast(int idx) {
        if (idx == -1) {
            throw Err_.new_wo_type("rls called on poolable that was not created by pool_mgr", new Object[0]);
        }
        int pool_idx = this.pool_nxt - 1;
        if (idx == pool_idx) {
            if (this.free_len == 0) {
                this.pool_nxt = pool_idx;
            } else {
                int i = 0;
                while (i < this.free_len) {
                    this.free_ary[i] = 0;
                    ++i;
                }
                this.free_len = 0;
            }
        } else {
            this.free_ary[this.free_len] = idx;
            ++this.free_len;
        }
    }

    private void Expand_pool() {
        int new_pool_len = this.pool_len == 0 ? 2 : this.pool_len * 2;
        Gfo_poolable_itm[] new_pool = new Gfo_poolable_itm[new_pool_len];
        Array_.Copy_to(this.pool, 0, new_pool, 0, this.pool_len);
        this.pool = new_pool;
        this.pool_len = new_pool_len;
        int[] new_free = new int[this.pool_len];
        Array_.Copy_to(this.free_ary, 0, new_free, 0, this.free_len);
        this.free_ary = new_free;
    }

    @Internal
    protected int[] Free_ary() {
        return this.free_ary;
    }

    @Internal
    protected int Free_len() {
        return this.free_len;
    }

    @Internal
    protected int Pool_len() {
        return this.pool_len;
    }

    @Internal
    protected int Pool_nxt() {
        return this.pool_nxt;
    }

    public static Gfo_poolable_mgr New_rlsable(Gfo_poolable_itm prototype, Object[] make_args, int init_pool_len, int pool_max) {
        Gfo_poolable_mgr rv = new Gfo_poolable_mgr(prototype, make_args, init_pool_len, pool_max);
        Gfo_memory_mgr.Instance.Reg_safe(rv);
        return rv;
    }
}

