/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.threads;

import gplx.GfoMsg;
import gplx.Gfo_invk;
import gplx.Gfo_invk_;
import gplx.GfsCtx;
import gplx.core.envs.System_;
import gplx.core.threads.Thread_adp;
import gplx.core.threads.Thread_adp_;
import gplx.core.threads.Thread_adp_mgr;
import gplx.core.threads.Thread_halt_cbk;
import gplx.core.threads.Thread_halt_itm;

class Thread_halt_wkr
implements Gfo_invk {
    private final Thread_adp_mgr mgr;
    private final Thread_adp thread;
    private final String thread_key;
    private final Thread_halt_cbk cbk;
    private final long bgn_time;
    private final int sleep_time;
    private final int quit_time;
    public static final String Invk__halt = "halt";

    public Thread_halt_wkr(Thread_adp_mgr mgr, Thread_halt_itm itm, Thread_halt_cbk cbk, int sleep_time, int quit_time) {
        this.mgr = mgr;
        this.thread = itm.Thread;
        this.thread_key = itm.Key;
        this.cbk = cbk;
        this.sleep_time = sleep_time;
        this.quit_time = quit_time;
        this.bgn_time = System_.Ticks();
    }

    private void Halt() {
        boolean interrupted;
        this.thread.Thread__cancel();
        while (true) {
            long time_now = System_.Ticks();
            boolean halted = false;
            interrupted = false;
            if (this.thread.Thread__is_alive()) {
                if (!this.thread.Thread__cancelable() || time_now > this.bgn_time + (long)this.quit_time) {
                    this.thread.Thread__interrupt();
                    interrupted = true;
                    halted = true;
                }
            } else {
                halted = true;
            }
            if (halted) break;
            Thread_adp_.Sleep(this.sleep_time);
        }
        this.cbk.Thread__on_halt(interrupted);
        this.mgr.Del(this.thread_key);
    }

    @Override
    public Object Invk(GfsCtx ctx, int ikey, String k, GfoMsg m) {
        if (!ctx.Match(k, Invk__halt)) {
            return Gfo_invk_.Rv_unhandled;
        }
        this.Halt();
        return this;
    }
}

